/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.session.impl;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.exceptions.AlfrescoSessionException;
import org.alfresco.mobile.android.api.exceptions.impl.ExceptionHelper;
import org.alfresco.mobile.android.api.model.Folder;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.RepositoryInfo;
import org.alfresco.mobile.android.api.model.impl.FolderImpl;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.model.impl.cloud.CloudRepositoryInfoImpl;
import org.alfresco.mobile.android.api.network.NetworkHttpInvoker;
import org.alfresco.mobile.android.api.services.impl.cloud.CloudServiceRegistry;
import org.alfresco.mobile.android.api.session.CloudNetwork;
import org.alfresco.mobile.android.api.session.CloudSession;
import org.alfresco.mobile.android.api.session.authentication.AuthenticationProvider;
import org.alfresco.mobile.android.api.session.authentication.OAuthAuthenticationProvider;
import org.alfresco.mobile.android.api.session.authentication.OAuthData;
import org.alfresco.mobile.android.api.session.authentication.impl.OAuth2AuthenticationProviderImpl;
import org.alfresco.mobile.android.api.session.authentication.impl.PassthruAuthenticationProviderImpl;
import org.alfresco.mobile.android.api.session.impl.CloudNetworkImpl;
import org.alfresco.mobile.android.api.utils.CloudUrlRegistry;
import org.alfresco.mobile.android.api.utils.PublicAPIResponse;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

public class CloudSessionImpl
extends CloudSession {
    private static final String CLOUD_BASIC_AUTH = "org.alfresco.mobile.binding.internal.cloud.basic";
    private static final String TAG = "CloudSessionImpl";
    private CloudNetwork currentNetwork;
    public static final Parcelable.Creator<CloudSessionImpl> CREATOR = new Parcelable.Creator<CloudSessionImpl>(){

        public CloudSessionImpl createFromParcel(Parcel in) {
            return new CloudSessionImpl(in);
        }

        public CloudSessionImpl[] newArray(int size) {
            return new CloudSessionImpl[size];
        }
    };

    public CloudSessionImpl() {
    }

    public CloudSessionImpl(OAuthData oauthData, Map<String, Serializable> parameters) {
        HashMap<String, Serializable> tmpProperties = new HashMap<String, Serializable>();
        if (parameters != null) {
            tmpProperties.putAll(parameters);
        }
        if (oauthData != null && !tmpProperties.containsKey("org.alfresco.mobile.internal.credential.user")) {
            tmpProperties.put("org.alfresco.mobile.internal.credential.user", (Serializable)((Object)"-me-"));
        }
        this.initSettings("https://api.alfresco.com", tmpProperties);
        if (oauthData != null) {
            this.authenticate(new OAuth2AuthenticationProviderImpl(oauthData));
        } else if (this.hasParameter(CLOUD_BASIC_AUTH)) {
            this.authenticate(null);
        } else {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "OAuthData"));
        }
    }

    private void authenticate(AuthenticationProvider authProvider) {
        try {
            this.authenticator = authProvider == null ? this.createAuthenticationProvider((String)this.userParameters.get("org.alfresco.mobile.api.authenticator.classname")) : authProvider;
            PagingResult<CloudNetwork> networks = this.getPagingNetworks();
            if (networks == null || networks.getTotalItems() == 0) {
                throw new AlfrescoSessionException(107, Messagesl18n.getString("SESSION_NO_NETWORK_FOUND"));
            }
            String networkIdentifier = null;
            if (this.hasParameter("org.alfresco.mobile.bindings.api.cloud.network.id")) {
                networkIdentifier = (String)((Object)this.getParameter("org.alfresco.mobile.bindings.api.cloud.network.id"));
            }
            List<CloudNetwork> listNetworks = networks.getList();
            for (CloudNetwork cloudNetwork : listNetworks) {
                if (cloudNetwork.isHomeNetwork() && ((CloudNetworkImpl)cloudNetwork).isEnabled().booleanValue() && networkIdentifier == null) {
                    this.currentNetwork = cloudNetwork;
                    break;
                }
                if (networkIdentifier != null && networkIdentifier.equals(cloudNetwork.getIdentifier())) {
                    this.currentNetwork = cloudNetwork;
                    break;
                }
                if (cloudNetwork.isHomeNetwork() || !((CloudNetworkImpl)cloudNetwork).isEnabled().booleanValue()) continue;
                this.currentNetwork = cloudNetwork;
            }
            if (this.currentNetwork == null) {
                throw new AlfrescoSessionException(107, Messagesl18n.getString("SESSION_NO_NETWORK_FOUND"));
            }
            this.addParameter("org.alfresco.mobile.bindings.api.cloud.network.id", (Serializable)((Object)this.currentNetwork.getIdentifier()));
            Map<String, String> param = this.retrieveSessionParameters();
            this.cmisSession = this.createSession((SessionFactory)SessionFactoryImpl.newInstance(), this.authenticator, param);
            try {
                if (this.cmisSession.getRootFolder() != null) {
                    this.rootNode = new FolderImpl((CmisObject)this.cmisSession.getRootFolder());
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Unable to retrieve rootNode folder");
                Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            }
            this.repositoryInfo = new CloudRepositoryInfoImpl(this.cmisSession.getRepositoryInfo());
            this.create();
        }
        catch (Exception e) {
            throw new AlfrescoSessionException(100, (Throwable)e);
        }
    }

    private void create() {
        this.services = this.hasParameter("org.alfresco.mobile.api.services.cloud") ? this.createServiceRegistry((String)((Object)this.getParameter("org.alfresco.mobile.api.services.cloud"))) : new CloudServiceRegistry(this);
        this.passThruAuthenticator = this.cmisSession.getBinding().getAuthenticationProvider();
        this.authenticator = ((PassthruAuthenticationProviderImpl)this.passThruAuthenticator).getAlfrescoAuthenticationProvider();
    }

    private AuthenticationProvider createAuthenticationProvider(String className) {
        AuthenticationProvider s = null;
        try {
            Class<?> c = Class.forName(className);
            Constructor<?> t = c.getDeclaredConstructor(Map.class);
            s = (AuthenticationProvider)t.newInstance(this.userParameters);
        }
        catch (Exception e) {
            throw new AlfrescoSessionException(108, (Throwable)e);
        }
        return s;
    }

    private PagingResult<CloudNetwork> getPagingNetworks() {
        UrlBuilder builder = new UrlBuilder(CloudUrlRegistry.getUserNetworks(this.baseUrl));
        Response resp = NetworkHttpInvoker.invokeGET(builder, this.authenticator.getHTTPHeaders());
        if (resp.getResponseCode() != 200) {
            ExceptionHelper.convertStatusCode(null, resp, 100);
        }
        PublicAPIResponse response = new PublicAPIResponse(resp);
        ArrayList<CloudNetworkImpl> result = new ArrayList<CloudNetworkImpl>();
        Map data = null;
        for (Object entry : response.getEntries()) {
            data = (Map)((Map)entry).get("entry");
            result.add(CloudNetworkImpl.parsePublicAPIJson(data));
        }
        return new PagingResultImpl<CloudNetwork>(result, response.getHasMoreItems(), response.getSize());
    }

    @Override
    public List<CloudNetwork> getNetworks() {
        return this.getPagingNetworks().getList();
    }

    @Override
    public CloudNetwork getNetwork() {
        return this.currentNetwork;
    }

    protected void switchNetwork(CloudNetwork network) {
        this.currentNetwork = network;
    }

    @Override
    public void setOAuthData(OAuthData data) {
        if (this.authenticator != null && this.authenticator instanceof OAuthAuthenticationProvider && data instanceof OAuthData) {
            ((OAuthAuthenticationProvider)this.authenticator).setOAuthData(data);
        }
    }

    @Override
    public OAuthData getOAuthData() {
        if (this.authenticator != null && this.authenticator instanceof OAuthAuthenticationProvider) {
            return ((OAuthAuthenticationProvider)this.authenticator).getOAuthData();
        }
        return null;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int arg1) {
        dest.writeString(this.baseUrl);
        dest.writeString(this.userIdentifier);
        dest.writeString(this.password);
        dest.writeSerializable((Serializable)this.currentNetwork);
        dest.writeParcelable((Parcelable)this.rootNode, 1);
        dest.writeSerializable((Serializable)this.repositoryInfo);
        dest.writeSerializable((Serializable)this.cmisSession);
        Bundle b = new Bundle();
        b.putSerializable("userParameters", (Serializable)((Object)this.userParameters));
        dest.writeBundle(b);
    }

    public CloudSessionImpl(Parcel o) {
        this.baseUrl = o.readString();
        this.userIdentifier = o.readString();
        this.password = o.readString();
        this.currentNetwork = (CloudNetwork)o.readSerializable();
        this.rootNode = (Folder)o.readParcelable(FolderImpl.class.getClassLoader());
        this.repositoryInfo = (RepositoryInfo)o.readSerializable();
        this.cmisSession = (Session)o.readSerializable();
        Bundle b = o.readBundle();
        this.userParameters = (Map)((Object)b.getSerializable("userParameters"));
        this.create();
    }
}

