/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.session.impl;

import java.util.GregorianCalendar;
import java.util.Map;
import org.alfresco.mobile.android.api.session.CloudNetwork;
import org.alfresco.mobile.android.api.utils.DateUtils;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;

public class CloudNetworkImpl
implements CloudNetwork {
    private static final long serialVersionUID = 1L;
    private String identifier;
    private String subscriptionLevel;
    private boolean isPaidNetwork;
    private boolean isHomeNetwork;
    private GregorianCalendar creationTime;
    private Boolean isEnabled;

    public static CloudNetworkImpl parsePublicAPIJson(Map<String, Object> json) {
        CloudNetworkImpl network = new CloudNetworkImpl();
        network.identifier = JSONConverter.getString(json, (String)"id");
        network.isEnabled = JSONConverter.getBoolean(json, (String)"isEnabled");
        network.isHomeNetwork = JSONConverter.getBoolean(json, (String)"homeNetwork");
        Map<String, Object> jso = (Map<String, Object>)json.get("network");
        if (jso == null) {
            jso = json;
        }
        if (jso.containsKey("id")) {
            network.identifier = JSONConverter.getString(jso, (String)"id");
        }
        network.subscriptionLevel = JSONConverter.getString(jso, (String)"subscriptionLevel");
        network.isPaidNetwork = JSONConverter.getBoolean(jso, (String)"paidNetwork");
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(DateUtils.parseJsonDate(JSONConverter.getString(jso, (String)"createdAt")));
        network.creationTime = g;
        return network;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getSubscriptionLevel() {
        return this.subscriptionLevel;
    }

    @Override
    public boolean isPaidNetwork() {
        return this.isPaidNetwork;
    }

    @Override
    public boolean isHomeNetwork() {
        return this.isHomeNetwork;
    }

    @Override
    public GregorianCalendar getCreatedAt() {
        return this.creationTime;
    }

    @Deprecated
    public Boolean isEnabled() {
        return this.isEnabled;
    }
}

