/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.session.impl;

import android.os.Parcelable;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.mobile.android.api.exceptions.AlfrescoSessionException;
import org.alfresco.mobile.android.api.model.Folder;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.RepositoryInfo;
import org.alfresco.mobile.android.api.network.NetworkHttpInvoker;
import org.alfresco.mobile.android.api.services.ServiceRegistry;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.CloudSession;
import org.alfresco.mobile.android.api.session.RepositorySession;
import org.alfresco.mobile.android.api.session.authentication.impl.BasicAuthenticationProviderImpl;
import org.alfresco.mobile.android.api.session.authentication.impl.PassthruAuthenticationProviderImpl;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;

public abstract class AbstractAlfrescoSessionImpl
implements AlfrescoSession,
Parcelable {
    public static final String DEFAULT_CACHE_FOLDER_PATH = "/sdcard/Android/data/org.alfresco.mobile.android.sdk/cache";
    protected String baseUrl;
    protected String userIdentifier;
    protected String password;
    protected Folder rootNode;
    protected ServiceRegistry services;
    protected RepositoryInfo repositoryInfo;
    protected Session cmisSession;
    protected org.alfresco.mobile.android.api.session.authentication.AuthenticationProvider authenticator;
    protected AuthenticationProvider passThruAuthenticator;
    protected Map<String, Serializable> userParameters;
    private Map<String, String> sessionParameters = new HashMap<String, String>();
    private ListingContext lc;
    private boolean forceBinding = false;
    protected boolean hasPublicAPI = false;
    private static final String BINDING_TYPE = "org.alfresco.mobile.internal.binding";
    private static final int BINDING_TYPE_CMIS = 1;
    private static final int BINDING_TYPE_ALFRESCO_CMIS = 2;
    private static final int BINDING_TYPE_ALFRESCO_PUBLIC_API = 3;
    private static final int BINDING_TYPE_ALFRESCO_CLOUD = 4;
    private static final String BINDING_URL = "org.alfresco.mobile.binding.internal.url";
    private static final String BASE_URL = "org.alfresco.mobile.binding.internal.baseurl";
    protected static final String USER = "org.alfresco.mobile.internal.credential.user";
    protected static final String PASSWORD = "org.alfresco.mobile.internal.credential.password";
    private static final String ONPREMISE_TRUSTMANAGER_CLASSNAME = "org.alfresco.mobile.binding.internal.https.trustmanager";

    protected void initSettings(String url, Map<String, Serializable> settings) {
        String tmpuser = null;
        String tmppassword = null;
        String tmpurl = url;
        if (settings.containsKey(USER)) {
            tmpuser = (String)((Object)settings.get(USER));
        }
        if (settings.containsKey(PASSWORD)) {
            tmppassword = (String)((Object)settings.get(PASSWORD));
        }
        if (settings.containsKey(BASE_URL)) {
            tmpurl = (String)((Object)settings.get(BASE_URL));
        }
        this.initSettings(tmpurl, tmpuser, tmppassword, settings);
    }

    protected void initSettings(String url, String username, String password, Map<String, Serializable> settings) {
        if (url == null) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "url"));
        }
        HashMap<String, Serializable> tmpSettings = new HashMap<String, Serializable>();
        if (settings != null) {
            tmpSettings.putAll(settings);
        }
        if (username != null && username.length() > 0) {
            tmpSettings.put("org.apache.chemistry.opencmis.user", (Serializable)((Object)username));
            this.userIdentifier = username;
        }
        if (password != null && password.length() > 0) {
            tmpSettings.put("org.apache.chemistry.opencmis.password", (Serializable)((Object)password));
            this.password = password;
        }
        this.baseUrl = url;
        tmpSettings.put(BASE_URL, (Serializable)((Object)url));
        if (!tmpSettings.containsKey("org.alfresco.mobile.cache.folder")) {
            tmpSettings.put("org.alfresco.mobile.cache.folder", (Serializable)((Object)DEFAULT_CACHE_FOLDER_PATH));
        }
        if (!tmpSettings.containsKey("org.apache.chemistry.opencmis.binding.auth.classname")) {
            tmpSettings.put("org.apache.chemistry.opencmis.binding.auth.classname", (Serializable)((Object)"org.alfresco.mobile.android.api.session.authentication.impl.PassthruAuthenticationProviderImpl"));
        }
        if (!tmpSettings.containsKey("org.alfresco.mobile.api.authenticator.classname")) {
            tmpSettings.put("org.alfresco.mobile.api.authenticator.classname", (Serializable)((Object)BasicAuthenticationProviderImpl.class.getName()));
        }
        if (!tmpSettings.containsKey("org.alfresco.mobile.api.httpinvoker.classname")) {
            tmpSettings.put("org.alfresco.mobile.api.httpinvoker.classname", (Serializable)((Object)NetworkHttpInvoker.class.getName()));
        }
        if (!tmpSettings.containsKey("org.alfresco.mobile.http.encoding")) {
            tmpSettings.put("org.alfresco.mobile.http.encoding", (Serializable)((Object)"true"));
        }
        if (!tmpSettings.containsKey("org.alfresco.mobile.http.language")) {
            tmpSettings.put("org.alfresco.mobile.http.language", (Serializable)((Object)(Locale.getDefault().getLanguage() + ", en-us;q=0.8")));
        }
        this.userParameters = tmpSettings;
    }

    @Override
    public void addParameter(String key, Serializable value) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "key"));
        }
        this.checkParameter(key, value);
    }

    @Override
    public void addParameters(Map<String, Serializable> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "key"));
        }
        for (Map.Entry<String, Serializable> map : parameters.entrySet()) {
            this.addParameter(map.getKey(), map.getValue());
        }
    }

    public boolean hasParameter(String key) {
        if (this.userParameters == null) {
            return false;
        }
        return this.userParameters.containsKey(key);
    }

    @Override
    public Serializable getParameter(String key) {
        if (this.userParameters == null) {
            return null;
        }
        return this.userParameters.get(key);
    }

    @Override
    public void removeParameter(String key) {
        this.checkRemoveParameter(key);
    }

    @Override
    public List<String> getParameterKeys() {
        if (this.userParameters == null) {
            return null;
        }
        return new ArrayList<String>(this.userParameters.keySet());
    }

    private void checkParameter(String key, Serializable value) {
        if ("org.alfresco.mobile.api.listing.maxitems".equals(key) && value instanceof Integer && (Integer)value > 0) {
            this.userParameters.put(key, value);
            this.lc = this.createListingContext();
        }
        this.userParameters.put(key, value);
    }

    private void checkRemoveParameter(String key) {
        if ("org.alfresco.mobile.api.listing.maxitems".equals(key)) {
            this.userParameters.remove(key);
            this.lc = this.createListingContext();
        }
        this.userParameters.remove(key);
    }

    protected Map<String, String> retrieveSessionParameters() {
        this.init();
        return this.sessionParameters;
    }

    private void init() {
        int type = 2;
        if (this.hasParameter(BINDING_TYPE)) {
            type = (Integer)this.getParameter(BINDING_TYPE);
        } else if (this instanceof CloudSession) {
            type = 4;
        } else if (this instanceof RepositorySession) {
            type = 2;
        }
        switch (type) {
            case 1: {
                this.createCmisSettings();
                break;
            }
            case 2: {
                this.createAlfrescoCmisSettings();
                break;
            }
            case 4: {
                this.createCloudCmisSettings();
                break;
            }
            default: {
                this.createAlfrescoCmisSettings();
            }
        }
        this.lc = this.createListingContext();
    }

    private void createCmisSettings() {
        this.sessionParameters.put("org.apache.chemistry.opencmis.user", this.userIdentifier);
        this.sessionParameters.put("org.apache.chemistry.opencmis.password", this.password);
        this.sessionParameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
        this.addParameterIfExist(BINDING_URL, "org.apache.chemistry.opencmis.binding.atompub.url");
        this.addParameterIfExist(BASE_URL, BASE_URL);
        this.addParameterIfExist("org.alfresco.mobile.binding.repository.id", "org.apache.chemistry.opencmis.session.repository.id");
        this.addParameterIfExist("org.apache.chemistry.opencmis.binding.connecttimeout", "org.apache.chemistry.opencmis.binding.connecttimeout");
        this.addParameterIfExist("org.apache.chemistry.opencmis.binding.readtimeout", "org.apache.chemistry.opencmis.binding.readtimeout");
        this.addParameterIfExist("org.apache.chemistry.opencmis.binding.proxyuser", "org.apache.chemistry.opencmis.binding.proxyuser");
        this.addParameterIfExist("org.apache.chemistry.opencmis.binding.proxypassword", "org.apache.chemistry.opencmis.binding.proxypassword");
        this.addParameterIfExist("org.apache.chemistry.opencmis.binding.clientcompression", "org.apache.chemistry.opencmis.binding.clientcompression");
        this.addParameterIfExist("org.apache.chemistry.opencmis.binding.auth.classname", "org.apache.chemistry.opencmis.binding.auth.classname");
        this.addParameterIfExist("org.alfresco.mobile.api.authenticator.classname", "org.alfresco.mobile.api.authenticator.classname");
        this.addParameterIfExist("org.alfresco.mobile.http.encoding", "org.alfresco.mobile.http.encoding");
        this.addParameterIfExist("org.alfresco.mobile.http.language", "org.alfresco.mobile.http.language");
        this.addParameterIfExist("org.alfresco.mobile.http.transfert.chunk", "org.alfresco.mobile.http.transfert.chunk");
        this.addParameterIfExist(ONPREMISE_TRUSTMANAGER_CLASSNAME, ONPREMISE_TRUSTMANAGER_CLASSNAME);
        this.addParameterIfExist("org.alfresco.mobile.api.httpinvoker.classname", "org.apache.chemistry.opencmis.binding.httpinvoker.classname");
        this.addParameterIfExist("org.alfresco.mobile.api.configuration.init", "org.alfresco.mobile.api.configuration.init");
        this.addParameterIfExist("org.alfresco.mobile.api.configuration.folder", "org.alfresco.mobile.api.configuration.folder");
    }

    private void addParameterIfExist(String keySettings, String keyParameters) {
        if (this.hasParameter(keySettings)) {
            this.sessionParameters.put(keyParameters, (String)((Object)this.getParameter(keySettings)));
        }
    }

    private void createAlfrescoCmisSettings() {
        this.createCmisSettings();
        String tmpBindingUrl = (String)((Object)this.getParameter(BASE_URL));
        if (tmpBindingUrl != null && tmpBindingUrl.endsWith("/service/cmis")) {
            this.forceBinding = true;
            this.baseUrl = tmpBindingUrl.replace("/service/cmis", "");
            this.sessionParameters.put(BASE_URL, tmpBindingUrl.replace("/service/cmis", ""));
        } else if (tmpBindingUrl != null && tmpBindingUrl.endsWith("/cmisatom")) {
            this.forceBinding = true;
            this.baseUrl = tmpBindingUrl.replace("/cmisatom", "");
            this.sessionParameters.put(BASE_URL, tmpBindingUrl.replace("/cmisatom", ""));
        } else if (tmpBindingUrl != null && tmpBindingUrl.endsWith("/api/-default-/public/cmis/versions/1.0/atom/")) {
            this.forceBinding = true;
            this.hasPublicAPI = true;
            this.baseUrl = tmpBindingUrl.replace("/api/-default-/public/cmis/versions/1.0/atom/", "");
            this.sessionParameters.put(BASE_URL, tmpBindingUrl.replace("/api/-default-/public/cmis/versions/1.0/atom/", ""));
        } else if (tmpBindingUrl != null && !this.sessionParameters.containsKey("org.apache.chemistry.opencmis.binding.atompub.url")) {
            tmpBindingUrl = tmpBindingUrl.concat("/api/-default-/public/cmis/versions/1.0/atom/");
        }
        this.sessionParameters.put("org.apache.chemistry.opencmis.binding.atompub.url", tmpBindingUrl);
        this.sessionParameters.put("org.apache.chemistry.opencmis.objectfactory.classname", "org.alfresco.cmis.client.impl.AlfrescoObjectFactoryImpl");
        this.addParameterIfExist("org.alfresco.mobile.api.services.onpremise", "org.alfresco.mobile.api.services.onpremise");
    }

    private void createCloudCmisSettings() {
        this.createCmisSettings();
        if (!this.sessionParameters.containsKey(BINDING_URL)) {
            this.sessionParameters.put("org.apache.chemistry.opencmis.binding.atompub.url", ((String)((Object)this.getParameter(BASE_URL))).concat("/{networkId}/public/cmis/versions/1.0/atom/").replace("{networkId}", (String)((Object)this.getParameter("org.alfresco.mobile.bindings.api.cloud.network.id"))));
        }
        this.sessionParameters.put("org.apache.chemistry.opencmis.objectfactory.classname", "org.alfresco.cmis.client.impl.AlfrescoObjectFactoryImpl");
        this.addParameterIfExist("org.alfresco.mobile.api.services.cloud", "org.alfresco.mobile.api.services.cloud");
    }

    private ListingContext createListingContext() {
        this.lc = new ListingContext();
        if (this.hasParameter("org.alfresco.mobile.api.listing.maxitems")) {
            this.lc.setMaxItems((Integer)this.getParameter("org.alfresco.mobile.api.listing.maxitems"));
        }
        return this.lc;
    }

    protected Session createSession(SessionFactory sessionFactory, org.alfresco.mobile.android.api.session.authentication.AuthenticationProvider authenticator, Map<String, String> param) {
        try {
            if (param.get("org.apache.chemistry.opencmis.session.repository.id") != null) {
                return ((SessionFactoryImpl)sessionFactory).createSession(param, null, (AuthenticationProvider)new PassthruAuthenticationProviderImpl(authenticator), null, null);
            }
            return ((Repository)((SessionFactoryImpl)sessionFactory).getRepositories(param, null, (AuthenticationProvider)new PassthruAuthenticationProviderImpl(authenticator), null, null).get(0)).createSession();
        }
        catch (CmisPermissionDeniedException e) {
            throw new AlfrescoSessionException(101, (Throwable)e);
        }
        catch (Exception e) {
            throw new AlfrescoSessionException(100, (Throwable)e);
        }
    }

    protected Session createSession(SessionFactory sessionFactory, Map<String, String> param) {
        try {
            if (param.get("org.apache.chemistry.opencmis.session.repository.id") != null) {
                return sessionFactory.createSession(param);
            }
            return ((Repository)sessionFactory.getRepositories(param).get(0)).createSession();
        }
        catch (CmisPermissionDeniedException e) {
            throw new AlfrescoSessionException(101, (Throwable)e);
        }
        catch (Exception e) {
            throw new AlfrescoSessionException(100, (Throwable)e);
        }
    }

    @Override
    public RepositoryInfo getRepositoryInfo() {
        return this.repositoryInfo;
    }

    public String getRepositoryIdentifier() {
        return this.repositoryInfo.getIdentifier();
    }

    @Override
    public Folder getRootFolder() {
        return this.rootNode;
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public String getPersonIdentifier() {
        return this.userIdentifier;
    }

    public org.alfresco.mobile.android.api.session.authentication.AuthenticationProvider getAuthenticationProvider() {
        return this.authenticator;
    }

    public AuthenticationProvider getPassthruAuthenticationProvider() {
        return this.passThruAuthenticator;
    }

    @Override
    public ListingContext getDefaultListingContext() {
        return this.lc;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.services;
    }

    public Session getCmisSession() {
        return this.cmisSession;
    }

    protected ServiceRegistry createServiceRegistry(String className) {
        ServiceRegistry s = null;
        try {
            Class<?> c = Class.forName(className);
            Constructor<?> t = c.getDeclaredConstructor(AlfrescoSession.class);
            s = (ServiceRegistry)t.newInstance(this);
        }
        catch (Exception e) {
            throw new AlfrescoSessionException(109, (Throwable)e);
        }
        return s;
    }

    @Override
    public void clear() {
        if (this.services != null && this.services.getSiteService() != null) {
            this.services.getSiteService().clear();
        }
    }

    public boolean hasForceBinding() {
        return this.forceBinding;
    }
}

