/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.session.authentication.impl;

import java.lang.reflect.Constructor;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.alfresco.mobile.android.api.exceptions.AlfrescoSessionException;
import org.alfresco.mobile.android.api.session.authentication.AuthenticationProvider;
import org.alfresco.mobile.android.api.session.authentication.PassthruAuthenticationProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.AbstractAuthenticationProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.w3c.dom.Element;

public class PassthruAuthenticationProviderImpl
extends AbstractAuthenticationProvider
implements PassthruAuthenticationProvider {
    private static final String ONPREMISE_TRUSTMANAGER_CLASSNAME = "org.alfresco.mobile.binding.internal.https.trustmanager";
    private static final long serialVersionUID = 1L;
    private AuthenticationProvider alfrescoAuthenticationProvider;
    private SSLSocketFactory factory;
    private boolean hasCheckedSSLFactory = false;

    public PassthruAuthenticationProviderImpl() {
    }

    public PassthruAuthenticationProviderImpl(AuthenticationProvider alfrescoAuthenticationProvider) {
        this.alfrescoAuthenticationProvider = alfrescoAuthenticationProvider;
    }

    public Map<String, List<String>> getHTTPHeaders(String url) {
        if (this.alfrescoAuthenticationProvider == null) {
            this.alfrescoAuthenticationProvider = this.create(this.getAuthenticationProviderClassName());
        }
        return this.alfrescoAuthenticationProvider.getHTTPHeaders();
    }

    public Element getSOAPHeaders(Object portObject) {
        return null;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        if (this.hasCheckedSSLFactory) {
            return this.factory;
        }
        if (this.getTrustManagerClassName() == null) {
            this.hasCheckedSSLFactory = true;
            return null;
        }
        try {
            SSLContext context = null;
            X509TrustManager customManager = this.createTrustManager(this.getTrustManagerClassName());
            context = SSLContext.getInstance("TLS");
            context.init(null, new X509TrustManager[]{customManager}, new SecureRandom());
            this.factory = context.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hasCheckedSSLFactory = true;
        return this.factory;
    }

    public HostnameVerifier getHostnameVerifier() {
        return null;
    }

    public void putResponseHeaders(String url, int statusCode, Map<String, List<String>> headers) {
    }

    private String getAuthenticationProviderClassName() {
        Object userObject = this.getSession().get("org.alfresco.mobile.api.authenticator.classname");
        if (userObject instanceof String) {
            return (String)userObject;
        }
        return null;
    }

    private String getTrustManagerClassName() {
        Object userObject = this.getSession().get(ONPREMISE_TRUSTMANAGER_CLASSNAME);
        if (userObject instanceof String) {
            return (String)userObject;
        }
        return null;
    }

    private AuthenticationProvider create(String className) {
        AuthenticationProvider s = null;
        try {
            Class<?> c = Class.forName(className);
            Constructor<?> t = c.getDeclaredConstructor(BindingSession.class);
            s = (AuthenticationProvider)t.newInstance(this.getSession());
        }
        catch (Exception e) {
            throw new AlfrescoSessionException(108, (Throwable)e);
        }
        return s;
    }

    private X509TrustManager createTrustManager(String className) {
        X509TrustManager s = null;
        try {
            Class<?> c = Class.forName(className);
            Constructor<?> t = c.getDeclaredConstructor(new Class[0]);
            s = (X509TrustManager)t.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new AlfrescoSessionException(100, (Throwable)e);
        }
        return s;
    }

    public AuthenticationProvider getAlfrescoAuthenticationProvider() {
        return this.alfrescoAuthenticationProvider;
    }
}

