/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.session.authentication.impl;

import android.net.Uri;
import android.util.Log;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.mobile.android.api.constants.OAuthConstant;
import org.alfresco.mobile.android.api.exceptions.AlfrescoSessionException;
import org.alfresco.mobile.android.api.exceptions.impl.ExceptionHelper;
import org.alfresco.mobile.android.api.network.NetworkHttpInvoker;
import org.alfresco.mobile.android.api.session.authentication.OAuthData;
import org.alfresco.mobile.android.api.session.authentication.impl.OAuth2DataImpl;
import org.alfresco.mobile.android.api.utils.JsonUtils;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

public final class OAuthHelper
implements OAuthConstant {
    private static final String TAG = "OAuthHelper";
    private String baseUrl = "https://api.alfresco.com";
    private static final String PARAM_CLIENT_ID = "client_id";
    private static final String PARAM_CLIENT_SECRET = "client_secret";
    private static final String PARAM_REDIRECT_ID = "redirect_uri";
    private static final String PARAM_RESPONSE_TYPE = "response_type";
    private static final String PARAM_REFRESH_TOKEN = "refresh_token";
    private static final String PARAM_SCOPE = "scope";
    private static final String PARAM_GRANT_TYPE = "grant_type";
    private static final String RESPONSE_TYPE_CODE = "code";
    private static final String GRANT_TYPE_AUTH_CODE = "authorization_code";
    private static final String GRANT_TYPE_REFRESH_TOKEN = "refresh_token";
    private static final String FORMAT = "application/x-www-form-urlencoded";

    public OAuthHelper() {
    }

    public OAuthHelper(String baseOAuthUrl) {
        if (baseOAuthUrl != null && !baseOAuthUrl.isEmpty()) {
            this.baseUrl = baseOAuthUrl;
        }
    }

    public String getAuthorizationUrl(String apiKey, String callback, String scope) {
        if (this.isStringNull(apiKey)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "apiKey"));
        }
        if (this.isStringNull(scope)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), PARAM_SCOPE));
        }
        if (this.isStringNull(callback)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "callback"));
        }
        UrlBuilder builder = new UrlBuilder(this.baseUrl + "/auth/oauth/versions/2/authorize");
        builder.addParameter(PARAM_CLIENT_ID, (Object)apiKey);
        builder.addParameter(PARAM_REDIRECT_ID, (Object)callback);
        builder.addParameter(PARAM_SCOPE, (Object)scope);
        builder.addParameter(PARAM_RESPONSE_TYPE, (Object)RESPONSE_TYPE_CODE);
        return builder.toString();
    }

    public static String retrieveCode(String url) {
        Uri uri = Uri.parse((String)url);
        return uri.getQueryParameter(RESPONSE_TYPE_CODE);
    }

    public OAuthData getAccessToken(String apiKey, String apiSecret, String callback, String code) {
        OAuth2DataImpl data = null;
        if (this.isStringNull(apiKey)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "apiKey"));
        }
        if (this.isStringNull(apiSecret)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "apiSecret"));
        }
        if (this.isStringNull(callback)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "callback"));
        }
        if (this.isStringNull(code)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), RESPONSE_TYPE_CODE));
        }
        try {
            UrlBuilder builder = new UrlBuilder(this.baseUrl + "/auth/oauth/versions/2/token");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(RESPONSE_TYPE_CODE, code);
            params.put(PARAM_CLIENT_ID, apiKey);
            params.put(PARAM_CLIENT_SECRET, apiSecret);
            params.put(PARAM_REDIRECT_ID, callback);
            params.put(PARAM_GRANT_TYPE, GRANT_TYPE_AUTH_CODE);
            Response resp = NetworkHttpInvoker.invokePOST(builder, FORMAT, params);
            if (resp.getResponseCode() != 200) {
                ExceptionHelper.convertStatusCode(null, resp, 103);
            }
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            data = new OAuth2DataImpl(apiKey, apiSecret);
            data.parseTokenResponse(json);
        }
        catch (CmisConnectionException e) {
            if (e.getCause() instanceof IOException && e.getCause().getMessage().contains("Received authentication challenge is null")) {
                throw new AlfrescoSessionException(102, (Throwable)e);
            }
        }
        catch (AlfrescoSessionException e) {
            throw e;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
        return data;
    }

    public OAuthData refreshToken(OAuthData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "OAuthData"));
        }
        try {
            UrlBuilder builder = new UrlBuilder(this.baseUrl + "/auth/oauth/versions/2/token");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("refresh_token", data.getRefreshToken());
            params.put(PARAM_CLIENT_ID, data.getApiKey());
            params.put(PARAM_CLIENT_SECRET, data.getApiSecret());
            params.put(PARAM_GRANT_TYPE, "refresh_token");
            Response resp = NetworkHttpInvoker.invokePOST(builder, FORMAT, params);
            if (resp.getResponseCode() != 200) {
                ExceptionHelper.convertStatusCode(null, resp, 105);
            }
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            OAuth2DataImpl token = new OAuth2DataImpl(data.getApiKey(), data.getApiSecret());
            token.parseTokenResponse(json);
            return token;
        }
        catch (CmisConnectionException e) {
            if (e.getCause() instanceof IOException && e.getCause().getMessage().contains("Received authentication challenge is null")) {
                throw new AlfrescoSessionException(102, (Throwable)e);
            }
        }
        catch (AlfrescoSessionException e) {
            throw e;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
        return null;
    }

    private boolean isStringNull(String s) {
        return s == null || s.length() == 0 || s.trim().length() == 0;
    }
}

