/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.session.authentication.impl;

import java.util.Map;
import org.alfresco.mobile.android.api.session.authentication.OAuthData;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;

public final class OAuth2DataImpl
implements OAuthData {
    private static final long serialVersionUID = 1L;
    private static final String PARAM_ACCESS_TOKEN = "access_token";
    private static final String PARAM_TOKEN_TYPE = "token_type";
    private static final String PARAM_EXPIRES_IN = "expires_in";
    private static final String PARAM_REFRESH_TOKEN = "refresh_token";
    private static final String PARAM_SCOPE = "scope";
    private final String apiKey;
    private final String apiSecret;
    private String accessToken;
    private String tokenType;
    private String expiresIn;
    private String refreshToken;
    private String scope;

    public OAuth2DataImpl(String apikey, String apiSecret) {
        this.apiKey = apikey;
        this.apiSecret = apiSecret;
    }

    public OAuth2DataImpl(String apikey, String apiSecret, String accessToken, String refreshToken) {
        this.apiKey = apikey;
        this.apiSecret = apiSecret;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
    }

    public void parseTokenResponse(Map<String, Object> json) {
        this.accessToken = JSONConverter.getString(json, (String)PARAM_ACCESS_TOKEN);
        this.tokenType = JSONConverter.getString(json, (String)PARAM_TOKEN_TYPE);
        this.expiresIn = JSONConverter.getString(json, (String)PARAM_EXPIRES_IN);
        this.refreshToken = JSONConverter.getString(json, (String)PARAM_REFRESH_TOKEN);
        this.scope = JSONConverter.getString(json, (String)PARAM_SCOPE);
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public String getApiSecret() {
        return this.apiSecret;
    }
}

