/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.session.authentication.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.constants.OAuthConstant;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.authentication.OAuthAuthenticationProvider;
import org.alfresco.mobile.android.api.session.authentication.OAuthData;
import org.alfresco.mobile.android.api.session.authentication.impl.AuthenticationProviderImpl;
import org.alfresco.mobile.android.api.session.authentication.impl.OAuthHelper;

public class OAuth2AuthenticationProviderImpl
extends AuthenticationProviderImpl
implements OAuthAuthenticationProvider,
OAuthConstant {
    private static final long serialVersionUID = 1L;
    private static final String TOKEN_TYPE_BEARER = "Bearer";
    private OAuthData token;
    private Map<String, List<String>> fixedHeaders = new HashMap<String, List<String>>();

    public OAuth2AuthenticationProviderImpl(OAuthData oauthData) {
        this.token = oauthData;
        this.retrieveAccessToken();
    }

    @Override
    public Map<String, List<String>> getHTTPHeaders() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(this.fixedHeaders);
        return result.isEmpty() ? null : result;
    }

    private void retrieveAccessToken() {
        this.fixedHeaders.put("Authorization", Collections.singletonList("Bearer " + this.token.getAccessToken()));
    }

    @Override
    public String getAccessToken() {
        if (this.token != null) {
            return this.token.getAccessToken();
        }
        return null;
    }

    @Override
    public String getRefreshToken() {
        if (this.token != null) {
            return this.token.getRefreshToken();
        }
        return null;
    }

    @Override
    public OAuthData refreshToken(AlfrescoSession session) {
        OAuthHelper helper = new OAuthHelper(session.getBaseUrl());
        return helper.refreshToken(this.token);
    }

    @Override
    public void setOAuthData(OAuthData data) {
        this.token = data;
        this.retrieveAccessToken();
    }

    @Override
    public OAuthData getOAuthData() {
        return this.token;
    }
}

