/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.session.authentication.impl;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.authentication.BasicAuthenticationProvider;
import org.alfresco.mobile.android.api.session.authentication.impl.AuthenticationProviderImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.commons.impl.Base64;

public class BasicAuthenticationProviderImpl
extends AuthenticationProviderImpl
implements BasicAuthenticationProvider {
    private static final long serialVersionUID = 1L;
    private boolean sendBasicAuth = true;
    private String user;
    private String password;
    private Map<String, Serializable> parameters;
    private Map<String, List<String>> fixedHeaders = new HashMap<String, List<String>>();

    public BasicAuthenticationProviderImpl(Map<String, Serializable> parameters) {
        this.parameters = parameters;
        this.init();
    }

    public BasicAuthenticationProviderImpl(BindingSession cmisSession) {
        this.cmisSession = cmisSession;
        this.init();
    }

    @Override
    public Map<String, List<String>> getHTTPHeaders(AlfrescoSession session) {
        return this.getHTTPHeaders();
    }

    @Override
    public Map<String, List<String>> getHTTPHeaders() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(this.fixedHeaders);
        return result.isEmpty() ? null : result;
    }

    private String getParameter(String key) {
        if (this.cmisSession != null && this.cmisSession.get(key) != null && this.cmisSession.get(key) instanceof String) {
            return (String)this.cmisSession.get(key);
        }
        if (this.parameters != null && this.parameters.containsKey(key) && this.parameters.get(key) instanceof String) {
            return (String)((Object)this.parameters.get(key));
        }
        return null;
    }

    private void init() {
        String headerParam;
        if (this.sendBasicAuth) {
            String mUser = this.getUser();
            String mPassword = this.getPassword();
            if (mUser != null) {
                this.fixedHeaders.put("Authorization", this.createBasicAuthHeaderValue(mUser, mPassword));
            }
            String proxyUser = this.getParameter("org.apache.chemistry.opencmis.binding.proxyuser");
            String proxyPassword = this.getParameter("org.apache.chemistry.opencmis.binding.proxypassword");
            if (proxyUser != null) {
                this.fixedHeaders.put("Proxy-Authorization", this.createBasicAuthHeaderValue(proxyUser, proxyPassword));
            }
        }
        int x = 0;
        while ((headerParam = this.getParameter("org.apache.chemistry.opencmis.binding.header." + x)) != null) {
            String key;
            String header = headerParam.toString();
            int colon = header.indexOf(58);
            if (colon > -1 && (key = header.substring(0, colon).trim()).length() > 0) {
                String value = header.substring(colon + 1).trim();
                List<String> values = this.fixedHeaders.get(key);
                if (values == null) {
                    this.fixedHeaders.put(key, Collections.singletonList(value));
                } else {
                    ArrayList<String> newValues = new ArrayList<String>(values);
                    newValues.add(value);
                    this.fixedHeaders.put(key, newValues);
                }
            }
            ++x;
        }
    }

    private String getPassword() {
        if (this.password == null && this.getParameter("org.apache.chemistry.opencmis.password") != null) {
            this.password = this.getParameter("org.apache.chemistry.opencmis.password");
        }
        return this.password;
    }

    private String getUser() {
        if (this.user == null && this.getParameter("org.apache.chemistry.opencmis.user") != null) {
            this.user = this.getParameter("org.apache.chemistry.opencmis.user");
        }
        return this.user;
    }

    private List<String> createBasicAuthHeaderValue(String username, String password) {
        String tmpPassword = password;
        if (tmpPassword == null) {
            tmpPassword = "";
        }
        try {
            return Collections.singletonList("Basic " + Base64.encodeBytes((byte[])(username + ":" + tmpPassword).getBytes("ISO-8859-1")));
        }
        catch (UnsupportedEncodingException e) {
            return Collections.emptyList();
        }
    }

    protected boolean isTrue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return false;
    }
}

