/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.session;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.session.CloudNetwork;
import org.alfresco.mobile.android.api.session.authentication.OAuthData;
import org.alfresco.mobile.android.api.session.impl.AbstractAlfrescoSessionImpl;
import org.alfresco.mobile.android.api.session.impl.CloudSessionImpl;

public abstract class CloudSession
extends AbstractAlfrescoSessionImpl {
    public static final String CLOUD_NETWORK_ID = "org.alfresco.mobile.bindings.api.cloud.network.id";
    public static final String USER_ME = "-me-";

    public static CloudSession connect(OAuthData oauthData) {
        return new CloudSessionImpl(oauthData, null);
    }

    public static CloudSession connect(OAuthData oauthData, Map<String, Serializable> parameters) {
        return new CloudSessionImpl(oauthData, parameters);
    }

    public static CloudSession connect(OAuthData oauthData, String networkId) {
        return CloudSession.connect(oauthData, networkId, null);
    }

    public static CloudSession connect(OAuthData oauthData, String networkId, Map<String, Serializable> parameters) {
        Map<String, Serializable> tmpParameters = parameters;
        if (tmpParameters == null) {
            tmpParameters = new HashMap<String, Serializable>();
        }
        tmpParameters.put(CLOUD_NETWORK_ID, (Serializable)((Object)networkId));
        return new CloudSessionImpl(oauthData, tmpParameters);
    }

    public abstract List<CloudNetwork> getNetworks();

    public abstract CloudNetwork getNetwork();

    public abstract OAuthData getOAuthData();

    public abstract void setOAuthData(OAuthData var1);
}

