/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl.publicapi;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.mobile.android.api.constants.WorkflowModel;
import org.alfresco.mobile.android.api.model.ContentStream;
import org.alfresco.mobile.android.api.model.Document;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.ListingFilter;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.Person;
import org.alfresco.mobile.android.api.model.Process;
import org.alfresco.mobile.android.api.model.ProcessDefinition;
import org.alfresco.mobile.android.api.model.Property;
import org.alfresco.mobile.android.api.model.PropertyType;
import org.alfresco.mobile.android.api.model.Task;
import org.alfresco.mobile.android.api.model.impl.ContentStreamImpl;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.model.impl.ProcessDefinitionImpl;
import org.alfresco.mobile.android.api.model.impl.ProcessImpl;
import org.alfresco.mobile.android.api.model.impl.PropertyImpl;
import org.alfresco.mobile.android.api.model.impl.TaskImpl;
import org.alfresco.mobile.android.api.model.impl.publicapi.PublicAPIDocumentImpl;
import org.alfresco.mobile.android.api.services.impl.AbstractWorkflowService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.impl.RepositorySessionImpl;
import org.alfresco.mobile.android.api.utils.DateUtils;
import org.alfresco.mobile.android.api.utils.JsonDataWriter;
import org.alfresco.mobile.android.api.utils.JsonUtils;
import org.alfresco.mobile.android.api.utils.NodeRefUtils;
import org.alfresco.mobile.android.api.utils.PublicAPIResponse;
import org.alfresco.mobile.android.api.utils.PublicAPIUrlRegistry;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.json.JSONArray;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;

public class PublicAPIWorkflowServiceImpl
extends AbstractWorkflowService {
    private static final String TAG = PublicAPIWorkflowServiceImpl.class.getName();
    public static final String INCLUDE_VARIABLES = "filterIncludeVariables";
    private static final Map<String, PropertyType> VARIABLE_TYPES = new HashMap<String, PropertyType>(6){
        private static final long serialVersionUID = 1L;
        {
            this.put("d:text", PropertyType.STRING);
            this.put("bpm:workflowPackage", PropertyType.STRING);
            this.put("d:boolean", PropertyType.BOOLEAN);
            this.put("d:int", PropertyType.INTEGER);
            this.put("d:noderef", PropertyType.STRING);
            this.put("d:datetime", PropertyType.DATETIME);
        }
    };
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.getDefault());
    public static final Parcelable.Creator<PublicAPIWorkflowServiceImpl> CREATOR = new Parcelable.Creator<PublicAPIWorkflowServiceImpl>(){

        public PublicAPIWorkflowServiceImpl createFromParcel(Parcel in) {
            return new PublicAPIWorkflowServiceImpl(in);
        }

        public PublicAPIWorkflowServiceImpl[] newArray(int size) {
            return new PublicAPIWorkflowServiceImpl[size];
        }
    };

    public PublicAPIWorkflowServiceImpl(AlfrescoSession repositorySession) {
        super(repositorySession);
    }

    @Override
    public PagingResult<ProcessDefinition> getProcessDefinitions(ListingContext listingContext) {
        ArrayList<ProcessDefinition> definitions = new ArrayList<ProcessDefinition>();
        PublicAPIResponse response = null;
        int skipCount = -1;
        try {
            String link = PublicAPIUrlRegistry.getProcessDefinitionsUrl(this.session);
            UrlBuilder url = new UrlBuilder(link);
            if (listingContext != null) {
                url.addParameter("maxItems", (Object)listingContext.getMaxItems());
                url.addParameter("skipCount", (Object)listingContext.getSkipCount());
                skipCount = listingContext.getSkipCount();
            }
            Response resp = this.read(url, 1100);
            response = new PublicAPIResponse(resp);
            Map data = null;
            for (Object entry : response.getEntries()) {
                data = (Map)((Map)entry).get("entry");
                definitions.add(ProcessDefinitionImpl.parsePublicAPIJson(data));
            }
        }
        catch (Exception e) {
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
        return new PagingResultImpl<ProcessDefinition>(definitions, this.hasMoreItems(response.getHasMoreItems(), skipCount, response.getSize()), response.getSize());
    }

    @Override
    public ProcessDefinition getProcessDefinition(String processDefinitionIdentifier) {
        if (this.isStringNull(processDefinitionIdentifier)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "processDefinitionIdentifier"));
        }
        ProcessDefinition definition = null;
        try {
            String link = PublicAPIUrlRegistry.getProcessDefinitionUrl(this.session, processDefinitionIdentifier);
            UrlBuilder url = new UrlBuilder(link);
            Response resp = this.read(url, 1100);
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            Map data = (Map)json.get("entry");
            definition = ProcessDefinitionImpl.parsePublicAPIJson(data);
        }
        catch (Exception e) {
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
        return definition;
    }

    @Override
    public Process startProcess(ProcessDefinition processDefinition, List<Person> assignees, Map<String, Serializable> variables, List<Document> items) {
        if (this.isObjectNull(processDefinition)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "processDefinition"));
        }
        Process process = null;
        try {
            String link = PublicAPIUrlRegistry.getProcessesUrl(this.session);
            UrlBuilder url = new UrlBuilder(link);
            JSONObject jo = new JSONObject();
            jo.put("processDefinitionId", (Object)processDefinition.getIdentifier());
            JSONObject variablesJson = new JSONObject();
            if (assignees != null && !assignees.isEmpty()) {
                if (assignees.size() == 1 && WorkflowModel.FAMILY_PROCESS_ADHOC.contains(processDefinition.getKey()) || WorkflowModel.FAMILY_PROCESS_REVIEW.contains(processDefinition.getKey())) {
                    variablesJson.put(PublicAPIWorkflowServiceImpl.encodeKey(WorkflowModel.PROP_ASSIGNEE), (Object)assignees.get(0).getIdentifier());
                } else {
                    JSONArray variablesAssignees = new JSONArray();
                    for (Person p : assignees) {
                        variablesAssignees.add((Object)p.getIdentifier());
                    }
                    variablesJson.put(PublicAPIWorkflowServiceImpl.encodeKey(WorkflowModel.ASSOC_ASSIGNEES), (Object)variablesAssignees);
                }
            }
            if (variables != null && !variables.isEmpty()) {
                for (Map.Entry<String, Serializable> entry : variables.entrySet()) {
                    variablesJson.put(PublicAPIWorkflowServiceImpl.encodeKey(entry.getKey()), (Object)entry.getValue());
                }
                jo.put("variables", (Object)variablesJson);
            }
            if (items != null && !items.isEmpty()) {
                JSONArray variablesItems = new JSONArray();
                String id = null;
                for (Node node : items) {
                    id = NodeRefUtils.getCleanIdentifier(node.getIdentifier());
                    variablesItems.add((Object)id);
                }
                jo.put("items", (Object)variablesItems);
            }
            final JsonDataWriter dataWriter = new JsonDataWriter(jo);
            Response resp = this.post(url, dataWriter.getContentType(), new Output(){

                public void write(OutputStream out) throws IOException {
                    dataWriter.write(out);
                }
            }, 1100);
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            Map map = (Map)json.get("entry");
            process = ProcessImpl.parsePublicAPIJson(map);
        }
        catch (Exception e) {
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
        return process;
    }

    @Override
    protected UrlBuilder getProcessUrl(Process process) {
        return new UrlBuilder(PublicAPIUrlRegistry.getProcessUrl(this.session, process.getIdentifier()));
    }

    @Override
    public PagingResult<Process> getProcesses(ListingContext listingContext) {
        ArrayList<Process> processes = new ArrayList<Process>();
        PublicAPIResponse response = null;
        int skipCount = -1;
        try {
            String link = PublicAPIUrlRegistry.getProcessesUrl(this.session);
            UrlBuilder url = new UrlBuilder(link);
            if (listingContext != null) {
                if (listingContext.getFilter() != null) {
                    url.addParameter("where", (Object)this.getPredicate(null, listingContext.getFilter(), true));
                }
                url.addParameter("maxItems", (Object)listingContext.getMaxItems());
                url.addParameter("skipCount", (Object)listingContext.getSkipCount());
                skipCount = listingContext.getSkipCount();
            }
            Response resp = this.read(url, 1100);
            response = new PublicAPIResponse(resp);
            Map data = null;
            for (Object entry : response.getEntries()) {
                data = (Map)((Map)entry).get("entry");
                processes.add(ProcessImpl.parsePublicAPIJson(data));
            }
        }
        catch (Exception e) {
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
        return new PagingResultImpl<Process>(processes, this.hasMoreItems(response.getHasMoreItems(), skipCount, response.getSize()), response.getSize());
    }

    @Override
    public Process getProcess(String processId) {
        if (this.isStringNull(processId)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "processId"));
        }
        Process process = null;
        try {
            String link = PublicAPIUrlRegistry.getProcessUrl(this.session, processId);
            UrlBuilder url = new UrlBuilder(link);
            Response resp = this.read(url, 1100);
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            Map data = (Map)json.get("entry");
            process = ProcessImpl.parsePublicAPIJson(data);
        }
        catch (Exception e) {
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
        return process;
    }

    @Override
    public PagingResult<Task> getTasks(Process process, ListingContext listingContext) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        PublicAPIResponse response = null;
        int skipCount = -1;
        try {
            String link = PublicAPIUrlRegistry.getTasksForProcessIdUrl(this.session, process.getIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            if (listingContext != null) {
                ListingFilter filter = listingContext.getFilter();
                if (filter != null && filter.hasFilterValue("filterStatus")) {
                    switch ((Integer)filter.getFilterValue("filterStatus")) {
                        case 0: {
                            url.addParameter("status", (Object)"any");
                            break;
                        }
                        case 2: {
                            url.addParameter("status", (Object)"completed");
                            break;
                        }
                    }
                }
                url.addParameter("maxItems", (Object)listingContext.getMaxItems());
                url.addParameter("skipCount", (Object)listingContext.getSkipCount());
                skipCount = listingContext.getSkipCount();
            }
            Response resp = this.read(url, 1100);
            response = new PublicAPIResponse(resp);
            Map data = null;
            for (Object entry : response.getEntries()) {
                data = (Map)((Map)entry).get("entry");
                tasks.add(TaskImpl.parsePublicAPIJson(data));
            }
        }
        catch (Exception e) {
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
        return new PagingResultImpl<Task>(tasks, this.hasMoreItems(response.getHasMoreItems(), skipCount, response.getSize()), response.getSize());
    }

    @Override
    public Process refresh(Process process) {
        if (this.isObjectNull(process)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "task"));
        }
        Process resultProcess = process;
        try {
            resultProcess = ProcessImpl.refreshProcess(process, this.getVariables(process));
        }
        catch (Exception e) {
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
        return resultProcess;
    }

    @Override
    public PagingResult<Document> getDocuments(Task task, ListingContext listingContext) {
        if (this.isObjectNull(task)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "task"));
        }
        if (this.isStringNull(task.getIdentifier())) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "taskId"));
        }
        return this.getItems(task.getProcessIdentifier(), listingContext);
    }

    @Override
    public PagingResult<Document> getDocuments(Process process, ListingContext listingContext) {
        if (this.isObjectNull(process)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "process"));
        }
        if (this.isStringNull(process.getIdentifier())) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "processId"));
        }
        return this.getItems(process.getIdentifier(), listingContext);
    }

    private PagingResult<Document> getItems(String id, ListingContext listingContext) {
        ArrayList<PublicAPIDocumentImpl> tasks = new ArrayList<PublicAPIDocumentImpl>();
        PublicAPIResponse response = null;
        try {
            String link = PublicAPIUrlRegistry.getProcessItemsUrl(this.session, id);
            UrlBuilder url = new UrlBuilder(link);
            if (listingContext != null) {
                url.addParameter("maxItems", (Object)listingContext.getMaxItems());
                url.addParameter("skipCount", (Object)listingContext.getSkipCount());
            }
            Response resp = this.read(url, 1100);
            response = new PublicAPIResponse(resp);
            Map data = null;
            for (Object entry : response.getEntries()) {
                data = (Map)((Map)entry).get("entry");
                tasks.add(new PublicAPIDocumentImpl(data));
            }
        }
        catch (Exception e) {
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
        return new PagingResultImpl<Document>(tasks, response.getHasMoreItems(), response.getSize());
    }

    @Override
    public void addDocuments(Task task, List<Document> items) {
        if (this.isObjectNull(task)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "task"));
        }
        try {
            String link = PublicAPIUrlRegistry.getTaskItemsUrl(this.session, task.getIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            JSONObject jo = new JSONObject();
            jo.put("id", (Object)NodeRefUtils.getCleanIdentifier(items.get(0).getIdentifier()));
            final JsonDataWriter dataWriter = new JsonDataWriter(jo);
            this.post(url, dataWriter.getContentType(), new Output(){

                public void write(OutputStream out) throws IOException {
                    dataWriter.write(out);
                }
            }, 1100);
        }
        catch (Exception e) {
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
    }

    @Override
    public void removeDocuments(Task task, List<Document> items) {
        if (this.isObjectNull(task)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "task"));
        }
        try {
            String link = PublicAPIUrlRegistry.getTaskItemByIdUrl(this.session, task.getIdentifier(), NodeRefUtils.getCleanIdentifier(items.get(0).getIdentifier()));
            UrlBuilder url = new UrlBuilder(link);
            this.delete(url, 1100);
        }
        catch (Exception e) {
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
    }

    @Override
    public PagingResult<Task> getTasks(ListingContext listingContext) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        PublicAPIResponse response = null;
        int skipCount = -1;
        try {
            String link = PublicAPIUrlRegistry.getTasksUrl(this.session);
            UrlBuilder url = new UrlBuilder(link);
            if (listingContext != null) {
                String predicate;
                if (listingContext.getFilter() != null && (predicate = (String)this.getPredicate(listingContext.getFilter())) != null && !predicate.isEmpty()) {
                    url.addParameter("where", (Object)predicate);
                }
                url.addParameter("maxItems", (Object)listingContext.getMaxItems());
                url.addParameter("skipCount", (Object)listingContext.getSkipCount());
                skipCount = listingContext.getSkipCount();
            }
            Log.d((String)TAG, (String)url.toString());
            Response resp = this.read(url, 1100);
            response = new PublicAPIResponse(resp);
            Map data = null;
            for (Object entry : response.getEntries()) {
                data = (Map)((Map)entry).get("entry");
                tasks.add(TaskImpl.parsePublicAPIJson(data));
            }
        }
        catch (Exception e) {
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
        return new PagingResultImpl<Task>(tasks, this.hasMoreItems(response.getHasMoreItems(), skipCount, response.getSize()), response.getSize());
    }

    @Override
    public Task getTask(String taskIdentifier) {
        if (this.isStringNull(taskIdentifier)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "taskIdentifier"));
        }
        Task task = null;
        try {
            String link = PublicAPIUrlRegistry.getTaskUrl(this.session, taskIdentifier);
            UrlBuilder url = new UrlBuilder(link);
            Response resp = this.read(url, 1100);
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            Map data = (Map)json.get("entry");
            task = TaskImpl.parsePublicAPIJson(data);
            task = this.refresh(task);
        }
        catch (Exception e) {
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
        return task;
    }

    @Override
    public Task completeTask(Task task, Map<String, Serializable> variables) {
        return this.updateTask(task, variables, "completed");
    }

    @Override
    public Task claimTask(Task task) {
        return this.updateTask(task, null, "claimed");
    }

    @Override
    public Task unclaimTask(Task task) {
        return this.updateTask(task, null, "unclaimed");
    }

    @Override
    public Task reassignTask(Task task, Person assignee) {
        if (this.isObjectNull(task)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "task"));
        }
        if (this.isObjectNull(assignee)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "assignee"));
        }
        Task resultTask = task;
        try {
            String link = PublicAPIUrlRegistry.getTaskUrl(this.session, task.getIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            url.addParameter("select", (Object)"assignee");
            JSONObject jo = new JSONObject();
            jo.put("assignee", (Object)assignee.getIdentifier());
            final JsonDataWriter dataWriter = new JsonDataWriter(jo);
            Response resp = this.put(url, dataWriter.getContentType(), null, new Output(){

                public void write(OutputStream out) throws IOException {
                    dataWriter.write(out);
                }
            }, 1100);
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            Map data = (Map)json.get("entry");
            resultTask = TaskImpl.parsePublicAPIJson(data);
        }
        catch (Exception e) {
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
        return resultTask;
    }

    private Task updateTask(Task task, Map<String, Serializable> variables, String state) {
        if (this.isObjectNull(task)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "task"));
        }
        Task resultTask = task;
        try {
            String link = PublicAPIUrlRegistry.getTaskUrl(this.session, task.getIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            JSONObject jo = new JSONObject();
            if (state != null) {
                jo.put("state", (Object)state);
                if (variables != null) {
                    url.addParameter("select", (Object)"state,variables");
                    JSONArray ja = new JSONArray();
                    for (Map.Entry<String, Serializable> entry : variables.entrySet()) {
                        JSONObject jv = new JSONObject();
                        jv.put("name", (Object)PublicAPIWorkflowServiceImpl.encodeKey(entry.getKey()));
                        jv.put("value", (Object)entry.getValue());
                        jv.put("scope", (Object)"local");
                        ja.add((Object)jv);
                    }
                    jo.put("variables", (Object)ja);
                } else {
                    url.addParameter("select", (Object)"state");
                }
            }
            final JsonDataWriter dataWriter = new JsonDataWriter(jo);
            Response resp = this.put(url, dataWriter.getContentType(), null, new Output(){

                public void write(OutputStream out) throws IOException {
                    dataWriter.write(out);
                }
            }, 1100);
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            Map data = (Map)json.get("entry");
            resultTask = TaskImpl.parsePublicAPIJson(data);
        }
        catch (Exception e) {
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
        return resultTask;
    }

    @Override
    public Task refresh(Task task) {
        if (this.isObjectNull(task)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "task"));
        }
        Task resultTask = task;
        try {
            resultTask = TaskImpl.refreshTask(task, this.getVariables(task));
        }
        catch (Exception e) {
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
        return resultTask;
    }

    @Override
    public Map<String, Property> getVariables(Task task) {
        if (this.isObjectNull(task)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "task"));
        }
        Map<String, Property> variables = new HashMap<String, Property>();
        try {
            String link = PublicAPIUrlRegistry.getTaskVariablesUrl(this.session, task.getIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            variables = this.getVariables(url);
        }
        catch (Exception e) {
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
        return variables;
    }

    @Override
    public Map<String, Property> getVariables(Process process) {
        if (this.isObjectNull(process)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "process"));
        }
        Map<String, Property> variables = new HashMap<String, Property>();
        try {
            String link = PublicAPIUrlRegistry.getProcessVariablesUrl(this.session, process.getIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            variables = this.getVariables(url);
        }
        catch (Exception e) {
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
        return variables;
    }

    private Map<String, Property> getVariables(UrlBuilder url) {
        HashMap<String, Property> variables = new HashMap<String, Property>();
        try {
            Response resp = this.read(url, 1100);
            PublicAPIResponse response = new PublicAPIResponse(resp);
            Map data = null;
            for (Object entry : response.getEntries()) {
                data = (Map)((Map)entry).get("entry");
                variables.put(PublicAPIWorkflowServiceImpl.decodeKey((String)data.get("name")), this.parseProperty(data));
            }
        }
        catch (Exception e) {
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
        return variables;
    }

    @Override
    public Task updateVariables(Task task, Map<String, Serializable> variables) {
        if (this.isObjectNull(task)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "task"));
        }
        if (this.isMapNull(variables)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "variables"));
        }
        HashMap<String, Serializable> internalVariables = new HashMap<String, Serializable>();
        if (variables != null) {
            internalVariables.putAll(variables);
        }
        Task resultTask = task;
        try {
            String link = PublicAPIUrlRegistry.getTaskVariablesUrl(this.session, task.getIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            JSONArray ja = new JSONArray();
            for (Map.Entry entry : internalVariables.entrySet()) {
                JSONObject jo = new JSONObject();
                jo.put("name", (Object)PublicAPIWorkflowServiceImpl.encodeKey((String)entry.getKey()));
                jo.put("value", entry.getValue());
                jo.put("scope", (Object)"local");
                ja.add((Object)jo);
            }
            final JsonDataWriter dataWriter = new JsonDataWriter(ja);
            this.post(url, dataWriter.getContentType(), new Output(){

                public void write(OutputStream out) throws IOException {
                    dataWriter.write(out);
                }
            }, 1100);
            resultTask = this.getTask(task.getIdentifier());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
        return resultTask;
    }

    public Task updateVariable(Task task, String key, Serializable value) {
        if (this.isObjectNull(task)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "task"));
        }
        Task resultTask = task;
        try {
            String link = PublicAPIUrlRegistry.getTaskVariableUrl(this.session, task.getIdentifier(), key);
            UrlBuilder url = new UrlBuilder(link);
            JSONObject jo = new JSONObject();
            jo.put("name", (Object)PublicAPIWorkflowServiceImpl.encodeKey(key));
            jo.put("value", (Object)value);
            jo.put("scope", (Object)"local");
            final JsonDataWriter dataWriter = new JsonDataWriter(jo);
            this.put(url, dataWriter.getContentType(), null, new Output(){

                public void write(OutputStream out) throws IOException {
                    dataWriter.write(out);
                }
            }, 1100);
            resultTask = this.getTask(task.getIdentifier());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
        return resultTask;
    }

    @Override
    public Process updateVariables(Process process, Map<String, Serializable> variables) {
        if (this.isObjectNull(process)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "task"));
        }
        if (this.isMapNull(variables)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "variables"));
        }
        Process resultProcess = process;
        try {
            String link = PublicAPIUrlRegistry.getProcessVariablesUrl(this.session, process.getIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            HashMap<String, Serializable> internalVariables = new HashMap<String, Serializable>();
            if (variables != null) {
                internalVariables.putAll(variables);
            }
            JSONArray ja = new JSONArray();
            for (Map.Entry entry : internalVariables.entrySet()) {
                JSONObject jo = new JSONObject();
                jo.put("name", (Object)PublicAPIWorkflowServiceImpl.encodeKey((String)entry.getKey()));
                jo.put("value", entry.getValue());
                ja.add((Object)jo);
            }
            final JsonDataWriter dataWriter = new JsonDataWriter(ja);
            this.post(url, dataWriter.getContentType(), new Output(){

                public void write(OutputStream out) throws IOException {
                    dataWriter.write(out);
                }
            }, 1100);
            resultProcess = this.refresh(process);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            PublicAPIWorkflowServiceImpl.convertException(e);
        }
        return resultProcess;
    }

    @Override
    public UrlBuilder getProcessDiagramUrl(String processId) {
        String url = PublicAPIUrlRegistry.getWorkflowDiagram(this.session, processId);
        return new UrlBuilder(url);
    }

    @Override
    public ContentStream getProcessDiagram(Process process) {
        if (this.isObjectNull(process)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "process"));
        }
        return this.getProcessDiagram(process.getIdentifier());
    }

    @Override
    public ContentStream getProcessDiagram(String processId) {
        if (this.isStringNull(processId)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "processId"));
        }
        try {
            ContentStreamImpl cf = null;
            String url = PublicAPIUrlRegistry.getWorkflowDiagram(this.session, processId);
            UrlBuilder builder = new UrlBuilder(url);
            Response resp = this.read(builder, 1100);
            cf = new ContentStreamImpl(resp.getStream(), resp.getContentTypeHeader(), resp.getContentLength().longValue());
            return cf;
        }
        catch (Exception e) {
            PublicAPIWorkflowServiceImpl.convertException(e);
            return null;
        }
    }

    private Property parseProperty(Map<String, Object> data) {
        if (VARIABLE_TYPES.containsKey((String)data.get("type"))) {
            PropertyType type = VARIABLE_TYPES.get((String)data.get("type"));
            switch (type) {
                case DATETIME: {
                    GregorianCalendar g = new GregorianCalendar();
                    g.setTime(DateUtils.parseDate((String)data.get("value"), this.sdf));
                    return new PropertyImpl(g, type);
                }
                case INTEGER: {
                    return new PropertyImpl(((BigInteger)data.get("value")).intValue(), type);
                }
            }
            return new PropertyImpl(data.get("value"), type);
        }
        return null;
    }

    private Object getPredicate(ListingFilter filter) {
        return this.getPredicate(null, filter);
    }

    private String getPredicate(String processIdentifier, ListingFilter filter) {
        return this.getPredicate(processIdentifier, filter, false);
    }

    private String getPredicate(String processIdentifier, ListingFilter filter, boolean isProcess) {
        StringBuilder sb = new StringBuilder("(");
        if (processIdentifier != null) {
            PublicAPIWorkflowServiceImpl.addPredicate(sb, "processInstanceId", Integer.parseInt(processIdentifier));
        }
        if (filter == null) {
            sb.append(")");
            return sb.toString();
        }
        if (isProcess && filter.hasFilterValue("filterInitiator")) {
            if (filter.getFilterValue("filterInitiator") instanceof String) {
                PublicAPIWorkflowServiceImpl.addPredicate(sb, "startUserId", (String)((Object)filter.getFilterValue("filterInitiator")));
            } else if (1 == (Integer)filter.getFilterValue("filterInitiator")) {
                PublicAPIWorkflowServiceImpl.addPredicate(sb, "startUserId", this.session.getPersonIdentifier());
            } else if (2 == (Integer)filter.getFilterValue("filterInitiator")) {
                // empty if block
            }
        } else if (isProcess) {
            PublicAPIWorkflowServiceImpl.addPredicate(sb, "startUserId", this.session.getPersonIdentifier());
        }
        if (!isProcess && filter.getFilterValue("filterAssignee") instanceof String) {
            PublicAPIWorkflowServiceImpl.addPredicate(sb, "assignee", (String)((Object)filter.getFilterValue("filterAssignee")));
        } else if (!isProcess && filter.getFilterValue("filterAssignee") instanceof Integer) {
            switch ((Integer)filter.getFilterValue("filterAssignee")) {
                case 2: {
                    PublicAPIWorkflowServiceImpl.addPredicate(sb, "candidateUser", this.session.getPersonIdentifier());
                    break;
                }
                case 1: {
                    PublicAPIWorkflowServiceImpl.addPredicate(sb, "assignee", this.session.getPersonIdentifier());
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
            }
        } else if (isProcess || processIdentifier == null) {
            // empty if block
        }
        if (filter.hasFilterValue("filterPriority")) {
            PublicAPIWorkflowServiceImpl.addPredicate(sb, "priority", (Integer)filter.getFilterValue("filterPriority"));
        }
        if (filter.hasFilterValue("filterStatus")) {
            switch ((Integer)filter.getFilterValue("filterStatus")) {
                case 0: {
                    PublicAPIWorkflowServiceImpl.addPredicate(sb, "status", "any");
                    break;
                }
                case 2: {
                    PublicAPIWorkflowServiceImpl.addPredicate(sb, "status", "completed");
                    break;
                }
            }
        }
        if (filter.hasFilterValue("filterDue")) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(10, 11);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
            switch ((Integer)filter.getFilterValue("filterDue")) {
                case 0: {
                    PublicAPIWorkflowServiceImpl.addPredicate(sb, "dueAt", DateUtils.formatISO(calendar), "<");
                    calendar.add(5, -1);
                    PublicAPIWorkflowServiceImpl.addPredicate(sb, "dueAt", DateUtils.formatISO(calendar), ">");
                    break;
                }
                case 1: {
                    PublicAPIWorkflowServiceImpl.addPredicate(sb, "dueAt", DateUtils.formatISO(calendar), ">");
                    calendar.add(5, 1);
                    PublicAPIWorkflowServiceImpl.addPredicate(sb, "dueAt", DateUtils.formatISO(calendar), "<");
                    break;
                }
                case 7: {
                    PublicAPIWorkflowServiceImpl.addPredicate(sb, "dueAt", DateUtils.formatISO(calendar), ">");
                    calendar.add(5, 7);
                    PublicAPIWorkflowServiceImpl.addPredicate(sb, "dueAt", DateUtils.formatISO(calendar), "<");
                    break;
                }
                case 100: {
                    calendar.add(5, -1);
                    PublicAPIWorkflowServiceImpl.addPredicate(sb, "dueAt", DateUtils.formatISO(calendar), "<");
                    break;
                }
                case -1: {
                    PublicAPIWorkflowServiceImpl.addPredicate(sb, "dueAt", DateUtils.formatISO(calendar), "LIKE");
                    break;
                }
            }
        }
        if (filter.hasFilterValue(INCLUDE_VARIABLES)) {
            PublicAPIWorkflowServiceImpl.addPredicate(sb, "includeVariables", "true");
        }
        sb.append(")");
        return "()".equals(sb.toString()) ? "" : sb.toString();
    }

    private static void addPredicate(StringBuilder queryPart, String name, String value) {
        if (name == null || value == null) {
            return;
        }
        if (queryPart.length() > 1) {
            queryPart.append(" AND ");
        }
        queryPart.append(name);
        queryPart.append("='");
        queryPart.append(value);
        queryPart.append("'");
    }

    private static void addPredicate(StringBuilder queryPart, String name, String value, String operator) {
        if (name == null || value == null) {
            return;
        }
        if (queryPart.length() > 1) {
            queryPart.append(" AND ");
        }
        queryPart.append(name);
        queryPart.append(operator);
        queryPart.append("'");
        queryPart.append(value);
        queryPart.append("'");
    }

    private static void addPredicate(StringBuilder queryPart, String name, int value) {
        if (name == null) {
            return;
        }
        if (queryPart.length() > 1) {
            queryPart.append(" AND ");
        }
        try {
            queryPart.append(URLEncoder.encode(name, "UTF-8"));
            queryPart.append("=");
            queryPart.append(value);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private boolean hasMoreItems(boolean hasMoreItems, int skipCount, int totalItems) {
        return totalItems == -1 ? hasMoreItems : (skipCount >= totalItems ? false : hasMoreItems);
    }

    public PublicAPIWorkflowServiceImpl(Parcel o) {
        super((AlfrescoSession)o.readParcelable(RepositorySessionImpl.class.getClassLoader()));
    }
}

