/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl.publicapi;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.Tag;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.model.impl.TagImpl;
import org.alfresco.mobile.android.api.services.TaggingService;
import org.alfresco.mobile.android.api.services.impl.AlfrescoService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.impl.RepositorySessionImpl;
import org.alfresco.mobile.android.api.utils.JsonDataWriter;
import org.alfresco.mobile.android.api.utils.PublicAPIResponse;
import org.alfresco.mobile.android.api.utils.PublicAPIUrlRegistry;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.json.JSONArray;
import org.json.JSONObject;

public class PublicAPITaggingServiceImpl
extends AlfrescoService
implements TaggingService {
    public static final Parcelable.Creator<PublicAPITaggingServiceImpl> CREATOR = new Parcelable.Creator<PublicAPITaggingServiceImpl>(){

        public PublicAPITaggingServiceImpl createFromParcel(Parcel in) {
            return new PublicAPITaggingServiceImpl(in);
        }

        public PublicAPITaggingServiceImpl[] newArray(int size) {
            return new PublicAPITaggingServiceImpl[size];
        }
    };

    public PublicAPITaggingServiceImpl(AlfrescoSession repositorySession) {
        super(repositorySession);
    }

    @Override
    public List<Tag> getAllTags() {
        return this.getAllTags(null).getList();
    }

    @Override
    public PagingResult<Tag> getAllTags(ListingContext listingContext) {
        try {
            String link = PublicAPIUrlRegistry.getTagsUrl(this.session);
            UrlBuilder url = new UrlBuilder(link);
            if (listingContext != null) {
                url.addParameter("maxItems", (Object)listingContext.getMaxItems());
                url.addParameter("skipCount", (Object)listingContext.getSkipCount());
            }
            return this.computeTag(url);
        }
        catch (Exception e) {
            PublicAPITaggingServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public List<Tag> getTags(Node node) {
        return this.getTags(node, null).getList();
    }

    @Override
    public PagingResult<Tag> getTags(Node node, ListingContext listingContext) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        try {
            String link = PublicAPIUrlRegistry.getTagsUrl(this.session, node.getIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            if (listingContext != null) {
                url.addParameter("maxItems", (Object)listingContext.getMaxItems());
                url.addParameter("skipCount", (Object)listingContext.getSkipCount());
            }
            return this.computeTag(url);
        }
        catch (Exception e) {
            PublicAPITaggingServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public void addTags(Node node, List<String> tags) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        if (this.isListNull(tags)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "tags"));
        }
        try {
            String link = PublicAPIUrlRegistry.getTagsUrl(this.session, node.getIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            JSONArray ja = new JSONArray();
            JSONObject jo = null;
            for (String tag : tags) {
                jo = new JSONObject();
                jo.put("tag", (Object)tag);
                ja.put((Object)jo);
            }
            final JsonDataWriter formData = new JsonDataWriter(ja);
            this.post(url, formData.getContentType(), new Output(){

                public void write(OutputStream out) throws IOException {
                    formData.write(out);
                }
            }, 700);
        }
        catch (Exception e) {
            PublicAPITaggingServiceImpl.convertException(e);
        }
    }

    private PagingResult<Tag> computeTag(UrlBuilder url) {
        Response resp = this.read(url, 700);
        PublicAPIResponse response = new PublicAPIResponse(resp);
        ArrayList<Tag> result = new ArrayList<Tag>();
        Map data = null;
        for (Object entry : response.getEntries()) {
            data = (Map)((Map)entry).get("entry");
            result.add(TagImpl.parsePublicAPIJson(data));
        }
        return new PagingResultImpl<Tag>(result, response.getHasMoreItems(), response.getSize());
    }

    public PublicAPITaggingServiceImpl(Parcel o) {
        super((AlfrescoSession)o.readParcelable(RepositorySessionImpl.class.getClassLoader()));
    }
}

