/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl.publicapi;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.exceptions.AlfrescoServiceException;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.Person;
import org.alfresco.mobile.android.api.model.Site;
import org.alfresco.mobile.android.api.model.impl.JoinSiteRequestImpl;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.model.impl.PersonImpl;
import org.alfresco.mobile.android.api.model.impl.SiteImpl;
import org.alfresco.mobile.android.api.services.cache.impl.CacheSiteExtraProperties;
import org.alfresco.mobile.android.api.services.impl.AbstractSiteServiceImpl;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.impl.RepositorySessionImpl;
import org.alfresco.mobile.android.api.utils.JsonDataWriter;
import org.alfresco.mobile.android.api.utils.JsonUtils;
import org.alfresco.mobile.android.api.utils.PublicAPIResponse;
import org.alfresco.mobile.android.api.utils.PublicAPIUrlRegistry;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;

public class PublicAPISiteServiceImpl
extends AbstractSiteServiceImpl {
    private static final String TAG = "CloudSiteServiceImpl";
    public static final Parcelable.Creator<PublicAPISiteServiceImpl> CREATOR = new Parcelable.Creator<PublicAPISiteServiceImpl>(){

        public PublicAPISiteServiceImpl createFromParcel(Parcel in) {
            return new PublicAPISiteServiceImpl(in);
        }

        public PublicAPISiteServiceImpl[] newArray(int size) {
            return new PublicAPISiteServiceImpl[size];
        }
    };

    public PublicAPISiteServiceImpl(AlfrescoSession repositorySession) {
        super(repositorySession);
    }

    @Override
    protected UrlBuilder getAllSitesUrl(ListingContext listingContext) {
        String link = PublicAPIUrlRegistry.getAllSitesUrl(this.session);
        UrlBuilder url = new UrlBuilder(link);
        if (listingContext != null) {
            url.addParameter("maxItems", (Object)listingContext.getMaxItems());
            url.addParameter("skipCount", (Object)listingContext.getSkipCount());
        }
        return url;
    }

    @Override
    protected UrlBuilder getUserSitesUrl(String personIdentifier, ListingContext listingContext) {
        String link = PublicAPIUrlRegistry.getUserSitesUrl(this.session, this.session.getPersonIdentifier());
        UrlBuilder url = new UrlBuilder(link);
        if (listingContext != null) {
            url.addParameter("maxItems", (Object)listingContext.getMaxItems());
            url.addParameter("skipCount", (Object)listingContext.getSkipCount());
        }
        return url;
    }

    @Override
    protected PagingResult<Site> computeFavoriteSites(ListingContext listingContext) {
        String link = PublicAPIUrlRegistry.getUserFavoriteSitesUrl(this.session, this.session.getPersonIdentifier());
        UrlBuilder url = new UrlBuilder(link);
        if (listingContext != null) {
            url.addParameter("maxItems", (Object)listingContext.getMaxItems());
            url.addParameter("skipCount", (Object)listingContext.getSkipCount());
        }
        return this.computeSites(url, true);
    }

    @Override
    protected UrlBuilder getSiteUrl(String siteIdentifier) {
        String link = PublicAPIUrlRegistry.getSiteUrl(this.session, siteIdentifier);
        return new UrlBuilder(link);
    }

    @Override
    protected Site parseData(String siteIdentifier, Map<String, Object> json) {
        if (json.containsKey("entry")) {
            if (this.extraPropertiesCache.get((Object)siteIdentifier) != null) {
                CacheSiteExtraProperties extraProperties = (CacheSiteExtraProperties)this.extraPropertiesCache.get((Object)siteIdentifier);
                json.put("isPendingMember", extraProperties.isPendingMember);
                json.put("isMember", extraProperties.isMember);
                json.put("isFavorite", extraProperties.isFavorite);
            }
            return SiteImpl.parsePublicAPIJson((Map)json.get("entry"));
        }
        return null;
    }

    @Override
    protected String getDocContainerSiteUrl(Site site) {
        return PublicAPIUrlRegistry.getDocContainerSiteUrl(this.session, site.getShortName());
    }

    @Override
    public Site addFavoriteSite(Site site) {
        if (this.isObjectNull(site)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "site"));
        }
        SiteImpl updatedSite = null;
        try {
            String link = PublicAPIUrlRegistry.getUserPreferenceUrl(this.session, this.session.getPersonIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            String[] sitePrefence = new String[]{"target", "site"};
            JSONObject jroot = new JSONObject();
            JSONObject jt = null;
            JSONObject jp = jroot;
            for (int i = 0; i < sitePrefence.length; ++i) {
                jt = new JSONObject();
                jp.put(sitePrefence[i], (Object)jt);
                jp = jt;
            }
            jt.put("guid", (Object)site.getGUID());
            final JsonDataWriter formDataM = new JsonDataWriter(jroot);
            this.post(url, formDataM.getContentType(), new Output(){

                public void write(OutputStream out) throws IOException {
                    formDataM.write(out);
                }
            }, 400);
            this.updateExtraPropertyCache(site.getIdentifier(), site.isPendingMember(), site.isMember(), true);
            updatedSite = new SiteImpl(site, site.isPendingMember(), site.isMember(), true);
            this.validateUpdateSite(updatedSite, 400);
        }
        catch (Exception e) {
            PublicAPISiteServiceImpl.convertException(e);
        }
        return updatedSite;
    }

    @Override
    public Site removeFavoriteSite(Site site) {
        if (this.isObjectNull(site)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "site"));
        }
        SiteImpl updatedSite = null;
        try {
            String link = PublicAPIUrlRegistry.getRemoveUserPreferenceUrl(this.session, this.session.getPersonIdentifier(), site.getGUID());
            this.delete(new UrlBuilder(link), 400);
            this.updateExtraPropertyCache(site.getIdentifier(), site.isPendingMember(), site.isMember(), false);
            updatedSite = new SiteImpl(site, site.isPendingMember(), site.isMember(), false);
            this.validateUpdateSite(updatedSite, 400);
        }
        catch (Exception e) {
            PublicAPISiteServiceImpl.convertException(e);
        }
        return updatedSite;
    }

    @Override
    public Site joinSite(Site site) {
        if (this.isObjectNull(site)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "site"));
        }
        SiteImpl updatedSite = null;
        try {
            String link = null;
            UrlBuilder url = null;
            Response resp = null;
            JSONObject jo = null;
            link = PublicAPIUrlRegistry.getJoinSiteUrl(this.session, this.session.getPersonIdentifier());
            url = new UrlBuilder(link);
            jo = new JSONObject();
            jo.put("id", (Object)site.getIdentifier());
            final JsonDataWriter formDataM = new JsonDataWriter(jo);
            resp = this.getHttpInvoker().invokePOST(url, formDataM.getContentType(), new Output(){

                public void write(OutputStream out) throws IOException {
                    formDataM.write(out);
                }
            }, this.getSessionHttp());
            switch (site.getVisibility()) {
                case PUBLIC: {
                    if (resp.getResponseCode() == 400) {
                        throw new AlfrescoServiceException(403, Messagesl18n.getString("ErrorCodeRegistry.SITE_ALREADY_MEMBER"));
                    }
                    if (resp.getResponseCode() != 200 && resp.getResponseCode() != 201) {
                        this.convertStatusCode(resp, 400);
                    }
                    this.updateExtraPropertyCache(site.getIdentifier(), false, true, site.isFavorite());
                    updatedSite = new SiteImpl(site, false, true, site.isFavorite());
                    this.validateUpdateSite(updatedSite, 400);
                    break;
                }
                case MODERATED: {
                    Map<String, Object> json;
                    Map data;
                    JoinSiteRequestImpl request;
                    if (resp.getResponseCode() == 400) {
                        throw new AlfrescoServiceException(403, Messagesl18n.getString("ErrorCodeRegistry.SITE_ALREADY_MEMBER"));
                    }
                    if (resp.getResponseCode() != 200 && resp.getResponseCode() != 201) {
                        this.convertStatusCode(resp, 400);
                    }
                    if ((request = JoinSiteRequestImpl.parsePublicAPIJson(data = (Map)(json = JsonUtils.parseObject(resp.getStream(), resp.getCharset())).get("entry"))) != null) {
                        this.updateExtraPropertyCache(site.getIdentifier(), true, false, site.isFavorite());
                        updatedSite = new SiteImpl(site, true, false, site.isFavorite());
                        this.validateUpdateSite(updatedSite, 400);
                        break;
                    }
                    throw new AlfrescoServiceException(400, Messagesl18n.getString("ErrorCodeRegistry.SITE_NOT_JOINED.parsing"));
                }
                case PRIVATE: {
                    throw new AlfrescoServiceException(400, Messagesl18n.getString("ErrorCodeRegistry.SITE_NOT_JOINED.private"));
                }
                default: {
                    if (resp.getResponseCode() != 200 && resp.getResponseCode() != 201) {
                        this.convertStatusCode(resp, 400);
                    }
                    throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "visibility"));
                }
            }
        }
        catch (Exception e) {
            PublicAPISiteServiceImpl.convertException(e);
        }
        return updatedSite;
    }

    @Override
    protected List<JoinSiteRequestImpl> getJoinSiteRequests() {
        ArrayList<JoinSiteRequestImpl> requestList = new ArrayList<JoinSiteRequestImpl>();
        try {
            String link = PublicAPIUrlRegistry.getJoinRequestSiteUrl(this.session, this.session.getPersonIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            Response resp = this.read(url, 400);
            PublicAPIResponse response = new PublicAPIResponse(resp);
            Map data = null;
            for (Object entry : response.getEntries()) {
                data = (Map)((Map)entry).get("entry");
                requestList.add(JoinSiteRequestImpl.parsePublicAPIJson(data));
            }
        }
        catch (Exception e) {
            PublicAPISiteServiceImpl.convertException(e);
        }
        return requestList;
    }

    @Override
    protected PagingResult<JoinSiteRequestImpl> getJoinSiteRequests(ListingContext listingContext) {
        ArrayList<JoinSiteRequestImpl> requestList = new ArrayList<JoinSiteRequestImpl>();
        String link = PublicAPIUrlRegistry.getJoinRequestSiteUrl(this.session, this.session.getPersonIdentifier());
        UrlBuilder url = new UrlBuilder(link);
        if (listingContext != null) {
            url.addParameter("maxItems", (Object)listingContext.getMaxItems());
            url.addParameter("skipCount", (Object)listingContext.getSkipCount());
        }
        Response resp = this.read(url, 400);
        PublicAPIResponse response = new PublicAPIResponse(resp);
        Map data = null;
        for (Object entry : response.getEntries()) {
            data = (Map)((Map)entry).get("entry");
            requestList.add(JoinSiteRequestImpl.parsePublicAPIJson(data));
        }
        return new PagingResultImpl<JoinSiteRequestImpl>(requestList, response.getHasMoreItems(), response.getSize());
    }

    @Override
    protected String getCancelJoinSiteRequestUrl(JoinSiteRequestImpl joinSiteRequest) {
        return PublicAPIUrlRegistry.getCancelJoinSiteRequestUrl(this.session, joinSiteRequest.getSiteShortName(), this.session.getPersonIdentifier());
    }

    @Override
    protected String getLeaveSiteUrl(Site site) {
        return PublicAPIUrlRegistry.getLeaveSiteUrl(this.session, site.getIdentifier(), this.session.getPersonIdentifier());
    }

    protected PagingResult<Site> computeSites(UrlBuilder url, boolean isAllSite) {
        Response resp = this.read(url, 400);
        PublicAPIResponse response = new PublicAPIResponse(resp);
        ArrayList<SiteImpl> result = new ArrayList<SiteImpl>();
        Map data = null;
        CacheSiteExtraProperties extraProperties = null;
        String siteName = null;
        for (Object entry : response.getEntries()) {
            data = (Map)((Map)entry).get("entry");
            if (!isAllSite) {
                data = (Map)data.get("site");
            }
            if (this.extraPropertiesCache.get((Object)(siteName = JSONConverter.getString((Map)data, (String)"id"))) != null) {
                extraProperties = (CacheSiteExtraProperties)this.extraPropertiesCache.get((Object)siteName);
                data.put("isPendingMember", extraProperties.isPendingMember);
                data.put("isMember", extraProperties.isMember);
                data.put("isFavorite", extraProperties.isFavorite);
            }
            result.add(SiteImpl.parsePublicAPIJson(data));
        }
        return new PagingResultImpl<Site>(result, response.getHasMoreItems(), response.getSize());
    }

    @Override
    protected String parseContainer(String link) {
        block3: {
            try {
                Response resp = this.read(new UrlBuilder(link), 400);
                PublicAPIResponse response = new PublicAPIResponse(resp);
                Map data = null;
                for (Object entry : response.getEntries()) {
                    data = (Map)((Map)entry).get("entry");
                    if (!data.containsKey("folderId") || !"documentLibrary".equals(data.get("folderId"))) continue;
                    return (String)data.get("id");
                }
            }
            catch (AlfrescoServiceException e) {
                if (e.getErrorCode() == 400) break block3;
                PublicAPISiteServiceImpl.convertException(e);
            }
        }
        return null;
    }

    @Override
    protected PagingResult<Site> computeSites(UrlBuilder url, ListingContext listingContext) {
        return this.computeSites(url, false);
    }

    @Override
    protected PagingResult<Site> computeAllSites(UrlBuilder url, ListingContext listingContext) {
        return this.computeSites(url, true);
    }

    private List<String> getSiteIdentifier(UrlBuilder url) {
        Response resp = this.read(url, 400);
        PublicAPIResponse response = new PublicAPIResponse(resp);
        ArrayList<String> result = new ArrayList<String>();
        Map data = null;
        for (Object entry : response.getEntries()) {
            data = (Map)((Map)entry).get("entry");
            result.add(JSONConverter.getString((Map)data, (String)"id"));
        }
        return result;
    }

    @Override
    protected void retrieveExtraProperties(String personIdentifier) {
        try {
            ArrayList<JoinSiteRequestImpl> joinSiteRequestList = new ArrayList();
            try {
                joinSiteRequestList = this.getJoinSiteRequests();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error during cache operation : JoinSiteRequest");
                Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            }
            String link = PublicAPIUrlRegistry.getUserFavoriteSitesUrl(this.session, personIdentifier);
            List<String> favoriteSites = this.getSiteIdentifier(new UrlBuilder(link));
            link = PublicAPIUrlRegistry.getUserSitesUrl(this.session, personIdentifier);
            List<String> userSites = this.getSiteIdentifier(new UrlBuilder(link));
            this.retrieveExtraProperties(favoriteSites, userSites, joinSiteRequestList);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error during cache operation. The site object may contains incorrect informations");
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    @Override
    public List<Person> getAllMembers(Site site) {
        return this.getAllMembers(site, null).getList();
    }

    @Override
    public PagingResult<Person> getAllMembers(Site site, ListingContext listingContext) {
        ArrayList<PersonImpl> personList = new ArrayList<PersonImpl>();
        String link = PublicAPIUrlRegistry.getAllMembersSiteUrl(this.session, site.getIdentifier());
        UrlBuilder url = new UrlBuilder(link);
        if (listingContext != null) {
            url.addParameter("maxItems", (Object)listingContext.getMaxItems());
            url.addParameter("skipCount", (Object)listingContext.getSkipCount());
        }
        Response resp = this.read(url, 400);
        PublicAPIResponse response = new PublicAPIResponse(resp);
        Map data = null;
        for (Object entry : response.getEntries()) {
            data = (Map)((Map)entry).get("entry");
            personList.add(PersonImpl.parsePublicAPIJson((Map)data.get("person")));
        }
        return new PagingResultImpl<Person>(personList, response.getHasMoreItems(), response.getSize());
    }

    @Override
    public boolean isMember(Site site, Person person) {
        if (this.isObjectNull(site)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "site"));
        }
        if (this.isObjectNull(person)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "person"));
        }
        boolean isMember = false;
        try {
            String link = PublicAPIUrlRegistry.getMemberOfSiteUrl(this.session, site.getIdentifier(), person.getIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            Response resp = this.read(url, 400);
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            Map data = (Map)json.get("entry");
            if (data != null) {
                isMember = true;
            }
        }
        catch (AlfrescoServiceException e) {
            if (e.getErrorCode() == 400) {
                isMember = false;
            }
            PublicAPISiteServiceImpl.convertException(e);
        }
        return isMember;
    }

    @Override
    public List<Person> searchMembers(Site site, String keywords) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PagingResult<Person> searchMembers(Site site, String keywords, ListingContext listingContext) {
        throw new UnsupportedOperationException();
    }

    public PublicAPISiteServiceImpl(Parcel o) {
        super((AlfrescoSession)o.readParcelable(RepositorySessionImpl.class.getClassLoader()));
    }
}

