/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl.publicapi;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Map;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.services.impl.AbstractRatingsService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.impl.RepositorySessionImpl;
import org.alfresco.mobile.android.api.utils.PublicAPIResponse;
import org.alfresco.mobile.android.api.utils.PublicAPIUrlRegistry;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;

public class PublicAPIRatingsServiceImpl
extends AbstractRatingsService {
    public static final Parcelable.Creator<PublicAPIRatingsServiceImpl> CREATOR = new Parcelable.Creator<PublicAPIRatingsServiceImpl>(){

        public PublicAPIRatingsServiceImpl createFromParcel(Parcel in) {
            return new PublicAPIRatingsServiceImpl(in);
        }

        public PublicAPIRatingsServiceImpl[] newArray(int size) {
            return new PublicAPIRatingsServiceImpl[size];
        }
    };

    public PublicAPIRatingsServiceImpl(AlfrescoSession repositorySession) {
        super(repositorySession);
    }

    @Override
    protected UrlBuilder getRatingsUrl(Node node) {
        return new UrlBuilder(PublicAPIUrlRegistry.getRatingsUrl(this.session, node.getIdentifier()));
    }

    @Override
    protected JSONObject getRatingsObject() {
        JSONObject jo = new JSONObject();
        jo.put("myRating", (Object)true);
        jo.put("id", (Object)"likes");
        return jo;
    }

    @Override
    protected UrlBuilder getUnlikeUrl(Node node) {
        return new UrlBuilder(PublicAPIUrlRegistry.getUnlikeUrl(this.session, node.getIdentifier()));
    }

    @Override
    protected int computeRatingsCount(UrlBuilder url) {
        Response resp = this.read(url, 1000);
        PublicAPIResponse response = new PublicAPIResponse(resp);
        Map data = null;
        for (Object entry : response.getEntries()) {
            data = (Map)((Map)entry).get("entry");
            if (!data.containsKey("id") || !"likes".equals(data.get("id")) || !data.containsKey("aggregate")) continue;
            return JSONConverter.getInteger((Map)((Map)data.get("aggregate")), (String)"numberOfRatings").intValue();
        }
        return -1;
    }

    @Override
    protected boolean computeIsRated(UrlBuilder url) {
        Response resp = this.read(url, 1000);
        PublicAPIResponse response = new PublicAPIResponse(resp);
        Map data = null;
        for (Object entry : response.getEntries()) {
            data = (Map)((Map)entry).get("entry");
            if (!data.containsKey("id") || !"likes".equals(data.get("id")) || !data.containsKey("myRating")) continue;
            return true;
        }
        return false;
    }

    public PublicAPIRatingsServiceImpl(Parcel o) {
        super((AlfrescoSession)o.readParcelable(RepositorySessionImpl.class.getClassLoader()));
    }
}

