/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl.publicapi;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.exceptions.AlfrescoServiceException;
import org.alfresco.mobile.android.api.model.ContentStream;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.Person;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.model.impl.PersonImpl;
import org.alfresco.mobile.android.api.services.impl.AbstractDocumentFolderServiceImpl;
import org.alfresco.mobile.android.api.services.impl.AbstractPersonService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.CloudSession;
import org.alfresco.mobile.android.api.session.impl.AbstractAlfrescoSessionImpl;
import org.alfresco.mobile.android.api.session.impl.RepositorySessionImpl;
import org.alfresco.mobile.android.api.utils.JsonUtils;
import org.alfresco.mobile.android.api.utils.OnPremiseUrlRegistry;
import org.alfresco.mobile.android.api.utils.PublicAPIUrlRegistry;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AbstractAtomPubService;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

public class PublicAPIPersonServiceImpl
extends AbstractPersonService {
    public static final Parcelable.Creator<PublicAPIPersonServiceImpl> CREATOR = new Parcelable.Creator<PublicAPIPersonServiceImpl>(){

        public PublicAPIPersonServiceImpl createFromParcel(Parcel in) {
            return new PublicAPIPersonServiceImpl(in);
        }

        public PublicAPIPersonServiceImpl[] newArray(int size) {
            return new PublicAPIPersonServiceImpl[size];
        }
    };

    public PublicAPIPersonServiceImpl(AlfrescoSession repositorySession) {
        super(repositorySession);
    }

    @Override
    protected UrlBuilder getPersonDetailssUrl(String personIdentifier) {
        return new UrlBuilder(PublicAPIUrlRegistry.getPersonDetailssUrl(this.session, personIdentifier));
    }

    @Override
    public UrlBuilder getAvatarUrl(String personIdentifier) {
        Person person = this.getPerson(personIdentifier);
        if (person.getAvatarIdentifier() == null) {
            return null;
        }
        Session cmisSession = ((AbstractAlfrescoSessionImpl)this.session).getCmisSession();
        CmisObject obj = cmisSession.getObject(person.getAvatarIdentifier());
        String url = ((AbstractAtomPubService)cmisSession.getBinding().getObjectService()).loadLink(this.session.getRepositoryInfo().getIdentifier(), obj.getId(), "@@content@@", null);
        Log.d((String)"Avatar URL", (String)url);
        return new UrlBuilder(url);
    }

    @Override
    public ContentStream getAvatarStream(String personIdentifier) {
        if (this.isStringNull(personIdentifier)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "personIdentifier"));
        }
        try {
            Person person = this.getPerson(personIdentifier);
            if (person.getAvatarIdentifier() == null) {
                return null;
            }
            ContentStream st = ((AbstractDocumentFolderServiceImpl)this.session.getServiceRegistry().getDocumentFolderService()).downloadContentStream(person.getAvatarIdentifier());
            return st;
        }
        catch (Exception e) {
            PublicAPIPersonServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public List<Person> search(String keyword) {
        return this.search(keyword, null).getList();
    }

    @Override
    public PagingResult<Person> search(String keyword, ListingContext listingContext) {
        if (this.isStringNull(keyword)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "keyword"));
        }
        ArrayList<PersonImpl> definitions = new ArrayList<PersonImpl>();
        Map<Object, Object> json = new HashMap(0);
        int size = 0;
        try {
            Response resp;
            String link = OnPremiseUrlRegistry.getSearchPersonUrl(this.session);
            if (this.session instanceof CloudSession) {
                link = PublicAPIUrlRegistry.getSearchPersonUrl(this.session);
            }
            UrlBuilder url = new UrlBuilder(link);
            url.addParameter("filter", (Object)keyword);
            if (listingContext != null) {
                url.addParameter("maxResults", (Object)listingContext.getMaxItems());
            }
            if ((json = JsonUtils.parseObject((resp = this.read(url, 800)).getStream(), resp.getCharset())) != null) {
                List jo = (List)json.get("people");
                size = jo.size();
                for (Object obj : jo) {
                    definitions.add(PersonImpl.parseJson((Map)obj));
                }
            }
        }
        catch (Exception e) {
            PublicAPIPersonServiceImpl.convertException(e);
        }
        return new PagingResultImpl<Person>(definitions, false, size);
    }

    @Override
    public Person refresh(Person person) {
        return this.getPerson(person.getIdentifier());
    }

    @Override
    protected Person computePerson(UrlBuilder url) {
        Response resp = this.getHttpInvoker().invokeGET(url, this.getSessionHttp());
        if (resp.getResponseCode() == 500 || resp.getResponseCode() == 404) {
            throw new AlfrescoServiceException(801, resp.getErrorContent());
        }
        if (resp.getResponseCode() != 200) {
            return null;
        }
        Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
        Map data = (Map)json.get("entry");
        return PersonImpl.parsePublicAPIJson(data);
    }

    public PublicAPIPersonServiceImpl(Parcel o) {
        super((AlfrescoSession)o.readParcelable(RepositorySessionImpl.class.getClassLoader()));
    }
}

