/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl.publicapi;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.model.ContentStream;
import org.alfresco.mobile.android.api.model.Document;
import org.alfresco.mobile.android.api.model.Folder;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.impl.ContentStreamImpl;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.model.impl.cloud.CloudDocumentImpl;
import org.alfresco.mobile.android.api.model.impl.cloud.CloudFolderImpl;
import org.alfresco.mobile.android.api.model.impl.publicapi.PublicAPINodeImpl;
import org.alfresco.mobile.android.api.services.impl.AbstractDocumentFolderServiceImpl;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.impl.RepositorySessionImpl;
import org.alfresco.mobile.android.api.utils.JsonDataWriter;
import org.alfresco.mobile.android.api.utils.NodeRefUtils;
import org.alfresco.mobile.android.api.utils.OnPremiseUrlRegistry;
import org.alfresco.mobile.android.api.utils.PublicAPIResponse;
import org.alfresco.mobile.android.api.utils.PublicAPIUrlRegistry;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;

public class PublicAPIDocumentFolderServiceImpl
extends AbstractDocumentFolderServiceImpl {
    public static final Parcelable.Creator<PublicAPIDocumentFolderServiceImpl> CREATOR = new Parcelable.Creator<PublicAPIDocumentFolderServiceImpl>(){

        public PublicAPIDocumentFolderServiceImpl createFromParcel(Parcel in) {
            return new PublicAPIDocumentFolderServiceImpl(in);
        }

        public PublicAPIDocumentFolderServiceImpl[] newArray(int size) {
            return new PublicAPIDocumentFolderServiceImpl[size];
        }
    };

    public PublicAPIDocumentFolderServiceImpl(AlfrescoSession cloudSession) {
        super(cloudSession);
    }

    @Override
    public UrlBuilder getRenditionUrl(String identifier, String type) {
        try {
            UrlBuilder url = new UrlBuilder(OnPremiseUrlRegistry.getThumbnailsUrl(this.session, identifier, type));
            url.addParameter("format", (Object)"json");
            return url;
        }
        catch (Exception e) {
            PublicAPIDocumentFolderServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public ContentStream getRenditionStream(String identifier, String type) {
        try {
            ContentStreamImpl cf;
            String nodeIdentifier = identifier;
            if (NodeRefUtils.isVersionIdentifier(identifier) || NodeRefUtils.isIdentifier(identifier)) {
                nodeIdentifier = NodeRefUtils.createNodeRefByIdentifier(identifier);
            }
            UrlBuilder url = this.getRenditionUrl(nodeIdentifier, type);
            Response resp = this.getHttpInvoker().invokeGET(url, this.getSessionHttp());
            if (resp.getResponseCode() == 404) {
                cf = null;
            } else if (resp.getResponseCode() != 200) {
                this.convertStatusCode(resp, 600);
                cf = null;
            } else {
                cf = new ContentStreamImpl(resp.getStream(), resp.getContentTypeHeader() + ";" + resp.getCharset(), resp.getContentLength().longValue());
            }
            return cf;
        }
        catch (Exception e) {
            PublicAPIDocumentFolderServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public List<Document> getFavoriteDocuments() {
        return this.getFavoriteDocuments(null).getList();
    }

    @Override
    public PagingResult<Document> getFavoriteDocuments(ListingContext listingContext) {
        String link = PublicAPIUrlRegistry.getUserFavouriteDocumentsUrl(this.session, this.session.getPersonIdentifier());
        UrlBuilder url = new UrlBuilder(link);
        if (listingContext != null) {
            url.addParameter("maxItems", (Object)listingContext.getMaxItems());
            url.addParameter("skipCount", (Object)listingContext.getSkipCount());
        }
        return this.computeDocumentFavorites(url);
    }

    @Override
    public List<Folder> getFavoriteFolders() {
        return this.getFavoriteFolders(null).getList();
    }

    @Override
    public PagingResult<Folder> getFavoriteFolders(ListingContext listingContext) {
        String link = PublicAPIUrlRegistry.getUserFavouriteFoldersUrl(this.session, this.session.getPersonIdentifier());
        UrlBuilder url = new UrlBuilder(link);
        if (listingContext != null) {
            url.addParameter("maxItems", (Object)listingContext.getMaxItems());
            url.addParameter("skipCount", (Object)listingContext.getSkipCount());
        }
        return this.computeFolderFavorites(url);
    }

    @Override
    public List<Node> getFavoriteNodes() {
        return this.getFavoriteNodes(null).getList();
    }

    @Override
    public PagingResult<Node> getFavoriteNodes(ListingContext listingContext) {
        String link = PublicAPIUrlRegistry.getUserFavouritesUrl(this.session, this.session.getPersonIdentifier());
        UrlBuilder url = new UrlBuilder(link);
        if (listingContext != null) {
            url.addParameter("maxItems", (Object)listingContext.getMaxItems());
            url.addParameter("skipCount", (Object)listingContext.getSkipCount());
        }
        return this.computeFavorites(url);
    }

    @Override
    public boolean isFavorite(Node node) {
        String link = PublicAPIUrlRegistry.getUserFavouriteUrl(this.session, this.session.getPersonIdentifier(), NodeRefUtils.getCleanIdentifier(node.getIdentifier()));
        UrlBuilder url = new UrlBuilder(link);
        Response resp = this.getHttpInvoker().invokeGET(url, this.getSessionHttp());
        return resp.getResponseCode() == 200;
    }

    @Override
    public void addFavorite(Node node) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        try {
            String link = PublicAPIUrlRegistry.getUserPreferenceUrl(this.session, this.session.getPersonIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            String preferenceFilter = "target.file";
            if (node.isFolder()) {
                preferenceFilter = "target.folder";
            }
            String[] filter = preferenceFilter.split("\\.");
            JSONObject jroot = new JSONObject();
            JSONObject jt = null;
            JSONObject jp = jroot;
            for (int i = 0; i < filter.length; ++i) {
                jt = new JSONObject();
                jp.put(filter[i], (Object)jt);
                jp = jt;
            }
            jt.put("guid", (Object)NodeRefUtils.getCleanIdentifier(node.getIdentifier()));
            final JsonDataWriter formDataM = new JsonDataWriter(jroot);
            this.post(url, formDataM.getContentType(), new Output(){

                public void write(OutputStream out) throws IOException {
                    formDataM.write(out);
                }
            }, 600);
        }
        catch (Exception e) {
            PublicAPIDocumentFolderServiceImpl.convertException(e);
        }
    }

    @Override
    public void removeFavorite(Node node) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        try {
            String link = PublicAPIUrlRegistry.getUserFavouriteUrl(this.session, this.session.getPersonIdentifier(), node.getIdentifier());
            this.delete(new UrlBuilder(link), 600);
        }
        catch (Exception e) {
            PublicAPIDocumentFolderServiceImpl.convertException(e);
        }
    }

    protected PagingResult<Document> computeDocumentFavorites(UrlBuilder url) {
        Response resp = this.read(url, 600);
        PublicAPIResponse response = new PublicAPIResponse(resp);
        ArrayList<CloudDocumentImpl> result = new ArrayList<CloudDocumentImpl>();
        Map entryData = null;
        Map targetData = null;
        Map fileData = null;
        for (Object entry : response.getEntries()) {
            entryData = (Map)((Map)entry).get("entry");
            targetData = (Map)entryData.get("target");
            fileData = (Map)targetData.get("file");
            result.add(new CloudDocumentImpl(fileData));
        }
        return new PagingResultImpl<Document>(result, response.getHasMoreItems(), response.getSize());
    }

    protected PagingResult<Folder> computeFolderFavorites(UrlBuilder url) {
        Response resp = this.read(url, 600);
        PublicAPIResponse response = new PublicAPIResponse(resp);
        ArrayList<CloudFolderImpl> result = new ArrayList<CloudFolderImpl>();
        Map entryData = null;
        Map targetData = null;
        Map fileData = null;
        for (Object entry : response.getEntries()) {
            entryData = (Map)((Map)entry).get("entry");
            targetData = (Map)entryData.get("target");
            fileData = (Map)targetData.get("folder");
            if (fileData == null) continue;
            result.add(new CloudFolderImpl(fileData));
        }
        return new PagingResultImpl<Folder>(result, response.getHasMoreItems(), response.getSize());
    }

    protected PagingResult<Node> computeFavorites(UrlBuilder url) {
        Response resp = this.read(url, 600);
        PublicAPIResponse response = new PublicAPIResponse(resp);
        ArrayList<PublicAPINodeImpl> result = new ArrayList<PublicAPINodeImpl>();
        Map entryData = null;
        Map targetData = null;
        Map fileData = null;
        boolean isDocument = true;
        for (Object entry : response.getEntries()) {
            entryData = (Map)((Map)entry).get("entry");
            targetData = (Map)entryData.get("target");
            isDocument = true;
            if (targetData.containsKey("folder")) {
                isDocument = false;
            }
            if (isDocument) {
                fileData = (Map)targetData.get("file");
                result.add(new CloudDocumentImpl(fileData));
                continue;
            }
            fileData = (Map)targetData.get("folder");
            result.add(new CloudFolderImpl(fileData));
        }
        return new PagingResultImpl<Node>(result, response.getHasMoreItems(), response.getSize());
    }

    public PublicAPIDocumentFolderServiceImpl(Parcel o) {
        super((AlfrescoSession)o.readParcelable(RepositorySessionImpl.class.getClassLoader()));
    }
}

