/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl.publicapi;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Map;
import org.alfresco.mobile.android.api.model.Comment;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.impl.CommentImpl;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.services.impl.AbstractCommentService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.impl.RepositorySessionImpl;
import org.alfresco.mobile.android.api.utils.PublicAPIResponse;
import org.alfresco.mobile.android.api.utils.PublicAPIUrlRegistry;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

public class PublicAPICommentServiceImpl
extends AbstractCommentService {
    public static final Parcelable.Creator<PublicAPICommentServiceImpl> CREATOR = new Parcelable.Creator<PublicAPICommentServiceImpl>(){

        public PublicAPICommentServiceImpl createFromParcel(Parcel in) {
            return new PublicAPICommentServiceImpl(in);
        }

        public PublicAPICommentServiceImpl[] newArray(int size) {
            return new PublicAPICommentServiceImpl[size];
        }
    };

    public PublicAPICommentServiceImpl(AlfrescoSession repositorySession) {
        super(repositorySession);
    }

    @Override
    protected UrlBuilder getCommentsUrl(Node node, ListingContext listingContext, boolean isReadOperation) {
        String link = PublicAPIUrlRegistry.getCommentsUrl(this.session, node.getIdentifier());
        UrlBuilder url = new UrlBuilder(link);
        if (listingContext != null) {
            url.addParameter("skipCount", (Object)listingContext.getSkipCount());
            url.addParameter("maxItems", (Object)listingContext.getMaxItems());
        }
        return url;
    }

    @Override
    protected Comment parseData(Map<String, Object> json) {
        return CommentImpl.parsePublicAPIJson((Map)json.get("entry"));
    }

    @Override
    protected UrlBuilder getCommentUrl(Node node, Comment comment) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        return new UrlBuilder(PublicAPIUrlRegistry.getCommentUrl(this.session, node.getIdentifier(), comment.getIdentifier()));
    }

    @Override
    protected PagingResult<Comment> computeComment(UrlBuilder url) {
        Response resp = this.read(url, 300);
        PublicAPIResponse response = new PublicAPIResponse(resp);
        ArrayList<CommentImpl> result = new ArrayList<CommentImpl>();
        Map data = null;
        for (Object entry : response.getEntries()) {
            data = (Map)((Map)entry).get("entry");
            result.add(CommentImpl.parsePublicAPIJson(data));
        }
        return new PagingResultImpl<Comment>(result, response.getHasMoreItems(), response.getSize());
    }

    public PublicAPICommentServiceImpl(Parcel o) {
        super((AlfrescoSession)o.readParcelable(RepositorySessionImpl.class.getClassLoader()));
    }
}

