/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl.publicapi;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Map;
import org.alfresco.mobile.android.api.model.ActivityEntry;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.impl.ActivityEntryImpl;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.services.impl.AbstractActivityStreamService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.impl.RepositorySessionImpl;
import org.alfresco.mobile.android.api.utils.PublicAPIResponse;
import org.alfresco.mobile.android.api.utils.PublicAPIUrlRegistry;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

public class PublicAPIActivityStreamServiceImpl
extends AbstractActivityStreamService {
    public static final Parcelable.Creator<PublicAPIActivityStreamServiceImpl> CREATOR = new Parcelable.Creator<PublicAPIActivityStreamServiceImpl>(){

        public PublicAPIActivityStreamServiceImpl createFromParcel(Parcel in) {
            return new PublicAPIActivityStreamServiceImpl(in);
        }

        public PublicAPIActivityStreamServiceImpl[] newArray(int size) {
            return new PublicAPIActivityStreamServiceImpl[size];
        }
    };

    public PublicAPIActivityStreamServiceImpl(AlfrescoSession repositorySession) {
        super(repositorySession);
    }

    @Override
    protected UrlBuilder getUserActivitiesUrl(ListingContext listingContext) {
        String link = PublicAPIUrlRegistry.getUserActivitiesUrl(this.session);
        UrlBuilder url = new UrlBuilder(link);
        if (listingContext != null) {
            url.addParameter("maxItems", (Object)listingContext.getMaxItems());
            url.addParameter("skipCount", (Object)listingContext.getSkipCount());
        }
        return url;
    }

    @Override
    protected UrlBuilder getUserActivitiesUrl(String personIdentifier, ListingContext listingContext) {
        String link = PublicAPIUrlRegistry.getUserActivitiesUrl(this.session, personIdentifier);
        UrlBuilder url = new UrlBuilder(link);
        if (listingContext != null) {
            url.addParameter("maxItems", (Object)listingContext.getMaxItems());
            url.addParameter("skipCount", (Object)listingContext.getSkipCount());
        }
        return url;
    }

    @Override
    protected UrlBuilder getSiteActivitiesUrl(String siteIdentifier, ListingContext listingContext) {
        String link = PublicAPIUrlRegistry.getSiteActivitiesUrl(this.session, siteIdentifier);
        UrlBuilder url = new UrlBuilder(link);
        if (listingContext != null) {
            url.addParameter("maxItems", (Object)listingContext.getMaxItems());
            url.addParameter("skipCount", (Object)listingContext.getSkipCount());
        }
        return url;
    }

    @Override
    protected PagingResult<ActivityEntry> computeActivities(UrlBuilder url, ListingContext listingContext) {
        Response resp = this.read(url, 500);
        PublicAPIResponse response = new PublicAPIResponse(resp);
        ArrayList<ActivityEntryImpl> result = new ArrayList<ActivityEntryImpl>();
        Map data = null;
        for (Object entry : response.getEntries()) {
            data = (Map)((Map)entry).get("entry");
            result.add(ActivityEntryImpl.parsePublicAPIJson(data));
        }
        return new PagingResultImpl<ActivityEntry>(result, response.getHasMoreItems(), response.getSize());
    }

    public PublicAPIActivityStreamServiceImpl(Parcel o) {
        super((AlfrescoSession)o.readParcelable(RepositorySessionImpl.class.getClassLoader()));
    }
}

