/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl.onpremise;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.constants.WorkflowModel;
import org.alfresco.mobile.android.api.model.ContentStream;
import org.alfresco.mobile.android.api.model.Document;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.ListingFilter;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.Person;
import org.alfresco.mobile.android.api.model.Process;
import org.alfresco.mobile.android.api.model.ProcessDefinition;
import org.alfresco.mobile.android.api.model.Property;
import org.alfresco.mobile.android.api.model.SearchLanguage;
import org.alfresco.mobile.android.api.model.Task;
import org.alfresco.mobile.android.api.model.impl.ContentStreamImpl;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.model.impl.ProcessDefinitionImpl;
import org.alfresco.mobile.android.api.model.impl.ProcessImpl;
import org.alfresco.mobile.android.api.model.impl.TaskImpl;
import org.alfresco.mobile.android.api.services.impl.AbstractWorkflowService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.impl.RepositorySessionImpl;
import org.alfresco.mobile.android.api.utils.DateUtils;
import org.alfresco.mobile.android.api.utils.JsonDataWriter;
import org.alfresco.mobile.android.api.utils.JsonUtils;
import org.alfresco.mobile.android.api.utils.NodeRefUtils;
import org.alfresco.mobile.android.api.utils.OnPremiseUrlRegistry;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.json.JSONArray;

public class OnPremiseWorkflowServiceImpl
extends AbstractWorkflowService {
    private static final String TAG = OnPremiseWorkflowServiceImpl.class.getName();
    private static final String FORM_PREFIX = "prop_";
    private static final Map<String, String> ALFRESCO_TO_WORKFLOW = new HashMap<String, String>();
    public static final Parcelable.Creator<OnPremiseWorkflowServiceImpl> CREATOR;

    public OnPremiseWorkflowServiceImpl(AlfrescoSession repositorySession) {
        super(repositorySession);
    }

    @Override
    public PagingResult<ProcessDefinition> getProcessDefinitions(ListingContext listingContext) {
        List<ProcessDefinitionImpl> definitions = new ArrayList<ProcessDefinitionImpl>();
        Map<Object, Object> json = new HashMap(0);
        boolean hasMoreItems = false;
        int size = 0;
        try {
            String link = OnPremiseUrlRegistry.getProcessDefinitionsUrl(this.session);
            UrlBuilder url = new UrlBuilder(link);
            Response resp = this.read(url, 1100);
            json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            if (json != null) {
                List jo = (List)json.get("data");
                size = jo.size();
                for (Object obj : jo) {
                    definitions.add(ProcessDefinitionImpl.parseJson((Map)obj));
                }
                if (listingContext != null) {
                    int fromIndex;
                    int n = fromIndex = listingContext.getSkipCount() > size ? size : listingContext.getSkipCount();
                    if (listingContext.getSkipCount() < size) {
                        fromIndex = listingContext.getSkipCount();
                    }
                    if (listingContext.getMaxItems() + fromIndex >= size) {
                        definitions = definitions.subList(fromIndex, size);
                        hasMoreItems = false;
                    } else {
                        definitions = definitions.subList(fromIndex, listingContext.getMaxItems() + fromIndex);
                        hasMoreItems = true;
                    }
                }
            }
        }
        catch (Exception e) {
            OnPremiseWorkflowServiceImpl.convertException(e);
        }
        return new PagingResultImpl<ProcessDefinition>(definitions, hasMoreItems, size);
    }

    @Override
    public ProcessDefinition getProcessDefinition(String processDefinitionIdentifier) {
        ProcessDefinition definition;
        block6: {
            if (this.isStringNull(processDefinitionIdentifier)) {
                throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "processDefinitionIdentifier"));
            }
            definition = null;
            try {
                if (this.session.getRepositoryInfo().getMajorVersion() >= 4) {
                    String link = OnPremiseUrlRegistry.getProcessDefinitionUrl(this.session, processDefinitionIdentifier);
                    UrlBuilder url = new UrlBuilder(link);
                    Response resp = this.read(url, 1100);
                    Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
                    if (json != null) {
                        Map jo = (Map)json.get("data");
                        definition = ProcessDefinitionImpl.parseJson(jo);
                    }
                    break block6;
                }
                List<ProcessDefinition> definitions = this.getProcessDefinitions();
                for (ProcessDefinition processDefinition : definitions) {
                    if (!processDefinitionIdentifier.equals(processDefinition.getIdentifier())) continue;
                    definition = processDefinition;
                    break;
                }
            }
            catch (Exception e) {
                OnPremiseWorkflowServiceImpl.convertException(e);
            }
        }
        return definition;
    }

    @Override
    public Process startProcess(ProcessDefinition processDefinition, List<Person> assignees, Map<String, Serializable> variables, List<Document> items) {
        if (this.isObjectNull(processDefinition)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "processDefinition"));
        }
        Process process = null;
        try {
            String link = OnPremiseUrlRegistry.getFormProcessUrl(this.session, processDefinition.getKey());
            UrlBuilder url = new UrlBuilder(link);
            JSONObject jo = new JSONObject();
            if (assignees != null && !assignees.isEmpty()) {
                if (assignees.size() == 1 && WorkflowModel.FAMILY_PROCESS_ADHOC.contains(processDefinition.getKey()) || WorkflowModel.FAMILY_PROCESS_REVIEW.contains(processDefinition.getKey())) {
                    jo.put("assoc_bpm_assignee_added", (Object)this.getPersonGUID(assignees.get(0)));
                } else if (WorkflowModel.FAMILY_PROCESS_PARALLEL_REVIEW.contains(processDefinition.getKey())) {
                    ArrayList<String> guids = new ArrayList<String>(assignees.size());
                    for (Person person : assignees) {
                        guids.add(this.getPersonGUID(person));
                    }
                    jo.put("assoc_bpm_assignees_added", (Object)TextUtils.join((CharSequence)",", guids));
                }
            }
            if (variables != null && !variables.isEmpty()) {
                String translatedKey = null;
                for (Map.Entry<String, Serializable> entry : variables.entrySet()) {
                    translatedKey = OnPremiseWorkflowServiceImpl.encodeKey(entry.getKey());
                    if (ALFRESCO_TO_WORKFLOW.containsKey(translatedKey)) {
                        jo.put(ALFRESCO_TO_WORKFLOW.get(translatedKey), (Object)entry.getValue());
                        continue;
                    }
                    jo.put(translatedKey, (Object)entry.getValue());
                }
            }
            if (items != null && !items.isEmpty()) {
                ArrayList<String> variablesItems = new ArrayList<String>(items.size());
                for (Node node : items) {
                    variablesItems.add(NodeRefUtils.getCleanIdentifier(node.getIdentifier()));
                }
                jo.put("assoc_packageItems_added", (Object)TextUtils.join((CharSequence)",", (Object[])variablesItems.toArray(new String[0])));
            }
            final JsonDataWriter dataWriter = new JsonDataWriter(jo);
            Response resp = this.post(url, dataWriter.getContentType(), new Output(){

                public void write(OutputStream out) throws IOException {
                    dataWriter.write(out);
                }
            }, 1100);
            Map<String, Object> map = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            String data = JSONConverter.getString(map, (String)"persistedObject");
            String processId = data.split("\\[")[1].split(",")[0].split("=")[1];
            process = this.getProcess(processId);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            OnPremiseWorkflowServiceImpl.convertException(e);
        }
        return process;
    }

    @Override
    protected UrlBuilder getProcessUrl(Process process) {
        return new UrlBuilder(OnPremiseUrlRegistry.getProcessUrl(this.session, process.getIdentifier()));
    }

    @Override
    public PagingResult<Process> getProcesses(ListingContext listingContext) {
        ArrayList<Process> processes = new ArrayList<Process>();
        Map<Object, Object> json = new HashMap(0);
        int maxItems = -1;
        boolean hasMoreItem = false;
        try {
            String link = OnPremiseUrlRegistry.getProcessesUrl(this.session);
            UrlBuilder url = new UrlBuilder(link);
            if (listingContext != null) {
                if (listingContext.getFilter() != null) {
                    ListingFilter lf = listingContext.getFilter();
                    if (lf.hasFilterValue("filterInitiator")) {
                        if (lf.getFilterValue("filterInitiator") instanceof String) {
                            url.addParameter("initiator", (Object)lf.getFilterValue("filterInitiator"));
                        } else if (lf.getFilterValue("filterAssignee") instanceof Integer) {
                            switch ((Integer)lf.getFilterValue("filterInitiator")) {
                                case 1: {
                                    url.addParameter("initiator", (Object)this.session.getPersonIdentifier());
                                    break;
                                }
                                case 3: {
                                    break;
                                }
                                default: {
                                    break;
                                }
                            }
                        }
                    } else {
                        url.addParameter("initiator", (Object)this.session.getPersonIdentifier());
                    }
                    if (lf.hasFilterValue("filterPriority")) {
                        url.addParameter("priority", (Object)lf.getFilterValue("filterPriority"));
                    }
                    if (lf.hasFilterValue("filterStatus")) {
                        switch ((Integer)lf.getFilterValue("filterStatus")) {
                            case 2: {
                                url.addParameter("state", (Object)"COMPLETED");
                                break;
                            }
                            case 1: {
                                url.addParameter("state", (Object)"ACTIVE");
                                break;
                            }
                        }
                    }
                    if (lf.hasFilterValue("filterDue")) {
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.set(10, 11);
                        calendar.set(12, 59);
                        calendar.set(13, 59);
                        calendar.set(14, 999);
                        switch ((Integer)lf.getFilterValue("filterDue")) {
                            case 0: {
                                url.addParameter("dueBefore", (Object)DateUtils.format(calendar));
                                calendar.add(5, -1);
                                url.addParameter("dueAfter", (Object)DateUtils.format(calendar));
                                break;
                            }
                            case 1: {
                                url.addParameter("dueAfter", (Object)DateUtils.format(calendar));
                                calendar.add(5, 1);
                                url.addParameter("dueBefore", (Object)DateUtils.format(calendar));
                                break;
                            }
                            case 7: {
                                url.addParameter("dueAfter", (Object)DateUtils.format(calendar));
                                calendar.add(5, 7);
                                url.addParameter("dueBefore", (Object)DateUtils.format(calendar));
                                break;
                            }
                            case 100: {
                                calendar.add(5, -1);
                                url.addParameter("dueBefore", (Object)DateUtils.format(calendar));
                                break;
                            }
                            case -1: {
                                url.addParameter("dueBefore", (Object)"");
                                break;
                            }
                        }
                    }
                }
                url.addParameter("maxItems", (Object)listingContext.getMaxItems());
                maxItems = listingContext.getMaxItems();
                url.addParameter("skipCount", (Object)listingContext.getSkipCount());
            } else {
                url.addParameter("state", (Object)"IN_PROGRESS");
            }
            Response resp = this.read(url, 1100);
            json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            if (json != null) {
                List jo = (List)json.get("data");
                for (Object obj : jo) {
                    processes.add(ProcessImpl.parseJson((Map)obj));
                }
                hasMoreItem = maxItems == -1 ? false : jo.size() == maxItems;
            }
        }
        catch (Exception e) {
            OnPremiseWorkflowServiceImpl.convertException(e);
        }
        return new PagingResultImpl<Process>(processes, hasMoreItem, json.size());
    }

    @Override
    public Process getProcess(String processId) {
        if (this.isStringNull(processId)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "processId"));
        }
        Process process = null;
        try {
            String link = OnPremiseUrlRegistry.getProcessUrl(this.session, processId);
            UrlBuilder url = new UrlBuilder(link);
            Response resp = this.read(url, 1100);
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            if (json != null) {
                Map jo = (Map)json.get("data");
                process = ProcessImpl.parseJson(jo);
            }
        }
        catch (Exception e) {
            OnPremiseWorkflowServiceImpl.convertException(e);
        }
        return process;
    }

    @Override
    public PagingResult<Task> getTasks(Process process, ListingContext listingContext) {
        ListingFilter lf;
        if (this.isObjectNull(process)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "process"));
        }
        String link = OnPremiseUrlRegistry.getTasksForProcessIdUrl(this.session, process.getIdentifier());
        if (listingContext != null && listingContext.getFilter() != null && (lf = listingContext.getFilter()).hasFilterValue("filterStatus") && (Integer)lf.getFilterValue("filterStatus") == 0) {
            link = OnPremiseUrlRegistry.getAllTasksForProcessIdUrl(this.session, process.getIdentifier());
        }
        return this.getTasks(link, listingContext);
    }

    @Override
    public Process refresh(Process process) {
        if (this.isObjectNull(process)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "process"));
        }
        return this.getProcess(process.getIdentifier());
    }

    @Override
    public Map<String, Property> getVariables(Process process) {
        try {
            return this.refresh(process).getVariables();
        }
        catch (Exception e) {
            return new HashMap<String, Property>(0);
        }
    }

    @Override
    public PagingResult<Document> getDocuments(Task task, ListingContext listingContext) {
        if (this.isObjectNull(task)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "task"));
        }
        if (this.isStringNull(task.getIdentifier())) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "taskId"));
        }
        return this.getItems(task.getIdentifier(), listingContext);
    }

    @Override
    public PagingResult<Document> getDocuments(Process process, ListingContext listingContext) {
        if (this.isObjectNull(process)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "process"));
        }
        if (this.isStringNull(process.getIdentifier())) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "processId"));
        }
        try {
            ListingContext lc = new ListingContext();
            lc.setMaxItems(1);
            PagingResult<Task> tasks = this.getTasks(process, lc);
            if (tasks.getTotalItems() > 0) {
                return this.getItems(tasks.getList().get(0).getIdentifier(), listingContext);
            }
        }
        catch (Exception e) {
            OnPremiseWorkflowServiceImpl.convertException(e);
        }
        return this.getItems(process.getIdentifier(), listingContext);
    }

    protected PagingResult<Document> getItems(String id, ListingContext listingContext) {
        ArrayList<Document> nodes = new ArrayList<Document>();
        try {
            String link = OnPremiseUrlRegistry.getProcessItemsUrl(this.session, id);
            UrlBuilder url = new UrlBuilder(link);
            JSONObject jo = new JSONObject();
            jo.put("itemKind", (Object)"task");
            jo.put("itemId", (Object)id);
            ArrayList<String> fields = new ArrayList<String>();
            fields.add("packageItems");
            jo.put("fields", (Object)new JSONArray(fields));
            final JsonDataWriter dataWriter = new JsonDataWriter(jo);
            Response resp = this.post(url, dataWriter.getContentType(), new Output(){

                public void write(OutputStream out) throws IOException {
                    dataWriter.write(out);
                }
            }, 1100);
            Map formData = null;
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            if (json != null) {
                Map data = (Map)json.get("data");
                formData = (Map)data.get("formData");
            }
            if (formData != null && formData.containsKey("assoc_packageItems") && !((String)formData.get("assoc_packageItems")).isEmpty()) {
                Object[] values = ((String)formData.get("assoc_packageItems")).split(",");
                StringBuilder builder = new StringBuilder("SELECT * FROM cmis:document WHERE cmis:objectId=");
                JsonUtils.join(builder, " OR cmis:objectId=", values);
                List<Node> nodesN = this.session.getServiceRegistry().getSearchService().search(builder.toString(), SearchLanguage.CMIS);
                for (Node node : nodesN) {
                    nodes.add((Document)node);
                }
            }
        }
        catch (Exception e) {
            OnPremiseWorkflowServiceImpl.convertException(e);
        }
        return new PagingResultImpl<Document>(nodes, false, nodes.size());
    }

    @Override
    public void addDocuments(Task task, List<Document> items) {
        this.updateDocuments(task, items, true);
    }

    @Override
    public void removeDocuments(Task task, List<Document> items) {
        this.updateDocuments(task, items, false);
    }

    private void updateDocuments(Task task, List<Document> items, boolean isAddition) {
        try {
            String variableKey = "assoc_packageItems_removed";
            if (isAddition) {
                variableKey = "assoc_packageItems_added";
            }
            ArrayList<String> variablesItems = new ArrayList<String>(items.size());
            for (Node node : items) {
                variablesItems.add(NodeRefUtils.getCleanIdentifier(node.getIdentifier()));
            }
            HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
            variables.put(variableKey, (Serializable)((Object)TextUtils.join((CharSequence)",", (Object[])variablesItems.toArray(new String[0]))));
            this.updateVariables(task, variables);
        }
        catch (Exception e) {
            OnPremiseWorkflowServiceImpl.convertException(e);
        }
    }

    private PagingResult<Task> getTasks(String link, ListingContext listingContext) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        Map<Object, Object> json = new HashMap(0);
        int maxItems = -1;
        int size = 0;
        boolean hasMoreItem = false;
        try {
            UrlBuilder url = new UrlBuilder(link);
            if (listingContext != null) {
                if (listingContext.getFilter() != null) {
                    ListingFilter lf = listingContext.getFilter();
                    if (lf.hasFilterValue("filterAssignee")) {
                        if (lf.getFilterValue("filterAssignee") instanceof String) {
                            url.addParameter("authority", (Object)lf.getFilterValue("filterAssignee"));
                        } else if (lf.getFilterValue("filterAssignee") instanceof Integer) {
                            switch ((Integer)lf.getFilterValue("filterAssignee")) {
                                case 2: {
                                    url.addParameter("authority", (Object)this.session.getPersonIdentifier());
                                    url.addParameter("pooledTasks", (Object)true);
                                    break;
                                }
                                case 1: {
                                    url.addParameter("authority", (Object)this.session.getPersonIdentifier());
                                    url.addParameter("pooledTasks", (Object)false);
                                    break;
                                }
                                case 3: {
                                    url.addParameter("authority", (Object)this.session.getPersonIdentifier());
                                    break;
                                }
                                case 4: {
                                    break;
                                }
                                default: {
                                    break;
                                }
                            }
                        }
                    } else {
                        url.addParameter("authority", (Object)this.session.getPersonIdentifier());
                    }
                    if (lf.hasFilterValue("filterPriority")) {
                        url.addParameter("priority", (Object)lf.getFilterValue("filterPriority"));
                    }
                    if (lf.hasFilterValue("filterStatus")) {
                        switch ((Integer)lf.getFilterValue("filterStatus")) {
                            case 2: {
                                url.addParameter("state", (Object)"COMPLETED");
                                break;
                            }
                            case 1: {
                                url.addParameter("state", (Object)"IN_PROGRESS");
                                break;
                            }
                            case 0: {
                                url.addParameter("includeTasks", (Object)"true");
                                break;
                            }
                        }
                    }
                    if (lf.hasFilterValue("filterDue")) {
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.set(11, 23);
                        calendar.set(12, 59);
                        calendar.set(13, 59);
                        calendar.set(14, 999);
                        switch ((Integer)lf.getFilterValue("filterDue")) {
                            case 0: {
                                url.addParameter("dueBefore", (Object)DateUtils.format(calendar));
                                calendar.add(5, -1);
                                url.addParameter("dueAfter", (Object)DateUtils.format(calendar));
                                break;
                            }
                            case 1: {
                                url.addParameter("dueAfter", (Object)DateUtils.format(calendar));
                                calendar.add(5, 1);
                                url.addParameter("dueBefore", (Object)DateUtils.format(calendar));
                                break;
                            }
                            case 7: {
                                url.addParameter("dueAfter", (Object)DateUtils.format(calendar));
                                calendar.add(5, 7);
                                url.addParameter("dueBefore", (Object)DateUtils.format(calendar));
                                break;
                            }
                            case 100: {
                                calendar.add(5, -1);
                                url.addParameter("dueBefore", (Object)DateUtils.format(calendar));
                                break;
                            }
                            case -1: {
                                url.addParameter("dueBefore", (Object)"");
                                break;
                            }
                        }
                    }
                }
                url.addParameter("maxItems", (Object)listingContext.getMaxItems());
                maxItems = listingContext.getMaxItems();
                url.addParameter("skipCount", (Object)listingContext.getSkipCount());
            } else {
                url.addParameter("state", (Object)"IN_PROGRESS");
            }
            Log.d((String)TAG, (String)url.toString());
            Response resp = this.read(url, 1100);
            json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            if (json != null) {
                List jo = null;
                if (json.get("data") instanceof List) {
                    jo = (List)json.get("data");
                } else if (json.get("data") instanceof Map) {
                    Map jso = (Map)json.get("data");
                    jo = (List)jso.get("tasks");
                }
                size = jo.size();
                for (Object obj : jo) {
                    tasks.add(TaskImpl.parseJson((Map)obj));
                }
                hasMoreItem = maxItems == -1 ? false : size == maxItems;
            }
        }
        catch (Exception e) {
            OnPremiseWorkflowServiceImpl.convertException(e);
        }
        return new PagingResultImpl<Task>(tasks, hasMoreItem, size);
    }

    @Override
    public Task getTask(String taskIdentifier) {
        if (this.isStringNull(taskIdentifier)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "taskIdentifier"));
        }
        Task task = null;
        try {
            String link = OnPremiseUrlRegistry.getTaskUrl(this.session, taskIdentifier);
            UrlBuilder url = new UrlBuilder(link);
            Response resp = this.read(url, 1100);
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            if (json != null) {
                Map jo = (Map)json.get("data");
                task = TaskImpl.parseJson(jo);
            }
        }
        catch (Exception e) {
            OnPremiseWorkflowServiceImpl.convertException(e);
        }
        return task;
    }

    @Override
    public PagingResult<Task> getTasks(ListingContext listingContext) {
        return this.getTasks(OnPremiseUrlRegistry.getTasksUrl(this.session), listingContext);
    }

    @Override
    public Task completeTask(Task task, Map<String, Serializable> variables) {
        if (this.isObjectNull(task)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "task"));
        }
        HashMap<String, Object> internalVariables = new HashMap<String, Object>();
        if (variables != null) {
            internalVariables.putAll(variables);
        }
        Task resultTask = task;
        try {
            String link = OnPremiseUrlRegistry.getFormTaskUrl(this.session, task.getIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            JSONObject jo = new JSONObject();
            if (!internalVariables.containsKey("prop_transitions")) {
                String transitionIdentifier = "";
                if (task.getIdentifier().startsWith("activiti$")) {
                    transitionIdentifier = "Next";
                }
                internalVariables.put("prop_transitions", transitionIdentifier);
            }
            if (internalVariables != null && !internalVariables.isEmpty()) {
                String translatedKey = null;
                for (Map.Entry entry : internalVariables.entrySet()) {
                    translatedKey = OnPremiseWorkflowServiceImpl.encodeKey((String)entry.getKey());
                    if (!ALFRESCO_TO_WORKFLOW.containsKey(translatedKey)) continue;
                    jo.put(ALFRESCO_TO_WORKFLOW.get(translatedKey), entry.getValue());
                }
            }
            final JsonDataWriter dataWriter = new JsonDataWriter(jo);
            Response resp = this.post(url, dataWriter.getContentType(), new Output(){

                public void write(OutputStream out) throws IOException {
                    dataWriter.write(out);
                }
            }, 1100);
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            String data = JSONConverter.getString(json, (String)"persistedObject");
            String taskId = data.split("\\[")[1].split(",")[0].split("=")[1];
            resultTask = this.getTask(taskId);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            OnPremiseWorkflowServiceImpl.convertException(e);
        }
        return resultTask;
    }

    @Override
    public Task refresh(Task task) {
        if (this.isObjectNull(task)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "task"));
        }
        return this.getTask(task.getIdentifier());
    }

    @Override
    public Task claimTask(Task task) {
        if (this.isObjectNull(task)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "task"));
        }
        try {
            return this.changeAssignee(task.getIdentifier(), this.session.getPersonIdentifier());
        }
        catch (Exception e) {
            OnPremiseWorkflowServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public Task unclaimTask(Task task) {
        if (this.isObjectNull(task)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "task"));
        }
        try {
            return this.changeAssignee(task.getIdentifier(), null);
        }
        catch (Exception e) {
            OnPremiseWorkflowServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public Task reassignTask(Task task, Person assignee) {
        if (this.isObjectNull(task)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "task"));
        }
        if (this.isObjectNull(assignee)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "assignee"));
        }
        return this.changeAssignee(task.getIdentifier(), assignee.getIdentifier());
    }

    private Task changeAssignee(String taskId, String assigneeId) {
        Task updatedTask = null;
        try {
            String link = OnPremiseUrlRegistry.getTaskUrl(this.session, taskId);
            UrlBuilder url = new UrlBuilder(link);
            JSONObject jobject = new JSONObject();
            jobject.put(OnPremiseWorkflowServiceImpl.encodeKey(WorkflowModel.PROP_OWNER), (Object)assigneeId);
            final JsonDataWriter dataWriter = new JsonDataWriter(jobject);
            Response resp = this.put(url, dataWriter.getContentType(), null, new Output(){

                public void write(OutputStream out) throws IOException {
                    dataWriter.write(out);
                }
            }, 1100);
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            if (json != null) {
                Map jo = (Map)json.get("data");
                updatedTask = TaskImpl.parseJson(jo);
            }
        }
        catch (Exception e) {
            OnPremiseWorkflowServiceImpl.convertException(e);
        }
        return updatedTask;
    }

    @Override
    public Map<String, Property> getVariables(Task task) {
        try {
            return this.refresh(task).getVariables();
        }
        catch (Exception e) {
            return new HashMap<String, Property>(0);
        }
    }

    @Override
    public Process updateVariables(Process process, Map<String, Serializable> variables) {
        throw new UnsupportedOperationException(Messagesl18n.getString("ErrorCodeRegistry.WORKFLOW_UPDATE_UNSUPPORTED"));
    }

    @Override
    public Task updateVariables(Task task, Map<String, Serializable> variables) {
        if (this.isObjectNull(task)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "task"));
        }
        HashMap<String, Serializable> internalVariables = new HashMap<String, Serializable>();
        if (variables != null) {
            internalVariables.putAll(variables);
        }
        Task resultTask = task;
        try {
            String link = OnPremiseUrlRegistry.getFormTaskUrl(this.session, task.getIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            JSONObject jo = new JSONObject();
            if (internalVariables != null && !internalVariables.isEmpty()) {
                String translatedKey = null;
                for (Map.Entry entry : internalVariables.entrySet()) {
                    translatedKey = OnPremiseWorkflowServiceImpl.encodeKey((String)entry.getKey());
                    if (ALFRESCO_TO_WORKFLOW.containsKey(translatedKey)) {
                        jo.put(ALFRESCO_TO_WORKFLOW.get(translatedKey), entry.getValue());
                        continue;
                    }
                    jo.put(translatedKey, entry.getValue());
                }
            }
            final JsonDataWriter dataWriter = new JsonDataWriter(jo);
            Response resp = this.post(url, dataWriter.getContentType(), new Output(){

                public void write(OutputStream out) throws IOException {
                    dataWriter.write(out);
                }
            }, 1100);
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            String data = JSONConverter.getString(json, (String)"persistedObject");
            String taskId = data.split("\\[")[1].split(",")[0].split("=")[1];
            resultTask = this.getTask(taskId);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            OnPremiseWorkflowServiceImpl.convertException(e);
        }
        return resultTask;
    }

    @Override
    public UrlBuilder getProcessDiagramUrl(String processId) {
        String url = OnPremiseUrlRegistry.getWorkflowDiagram(this.session, processId);
        return new UrlBuilder(url);
    }

    @Override
    public ContentStream getProcessDiagram(Process process) {
        if (this.isObjectNull(process)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "process"));
        }
        return this.getProcessDiagram(process.getIdentifier());
    }

    @Override
    public ContentStream getProcessDiagram(String processId) {
        if (this.isStringNull(processId)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "processId"));
        }
        try {
            ContentStreamImpl cf = null;
            String url = OnPremiseUrlRegistry.getWorkflowDiagram(this.session, processId);
            UrlBuilder builder = new UrlBuilder(url);
            Response resp = this.read(builder, 1100);
            cf = new ContentStreamImpl(resp.getStream(), resp.getContentTypeHeader(), resp.getContentLength().longValue());
            return cf;
        }
        catch (Exception e) {
            OnPremiseWorkflowServiceImpl.convertException(e);
            return null;
        }
    }

    private String getPersonGUID(Person person) {
        if (this.isObjectNull(person)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "person"));
        }
        String guid = null;
        try {
            Map data;
            List jo;
            String url = OnPremiseUrlRegistry.getPersonGUIDUrl(this.session, person.getIdentifier());
            UrlBuilder builder = new UrlBuilder(url);
            Response resp = this.read(builder, 1100);
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            if (json != null && (jo = (List)(data = (Map)json.get("data")).get("items")) != null && jo.size() == 1) {
                guid = JSONConverter.getString((Map)((Map)jo.get(0)), (String)"nodeRef");
            }
        }
        catch (Exception e) {
            OnPremiseWorkflowServiceImpl.convertException(e);
        }
        return guid;
    }

    public OnPremiseWorkflowServiceImpl(Parcel o) {
        super((AlfrescoSession)o.readParcelable(RepositorySessionImpl.class.getClassLoader()));
    }

    static {
        ALFRESCO_TO_WORKFLOW.put(OnPremiseWorkflowServiceImpl.encodeKey(WorkflowModel.PROP_WORKFLOW_DESCRIPTION), FORM_PREFIX.concat(OnPremiseWorkflowServiceImpl.encodeKey(WorkflowModel.PROP_WORKFLOW_DESCRIPTION)));
        ALFRESCO_TO_WORKFLOW.put(OnPremiseWorkflowServiceImpl.encodeKey(WorkflowModel.PROP_WORKFLOW_DUE_DATE), FORM_PREFIX.concat(OnPremiseWorkflowServiceImpl.encodeKey(WorkflowModel.PROP_WORKFLOW_DUE_DATE)));
        ALFRESCO_TO_WORKFLOW.put(OnPremiseWorkflowServiceImpl.encodeKey(WorkflowModel.PROP_WORKFLOW_PRIORITY), FORM_PREFIX.concat(OnPremiseWorkflowServiceImpl.encodeKey(WorkflowModel.PROP_WORKFLOW_PRIORITY)));
        ALFRESCO_TO_WORKFLOW.put(OnPremiseWorkflowServiceImpl.encodeKey(WorkflowModel.PROP_SEND_EMAIL_NOTIFICATIONS), FORM_PREFIX.concat(OnPremiseWorkflowServiceImpl.encodeKey(WorkflowModel.PROP_SEND_EMAIL_NOTIFICATIONS)));
        ALFRESCO_TO_WORKFLOW.put(OnPremiseWorkflowServiceImpl.encodeKey(WorkflowModel.PROP_COMMENT), FORM_PREFIX.concat(OnPremiseWorkflowServiceImpl.encodeKey(WorkflowModel.PROP_COMMENT)));
        ALFRESCO_TO_WORKFLOW.put(OnPremiseWorkflowServiceImpl.encodeKey(WorkflowModel.PROP_STATUS), FORM_PREFIX.concat(OnPremiseWorkflowServiceImpl.encodeKey(WorkflowModel.PROP_STATUS)));
        ALFRESCO_TO_WORKFLOW.put(OnPremiseWorkflowServiceImpl.encodeKey(WorkflowModel.PROP_REVIEW_OUTCOME), FORM_PREFIX.concat(OnPremiseWorkflowServiceImpl.encodeKey(WorkflowModel.PROP_REVIEW_OUTCOME)));
        ALFRESCO_TO_WORKFLOW.put(OnPremiseWorkflowServiceImpl.encodeKey("prop_transitions"), OnPremiseWorkflowServiceImpl.encodeKey("prop_transitions"));
        ALFRESCO_TO_WORKFLOW.put(OnPremiseWorkflowServiceImpl.encodeKey(WorkflowModel.PROP_REQUIRED_APPROVE_PERCENT), FORM_PREFIX.concat(OnPremiseWorkflowServiceImpl.encodeKey(WorkflowModel.PROP_REQUIRED_APPROVE_PERCENT)));
        CREATOR = new Parcelable.Creator<OnPremiseWorkflowServiceImpl>(){

            public OnPremiseWorkflowServiceImpl createFromParcel(Parcel in) {
                return new OnPremiseWorkflowServiceImpl(in);
            }

            public OnPremiseWorkflowServiceImpl[] newArray(int size) {
                return new OnPremiseWorkflowServiceImpl[size];
            }
        };
    }
}

