/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl.onpremise;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.mobile.android.api.exceptions.AlfrescoServiceException;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.Tag;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.model.impl.TagImpl;
import org.alfresco.mobile.android.api.services.TaggingService;
import org.alfresco.mobile.android.api.services.impl.AlfrescoService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.RepositorySession;
import org.alfresco.mobile.android.api.session.impl.RepositorySessionImpl;
import org.alfresco.mobile.android.api.utils.JsonDataWriter;
import org.alfresco.mobile.android.api.utils.JsonUtils;
import org.alfresco.mobile.android.api.utils.OnPremiseUrlRegistry;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.json.JSONArray;
import org.json.JSONException;

public class OnPremiseTaggingServiceImpl
extends AlfrescoService
implements TaggingService {
    public static final Parcelable.Creator<OnPremiseTaggingServiceImpl> CREATOR = new Parcelable.Creator<OnPremiseTaggingServiceImpl>(){

        public OnPremiseTaggingServiceImpl createFromParcel(Parcel in) {
            return new OnPremiseTaggingServiceImpl(in);
        }

        public OnPremiseTaggingServiceImpl[] newArray(int size) {
            return new OnPremiseTaggingServiceImpl[size];
        }
    };

    public OnPremiseTaggingServiceImpl(RepositorySession repositorySession) {
        super(repositorySession);
    }

    @Override
    public List<Tag> getAllTags() {
        return this.getAllTags(null).getList();
    }

    @Override
    public PagingResult<Tag> getAllTags(ListingContext listingContext) {
        try {
            String link = OnPremiseUrlRegistry.getTagsUrl(this.session);
            UrlBuilder url = new UrlBuilder(link);
            return this.computeTag(url, listingContext);
        }
        catch (Exception e) {
            OnPremiseTaggingServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public List<Tag> getTags(Node node) {
        return this.getTags(node, null).getList();
    }

    @Override
    public PagingResult<Tag> getTags(Node node, ListingContext listingContext) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        try {
            String link = OnPremiseUrlRegistry.getTagsUrl(this.session, node.getIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            return this.computeSimpleTag(url, listingContext);
        }
        catch (AlfrescoServiceException e) {
            if (e.getAlfrescoErrorContent() != null && e.getAlfrescoErrorContent().getMessage() != null && e.getAlfrescoErrorContent().getMessage().contains("Access Denied")) {
                ArrayList result = new ArrayList();
                return new PagingResultImpl<Tag>(result, false, -1);
            }
            throw e;
        }
        catch (Exception e) {
            OnPremiseTaggingServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public void addTags(Node node, List<String> tags) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        if (this.isListNull(tags)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "tags"));
        }
        try {
            String link = OnPremiseUrlRegistry.getTagsUrl(this.session, node.getIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            JSONArray jo = new JSONArray();
            for (String tag : tags) {
                jo.put((Object)tag);
            }
            final JsonDataWriter formData = new JsonDataWriter(jo);
            this.post(url, formData.getContentType(), new Output(){

                public void write(OutputStream out) throws IOException {
                    formData.write(out);
                }
            }, 700);
        }
        catch (Exception e) {
            OnPremiseTaggingServiceImpl.convertException(e);
        }
    }

    private PagingResult<Tag> computeTag(UrlBuilder url, ListingContext listingContext) throws JSONException {
        Response resp = this.read(url, 700);
        String resultsString = JsonUtils.convertStreamToString(resp.getStream());
        ArrayList<TagImpl> tags = new ArrayList<TagImpl>();
        JSONArray results = new JSONArray(resultsString);
        int fromIndex = 0;
        int toIndex = results.length();
        Boolean hasMoreItems = false;
        if (listingContext != null) {
            int n = fromIndex = listingContext.getSkipCount() > results.length() ? results.length() : listingContext.getSkipCount();
            if (listingContext.getMaxItems() + fromIndex >= results.length()) {
                toIndex = results.length();
                hasMoreItems = false;
            } else {
                toIndex = listingContext.getMaxItems() + fromIndex;
                hasMoreItems = true;
            }
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            tags.add(new TagImpl(results.getString(i)));
        }
        return new PagingResultImpl<Tag>(tags, hasMoreItems, results.length());
    }

    private PagingResult<Tag> computeSimpleTag(UrlBuilder url, ListingContext listingContext) {
        Response resp = this.read(url, 700);
        String resultsString = JsonUtils.convertStreamToString(resp.getStream());
        ArrayList<TagImpl> tags = new ArrayList<TagImpl>();
        String tag = null;
        String[] results = resultsString.replace("[", "").replace("]", "").replaceAll("\t", "").trim().split("\n");
        int fromIndex = 0;
        int toIndex = results.length;
        int totalItems = results.length;
        Boolean hasMoreItems = false;
        if (listingContext != null) {
            int n = fromIndex = listingContext.getSkipCount() > results.length ? results.length : listingContext.getSkipCount();
            if (listingContext.getMaxItems() + fromIndex >= results.length) {
                toIndex = results.length;
                hasMoreItems = false;
            } else {
                toIndex = listingContext.getMaxItems() + fromIndex;
                hasMoreItems = true;
            }
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            if (results[i].length() == 0) {
                if (toIndex + 1 < results.length) {
                    ++toIndex;
                }
                --totalItems;
                continue;
            }
            if (i == results.length - 1) {
                tag = results[i];
                tags.add(new TagImpl(tag));
                continue;
            }
            tag = results[i].substring(0, results[i].lastIndexOf(","));
            tags.add(new TagImpl(tag));
        }
        return new PagingResultImpl<Tag>(tags, hasMoreItems, totalItems);
    }

    public OnPremiseTaggingServiceImpl(Parcel o) {
        super((AlfrescoSession)o.readParcelable(RepositorySessionImpl.class.getClassLoader()));
    }
}

