/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl.onpremise;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.exceptions.AlfrescoServiceException;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.Person;
import org.alfresco.mobile.android.api.model.Site;
import org.alfresco.mobile.android.api.model.SiteVisibility;
import org.alfresco.mobile.android.api.model.impl.JoinSiteRequestImpl;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.model.impl.PersonImpl;
import org.alfresco.mobile.android.api.model.impl.SiteImpl;
import org.alfresco.mobile.android.api.services.cache.impl.CacheSiteExtraProperties;
import org.alfresco.mobile.android.api.services.impl.AbstractSiteServiceImpl;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.RepositorySession;
import org.alfresco.mobile.android.api.session.impl.RepositorySessionImpl;
import org.alfresco.mobile.android.api.utils.AlphaComparator;
import org.alfresco.mobile.android.api.utils.JsonDataWriter;
import org.alfresco.mobile.android.api.utils.JsonUtils;
import org.alfresco.mobile.android.api.utils.OnPremiseUrlRegistry;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;

public class OnPremiseSiteServiceImpl
extends AbstractSiteServiceImpl {
    private static final String TAG = "OnPremiseSiteServiceImpl";
    public static final Parcelable.Creator<OnPremiseSiteServiceImpl> CREATOR = new Parcelable.Creator<OnPremiseSiteServiceImpl>(){

        public OnPremiseSiteServiceImpl createFromParcel(Parcel in) {
            return new OnPremiseSiteServiceImpl(in);
        }

        public OnPremiseSiteServiceImpl[] newArray(int size) {
            return new OnPremiseSiteServiceImpl[size];
        }
    };

    public OnPremiseSiteServiceImpl(RepositorySession repositorySession) {
        super(repositorySession);
    }

    @Override
    protected UrlBuilder getAllSitesUrl(ListingContext listingContext) {
        String link = OnPremiseUrlRegistry.getAllSitesUrl(this.session);
        return new UrlBuilder(link);
    }

    @Override
    protected UrlBuilder getUserSitesUrl(String personIdentifier, ListingContext listingContext) {
        String link = OnPremiseUrlRegistry.getUserSitesUrl(this.session, this.session.getPersonIdentifier());
        return new UrlBuilder(link);
    }

    @Override
    public List<Site> getFavoriteSites() {
        try {
            List<Site> sites = this.getSites();
            List<String> favoriteSites = this.computeFavoriteSite(this.session.getPersonIdentifier());
            ArrayList<Site> finalList = new ArrayList<Site>();
            if (favoriteSites == null) {
                return finalList;
            }
            for (Site site : sites) {
                if (!favoriteSites.contains(site.getShortName())) continue;
                finalList.add(site);
                favoriteSites.remove(site.getShortName());
            }
            Site tmpSite = null;
            for (String siteIdentifier : favoriteSites) {
                tmpSite = this.getSite(siteIdentifier);
                if (tmpSite == null) continue;
                finalList.add(tmpSite);
            }
            return finalList;
        }
        catch (Exception e) {
            OnPremiseSiteServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    protected PagingResult<Site> computeFavoriteSites(ListingContext listingContext) {
        List<Site> result = this.getFavoriteSites();
        if (listingContext != null) {
            Collections.sort(result, new AlphaComparator(listingContext.isSortAscending(), listingContext.getSortProperty()));
        }
        Boolean hasMoreItems = false;
        if (listingContext != null) {
            int fromIndex;
            int n = fromIndex = listingContext.getSkipCount() > result.size() ? result.size() : listingContext.getSkipCount();
            if (listingContext.getSkipCount() < result.size()) {
                fromIndex = listingContext.getSkipCount();
            }
            if (listingContext.getMaxItems() + fromIndex >= result.size()) {
                result = result.subList(fromIndex, result.size());
                hasMoreItems = false;
            } else {
                result = result.subList(fromIndex, listingContext.getMaxItems() + fromIndex);
                hasMoreItems = true;
            }
        }
        return new PagingResultImpl<Site>(result, hasMoreItems, result.size());
    }

    @Override
    protected UrlBuilder getSiteUrl(String siteIdentifier) {
        String link = OnPremiseUrlRegistry.getSiteUrl(this.session, siteIdentifier);
        return new UrlBuilder(link);
    }

    @Override
    protected Site parseData(String siteIdentifier, Map<String, Object> json) {
        if (this.extraPropertiesCache.get((Object)siteIdentifier) != null) {
            CacheSiteExtraProperties extraProperties = (CacheSiteExtraProperties)this.extraPropertiesCache.get((Object)siteIdentifier);
            json.put("isPendingMember", extraProperties.isPendingMember);
            json.put("isMember", extraProperties.isMember);
            json.put("isFavorite", extraProperties.isFavorite);
        }
        return SiteImpl.parseJson(json);
    }

    @Override
    protected String getDocContainerSiteUrl(Site site) {
        return OnPremiseUrlRegistry.getDocContainerSiteUrl(this.session, site.getShortName());
    }

    private Site favoriteSite(Site site, boolean addSite) {
        if (this.isObjectNull(site)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "site"));
        }
        SiteImpl updatedSite = null;
        try {
            String link = OnPremiseUrlRegistry.getUserPreferenceUrl(this.session, this.session.getPersonIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            String[] sitePrefence = new String[]{"org", "alfresco", "share", "sites", "favourites"};
            JSONObject jroot = new JSONObject();
            JSONObject jt = null;
            JSONObject jp = jroot;
            for (int i = 0; i < sitePrefence.length; ++i) {
                jt = new JSONObject();
                jp.put(sitePrefence[i], (Object)jt);
                jp = jt;
            }
            jt.put(site.getIdentifier(), (Object)addSite);
            final JsonDataWriter formDataM = new JsonDataWriter(jroot);
            this.post(url, formDataM.getContentType(), new Output(){

                public void write(OutputStream out) throws IOException {
                    formDataM.write(out);
                }
            }, 400);
            this.updateExtraPropertyCache(site.getIdentifier(), site.isPendingMember(), site.isMember(), addSite);
            updatedSite = new SiteImpl(site, site.isPendingMember(), site.isMember(), addSite);
            this.validateUpdateSite(updatedSite, 400);
        }
        catch (Exception e) {
            OnPremiseSiteServiceImpl.convertException(e);
        }
        return updatedSite;
    }

    @Override
    public Site addFavoriteSite(Site site) {
        return this.favoriteSite(site, true);
    }

    @Override
    public Site removeFavoriteSite(Site site) {
        return this.favoriteSite(site, false);
    }

    @Override
    public boolean isMember(Site site, Person person) {
        if (this.isObjectNull(site)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "site"));
        }
        if (this.isObjectNull(person)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "person"));
        }
        return this.isMemberOf(site, person.getIdentifier());
    }

    private boolean isMemberOf(Site site, String personId) {
        boolean isMember = false;
        try {
            String link = OnPremiseUrlRegistry.getMemberOfSiteUrl(this.session, site.getIdentifier(), personId);
            UrlBuilder url = new UrlBuilder(link);
            Response resp = this.read(url, 400);
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            if (json != null) {
                isMember = true;
            }
        }
        catch (AlfrescoServiceException e) {
            if (e.getErrorCode() == 400) {
                isMember = false;
            }
            OnPremiseSiteServiceImpl.convertException(e);
        }
        return isMember;
    }

    private boolean hasJoinRequest(Site site) {
        List<JoinSiteRequestImpl> requestedSites = this.getJoinSiteRequests();
        for (JoinSiteRequestImpl joinSiteRequest : requestedSites) {
            if (!site.getIdentifier().equals(joinSiteRequest.getSiteShortName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Site joinSite(Site site) {
        if (this.isObjectNull(site)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "site"));
        }
        SiteImpl updatedSite = null;
        try {
            String link = null;
            UrlBuilder url = null;
            Response resp = null;
            JSONObject jo = null;
            Map<String, Object> json = null;
            if (this.isMemberOf(site, this.session.getPersonIdentifier())) {
                throw new AlfrescoServiceException(403, Messagesl18n.getString("ErrorCodeRegistry.SITE_ALREADY_MEMBER"));
            }
            switch (site.getVisibility()) {
                case PUBLIC: {
                    link = OnPremiseUrlRegistry.getJoinPublicSiteUrl(this.session, site.getIdentifier());
                    url = new UrlBuilder(link);
                    jo = new JSONObject();
                    jo.put("role", (Object)"SiteConsumer");
                    JSONObject jp = new JSONObject();
                    jp.put("userName", (Object)this.session.getPersonIdentifier());
                    jo.put("person", (Object)jp);
                    final JsonDataWriter formData = new JsonDataWriter(jo);
                    resp = this.post(url, formData.getContentType(), new Output(){

                        public void write(OutputStream out) throws IOException {
                            formData.write(out);
                        }
                    }, 400);
                    json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
                    this.updateExtraPropertyCache(site.getIdentifier(), false, true, site.isFavorite());
                    updatedSite = new SiteImpl(site, false, true, site.isFavorite());
                    this.validateUpdateSite(updatedSite, 400);
                    break;
                }
                case MODERATED: {
                    if (this.hasJoinRequest(site)) {
                        throw new AlfrescoServiceException(403, Messagesl18n.getString("ErrorCodeRegistry.SITE_ALREADY_MEMBER.request"));
                    }
                    link = OnPremiseUrlRegistry.getJoinModeratedSiteUrl(this.session, site.getIdentifier());
                    url = new UrlBuilder(link);
                    jo = new JSONObject();
                    jo.put("invitationType", (Object)SiteVisibility.MODERATED.value());
                    jo.put("inviteeUserName", (Object)this.session.getPersonIdentifier());
                    jo.put("inviteeComments", null);
                    jo.put("inviteeRoleName", (Object)"SiteConsumer");
                    final JsonDataWriter formDataM = new JsonDataWriter(jo);
                    resp = this.post(url, formDataM.getContentType(), new Output(){

                        public void write(OutputStream out) throws IOException {
                            formDataM.write(out);
                        }
                    }, 400);
                    json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
                    Map jmo = (Map)json.get("data");
                    if (jmo != null) {
                        this.updateExtraPropertyCache(site.getIdentifier(), true, false, site.isFavorite());
                        updatedSite = new SiteImpl(site, true, false, site.isFavorite());
                        this.validateUpdateSite(updatedSite, 400);
                        break;
                    }
                    throw new AlfrescoServiceException(400, Messagesl18n.getString("ErrorCodeRegistry.SITE_NOT_JOINED.parsing"));
                }
                case PRIVATE: {
                    throw new AlfrescoServiceException(400, Messagesl18n.getString("ErrorCodeRegistry.SITE_NOT_JOINED.private"));
                }
                default: {
                    throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "visibility"));
                }
            }
        }
        catch (Exception e) {
            OnPremiseSiteServiceImpl.convertException(e);
        }
        return updatedSite;
    }

    @Override
    protected List<JoinSiteRequestImpl> getJoinSiteRequests() {
        ArrayList<JoinSiteRequestImpl> requestList = new ArrayList<JoinSiteRequestImpl>();
        try {
            String link = OnPremiseUrlRegistry.getJoinRequestSiteUrl(this.session, this.session.getPersonIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            Response resp = this.read(url, 400);
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            List jo = (List)json.get("data");
            for (Object obj : jo) {
                requestList.add(JoinSiteRequestImpl.parseJson((Map)obj));
            }
        }
        catch (Exception e) {
            OnPremiseSiteServiceImpl.convertException(e);
        }
        return requestList;
    }

    @Override
    protected PagingResult<JoinSiteRequestImpl> getJoinSiteRequests(ListingContext listingContext) {
        ArrayList<JoinSiteRequestImpl> requestList = new ArrayList<JoinSiteRequestImpl>();
        String link = OnPremiseUrlRegistry.getJoinRequestSiteUrl(this.session, this.session.getPersonIdentifier());
        UrlBuilder url = new UrlBuilder(link);
        Response resp = this.read(url, 400);
        Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
        List jo = (List)json.get("data");
        int size = jo.size();
        ArrayList result = new ArrayList();
        int fromIndex = 0;
        int toIndex = size;
        Boolean hasMoreItems = false;
        if (listingContext != null) {
            int n = fromIndex = listingContext.getSkipCount() > size ? size : listingContext.getSkipCount();
            if (listingContext.getMaxItems() + fromIndex >= size) {
                toIndex = size;
                hasMoreItems = false;
            } else {
                toIndex = listingContext.getMaxItems() + fromIndex;
                hasMoreItems = true;
            }
        }
        Map mapProperties = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            mapProperties = (Map)jo.get(i);
            requestList.add(JoinSiteRequestImpl.parseJson(mapProperties));
        }
        if (listingContext != null) {
            Collections.sort(result, new AlphaComparator(listingContext.isSortAscending(), listingContext.getSortProperty()));
        }
        return new PagingResultImpl<JoinSiteRequestImpl>(requestList, hasMoreItems, size);
    }

    @Override
    protected String getCancelJoinSiteRequestUrl(JoinSiteRequestImpl joinSiteRequest) {
        return OnPremiseUrlRegistry.getCancelJoinSiteRequestUrl(this.session, joinSiteRequest.getSiteShortName(), joinSiteRequest.getIdentifier());
    }

    @Override
    protected String getLeaveSiteUrl(Site site) {
        return OnPremiseUrlRegistry.getLeaveSiteUrl(this.session, site.getIdentifier(), this.session.getPersonIdentifier());
    }

    @Override
    public List<Person> getAllMembers(Site site) {
        return this.getAllMembers(site, null).getList();
    }

    @Override
    public PagingResult<Person> getAllMembers(Site site, ListingContext listingContext) {
        return this.searchMembers(site, null, listingContext);
    }

    @Override
    public List<Person> searchMembers(Site site, String keywords) {
        return this.searchMembers(site, keywords, null).getList();
    }

    @Override
    public PagingResult<Person> searchMembers(Site site, String keywords, ListingContext listingContext) {
        if (this.isObjectNull(site)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "site"));
        }
        ArrayList<PersonImpl> persons = new ArrayList<PersonImpl>();
        int maxItems = -1;
        try {
            String link = OnPremiseUrlRegistry.getSiteMembershipUrl(this.session, site.getIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            if (keywords != null) {
                url.addParameter("nf", (Object)keywords);
                url.addParameter("authorityType", (Object)"USER");
            }
            if (listingContext != null) {
                url.addParameter("size", (Object)listingContext.getMaxItems());
                maxItems = listingContext.getMaxItems();
                url.addParameter("pos", (Object)listingContext.getSkipCount());
            }
            Response resp = this.read(url, 400);
            List<Object> json = JsonUtils.parseArray(resp.getStream(), resp.getCharset());
            for (Object obj : json) {
                persons.add(PersonImpl.parseJson((Map)((Map)obj).get("authority"), false));
            }
        }
        catch (Exception e) {
            OnPremiseSiteServiceImpl.convertException(e);
        }
        return new PagingResultImpl<Person>(persons, maxItems != -1 && persons.size() == maxItems, persons.size());
    }

    @Override
    protected PagingResult<Site> computeSites(UrlBuilder url, ListingContext listingContext) {
        Response resp = this.read(url, 400);
        List<Object> json = JsonUtils.parseArray(resp.getStream(), resp.getCharset());
        int size = json.size();
        ArrayList<SiteImpl> result = new ArrayList<SiteImpl>();
        int fromIndex = 0;
        int toIndex = size;
        Boolean hasMoreItems = false;
        if (listingContext != null) {
            int n = fromIndex = listingContext.getSkipCount() > size ? size : listingContext.getSkipCount();
            if (listingContext.getMaxItems() + fromIndex >= size) {
                toIndex = size;
                hasMoreItems = false;
            } else {
                toIndex = listingContext.getMaxItems() + fromIndex;
                hasMoreItems = true;
            }
        } else {
            listingContext = new ListingContext();
            listingContext.setSortProperty(SORT_PROPERTY_TITLE);
        }
        String siteName = null;
        Map mapProperties = null;
        CacheSiteExtraProperties extraProperties = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            mapProperties = (Map)json.get(i);
            if (mapProperties == null) continue;
            siteName = JSONConverter.getString((Map)mapProperties, (String)"shortName");
            if (this.extraPropertiesCache.get((Object)siteName) != null) {
                extraProperties = (CacheSiteExtraProperties)this.extraPropertiesCache.get((Object)siteName);
                mapProperties.put("isPendingMember", extraProperties.isPendingMember);
                mapProperties.put("isMember", extraProperties.isMember);
                mapProperties.put("isFavorite", extraProperties.isFavorite);
            }
            result.add(SiteImpl.parseJson((Map)json.get(i)));
        }
        if (listingContext != null) {
            Collections.sort(result, new AlphaComparator(listingContext.isSortAscending(), listingContext.getSortProperty()));
        }
        return new PagingResultImpl<Site>(result, hasMoreItems, size);
    }

    private List<String> getUserSite(String personIdentifier) {
        Response resp = this.read(this.getUserSitesUrl(personIdentifier, null), 400);
        List<Object> json = JsonUtils.parseArray(resp.getStream(), resp.getCharset());
        int size = json.size();
        ArrayList<String> userSites = new ArrayList<String>(size);
        for (Object object : json) {
            userSites.add(JSONConverter.getString((Map)((Map)object), (String)"shortName"));
        }
        return userSites;
    }

    @Override
    protected String parseContainer(String link) {
        Map<String, Object> json;
        String n = null;
        UrlBuilder url = new UrlBuilder(link);
        Response resp = this.getHttpInvoker().invokeGET(url, this.getSessionHttp());
        if (resp.getResponseCode() == 404) {
            return null;
        }
        if (resp.getResponseCode() != 200) {
            this.convertStatusCode(resp, 400);
        }
        if ((json = JsonUtils.parseObject(resp.getStream(), resp.getCharset())).size() == 1) {
            Map jo = (Map)((List)json.get("containers")).get(0);
            n = (String)jo.get("nodeRef");
        }
        return n;
    }

    private List<String> computeFavoriteSite(String username) {
        String link = OnPremiseUrlRegistry.getUserFavoriteSitesUrl(this.session, username);
        UrlBuilder url = new UrlBuilder(link);
        Response resp = this.read(url, 400);
        Map json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
        String[] s = "org.alfresco.share.sites".split("\\.");
        for (int i = 0; i < s.length; ++i) {
            if (json.get(s[i]) == null) continue;
            json = (Map)json.get(s[i]);
        }
        ArrayList<String> tmpList = new ArrayList<String>();
        Map map = (Map)json.get("favourites");
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                tmpList.add((String)entry.getKey());
            }
        }
        return tmpList;
    }

    @Override
    protected PagingResult<Site> computeAllSites(UrlBuilder url, ListingContext listingContext) {
        return this.computeSites(url, listingContext);
    }

    @Override
    protected void retrieveExtraProperties(String personIdentifier) {
        try {
            ArrayList<JoinSiteRequestImpl> joinSiteRequestList = new ArrayList();
            try {
                joinSiteRequestList = this.getJoinSiteRequests();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Error during cache operation : JoinSiteRequest");
                Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            }
            List<String> favoriteSites = this.computeFavoriteSite(personIdentifier);
            List<String> userSites = this.getUserSite(personIdentifier);
            this.retrieveExtraProperties(favoriteSites, userSites, joinSiteRequestList);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Error during cache operation. The site object may contains incorrect informations");
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    public OnPremiseSiteServiceImpl(Parcel o) {
        super((AlfrescoSession)o.readParcelable(RepositorySessionImpl.class.getClassLoader()));
    }
}

