/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl.onpremise;

import android.os.Parcel;
import android.os.Parcelable;
import org.alfresco.mobile.android.api.model.impl.RepositoryVersionHelper;
import org.alfresco.mobile.android.api.network.NetworkHttpInvoker;
import org.alfresco.mobile.android.api.services.ActivityStreamService;
import org.alfresco.mobile.android.api.services.CommentService;
import org.alfresco.mobile.android.api.services.ModelDefinitionService;
import org.alfresco.mobile.android.api.services.PersonService;
import org.alfresco.mobile.android.api.services.RatingService;
import org.alfresco.mobile.android.api.services.SiteService;
import org.alfresco.mobile.android.api.services.TaggingService;
import org.alfresco.mobile.android.api.services.WorkflowService;
import org.alfresco.mobile.android.api.services.impl.AbstractServiceRegistry;
import org.alfresco.mobile.android.api.services.impl.onpremise.OnPremiseActivityStreamServiceImpl;
import org.alfresco.mobile.android.api.services.impl.onpremise.OnPremiseCommentServiceImpl;
import org.alfresco.mobile.android.api.services.impl.onpremise.OnPremiseDocumentFolderServiceImpl;
import org.alfresco.mobile.android.api.services.impl.onpremise.OnPremiseModelDefinitionServiceImpl;
import org.alfresco.mobile.android.api.services.impl.onpremise.OnPremisePersonServiceImpl;
import org.alfresco.mobile.android.api.services.impl.onpremise.OnPremiseRatingsServiceImpl;
import org.alfresco.mobile.android.api.services.impl.onpremise.OnPremiseSiteServiceImpl;
import org.alfresco.mobile.android.api.services.impl.onpremise.OnPremiseTaggingServiceImpl;
import org.alfresco.mobile.android.api.services.impl.onpremise.OnPremiseWorkflowServiceImpl;
import org.alfresco.mobile.android.api.services.impl.publicapi.PublicAPIActivityStreamServiceImpl;
import org.alfresco.mobile.android.api.services.impl.publicapi.PublicAPICommentServiceImpl;
import org.alfresco.mobile.android.api.services.impl.publicapi.PublicAPIDocumentFolderServiceImpl;
import org.alfresco.mobile.android.api.services.impl.publicapi.PublicAPIPersonServiceImpl;
import org.alfresco.mobile.android.api.services.impl.publicapi.PublicAPIRatingsServiceImpl;
import org.alfresco.mobile.android.api.services.impl.publicapi.PublicAPISiteServiceImpl;
import org.alfresco.mobile.android.api.services.impl.publicapi.PublicAPITaggingServiceImpl;
import org.alfresco.mobile.android.api.services.impl.publicapi.PublicAPIWorkflowServiceImpl;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.RepositorySession;
import org.alfresco.mobile.android.api.session.impl.RepositorySessionImpl;
import org.alfresco.mobile.android.api.utils.PublicAPIUrlRegistry;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

public class OnPremiseServiceRegistry
extends AbstractServiceRegistry {
    private static final String TAG = OnPremiseServiceRegistry.class.getSimpleName();
    private boolean hasPublicAPI = false;
    public static final Parcelable.Creator<OnPremiseServiceRegistry> CREATOR = new Parcelable.Creator<OnPremiseServiceRegistry>(){

        public OnPremiseServiceRegistry createFromParcel(Parcel in) {
            return new OnPremiseServiceRegistry(in);
        }

        public OnPremiseServiceRegistry[] newArray(int size) {
            return new OnPremiseServiceRegistry[size];
        }
    };

    public OnPremiseServiceRegistry(AlfrescoSession session) {
        super(session);
        if (session instanceof RepositorySessionImpl) {
            this.hasPublicAPI = ((RepositorySessionImpl)session).hasPublicAPI();
            this.documentFolderService = this.hasPublicAPI ? new PublicAPIDocumentFolderServiceImpl(session) : new OnPremiseDocumentFolderServiceImpl(session);
        }
    }

    public void init() {
    }

    @Override
    public SiteService getSiteService() {
        if (this.siteService == null && RepositoryVersionHelper.isAlfrescoProduct(this.session)) {
            this.siteService = this.hasPublicAPI ? new PublicAPISiteServiceImpl(this.session) : new OnPremiseSiteServiceImpl((RepositorySession)this.session);
        }
        return this.siteService;
    }

    @Override
    public CommentService getCommentService() {
        if (this.commentService == null && RepositoryVersionHelper.isAlfrescoProduct(this.session)) {
            this.commentService = this.hasPublicAPI ? new PublicAPICommentServiceImpl(this.session) : new OnPremiseCommentServiceImpl((RepositorySession)this.session);
        }
        return this.commentService;
    }

    @Override
    public TaggingService getTaggingService() {
        if (this.taggingService == null && RepositoryVersionHelper.isAlfrescoProduct(this.session)) {
            this.taggingService = this.hasPublicAPI ? new PublicAPITaggingServiceImpl(this.session) : new OnPremiseTaggingServiceImpl((RepositorySession)this.session);
        }
        return this.taggingService;
    }

    @Override
    public ActivityStreamService getActivityStreamService() {
        if (this.activityStreamService == null && RepositoryVersionHelper.isAlfrescoProduct(this.session)) {
            this.activityStreamService = this.hasPublicAPI ? new PublicAPIActivityStreamServiceImpl(this.session) : new OnPremiseActivityStreamServiceImpl((RepositorySession)this.session);
        }
        return this.activityStreamService;
    }

    @Override
    public RatingService getRatingService() {
        if (this.ratingsService == null && RepositoryVersionHelper.isAlfrescoProduct(this.session) && this.session.getRepositoryInfo().getCapabilities().doesSupportLikingNodes()) {
            this.ratingsService = this.hasPublicAPI ? new PublicAPIRatingsServiceImpl(this.session) : new OnPremiseRatingsServiceImpl((RepositorySession)this.session);
        }
        return this.ratingsService;
    }

    @Override
    public PersonService getPersonService() {
        if (this.personService == null && RepositoryVersionHelper.isAlfrescoProduct(this.session)) {
            this.personService = this.hasPublicAPI ? new PublicAPIPersonServiceImpl(this.session) : new OnPremisePersonServiceImpl((RepositorySession)this.session);
        }
        return this.personService;
    }

    @Override
    public WorkflowService getWorkflowService() {
        block6: {
            if (this.workflowService == null && RepositoryVersionHelper.isAlfrescoProduct(this.session)) {
                if (this.hasPublicAPI) {
                    try {
                        UrlBuilder builder = new UrlBuilder(PublicAPIUrlRegistry.getProcessDefinitionsUrl(this.session));
                        Response resp = NetworkHttpInvoker.invokeGET(builder, ((RepositorySessionImpl)this.session).getCmisSession().getBinding().getAuthenticationProvider().getHTTPHeaders(this.session.getBaseUrl()));
                        if (resp.getResponseCode() == 200) {
                            this.workflowService = new PublicAPIWorkflowServiceImpl(this.session);
                            break block6;
                        }
                        this.workflowService = new OnPremiseWorkflowServiceImpl(this.session);
                    }
                    catch (Exception e) {
                        this.workflowService = new OnPremiseWorkflowServiceImpl(this.session);
                    }
                } else {
                    this.workflowService = new OnPremiseWorkflowServiceImpl(this.session);
                }
            }
        }
        return this.workflowService;
    }

    @Override
    public ModelDefinitionService getModelDefinitionService() {
        if (this.typeDefinitionService == null && RepositoryVersionHelper.isAlfrescoProduct(this.session)) {
            this.typeDefinitionService = this.hasPublicAPI ? new OnPremiseModelDefinitionServiceImpl(this.session) : new OnPremiseModelDefinitionServiceImpl((RepositorySession)this.session);
        }
        return this.typeDefinitionService;
    }

    public OnPremiseServiceRegistry(Parcel o) {
        super((AlfrescoSession)o.readParcelable(RepositorySessionImpl.class.getClassLoader()));
    }
}

