/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl.onpremise;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Map;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.services.impl.AbstractRatingsService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.RepositorySession;
import org.alfresco.mobile.android.api.session.impl.RepositorySessionImpl;
import org.alfresco.mobile.android.api.utils.JsonUtils;
import org.alfresco.mobile.android.api.utils.OnPremiseUrlRegistry;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;

public class OnPremiseRatingsServiceImpl
extends AbstractRatingsService {
    public static final Parcelable.Creator<OnPremiseRatingsServiceImpl> CREATOR = new Parcelable.Creator<OnPremiseRatingsServiceImpl>(){

        public OnPremiseRatingsServiceImpl createFromParcel(Parcel in) {
            return new OnPremiseRatingsServiceImpl(in);
        }

        public OnPremiseRatingsServiceImpl[] newArray(int size) {
            return new OnPremiseRatingsServiceImpl[size];
        }
    };

    public OnPremiseRatingsServiceImpl(RepositorySession repositorySession) {
        super(repositorySession);
    }

    @Override
    protected UrlBuilder getRatingsUrl(Node node) {
        return new UrlBuilder(OnPremiseUrlRegistry.getRatingsUrl(this.session, node.getIdentifier()));
    }

    @Override
    protected JSONObject getRatingsObject() {
        JSONObject jo = new JSONObject();
        jo.put("rating", (Object)"1");
        jo.put("ratingScheme", (Object)"likesRatingScheme");
        return jo;
    }

    @Override
    protected UrlBuilder getUnlikeUrl(Node node) {
        return new UrlBuilder(OnPremiseUrlRegistry.getUnlikeUrl(this.session, node.getIdentifier()));
    }

    @Override
    protected int computeRatingsCount(UrlBuilder url) {
        Response resp = this.read(url, 1000);
        Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
        Map j = (Map)json.get("data");
        if (j.size() == 0 && j.get("nodeStatistics") == null) {
            return -1;
        }
        Map js = (Map)j.get("nodeStatistics");
        if (js.size() == 0 && js.get("likesRatingScheme") == null) {
            return -1;
        }
        Map jso = (Map)js.get("likesRatingScheme");
        if (jso.size() != 0 && jso.get("ratingsCount") != null) {
            return Integer.parseInt(JSONConverter.getString((Map)jso, (String)"ratingsCount"));
        }
        return -1;
    }

    @Override
    protected boolean computeIsRated(UrlBuilder url) {
        Response resp = this.read(url, 1000);
        Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
        Map j = (Map)json.get("data");
        if (j.size() == 0 && j.get("ratings") == null) {
            return false;
        }
        Map js = (Map)j.get("ratings");
        if (js.size() == 0 && js.get("likesRatingScheme") == null) {
            return false;
        }
        Map jso = (Map)js.get("likesRatingScheme");
        if (jso.size() != 0 && jso.get("appliedBy") != null) {
            return this.session.getPersonIdentifier().equals(JSONConverter.getString((Map)jso, (String)"appliedBy"));
        }
        return false;
    }

    public OnPremiseRatingsServiceImpl(Parcel o) {
        super((AlfrescoSession)o.readParcelable(RepositorySessionImpl.class.getClassLoader()));
    }
}

