/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl.onpremise;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.exceptions.AlfrescoServiceException;
import org.alfresco.mobile.android.api.model.ContentStream;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.Person;
import org.alfresco.mobile.android.api.model.impl.ContentStreamImpl;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.model.impl.PersonImpl;
import org.alfresco.mobile.android.api.services.impl.AbstractPersonService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.RepositorySession;
import org.alfresco.mobile.android.api.session.impl.RepositorySessionImpl;
import org.alfresco.mobile.android.api.utils.JsonUtils;
import org.alfresco.mobile.android.api.utils.OnPremiseUrlRegistry;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

public class OnPremisePersonServiceImpl
extends AbstractPersonService {
    public static final Parcelable.Creator<OnPremisePersonServiceImpl> CREATOR = new Parcelable.Creator<OnPremisePersonServiceImpl>(){

        public OnPremisePersonServiceImpl createFromParcel(Parcel in) {
            return new OnPremisePersonServiceImpl(in);
        }

        public OnPremisePersonServiceImpl[] newArray(int size) {
            return new OnPremisePersonServiceImpl[size];
        }
    };

    public OnPremisePersonServiceImpl(RepositorySession repositorySession) {
        super(repositorySession);
    }

    @Override
    protected UrlBuilder getPersonDetailssUrl(String personIdentifier) {
        return new UrlBuilder(OnPremiseUrlRegistry.getPersonDetailsUrl(this.session, personIdentifier));
    }

    @Override
    public UrlBuilder getAvatarUrl(String personIdentifier) {
        if (this.isStringNull(personIdentifier)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "personIdentifier"));
        }
        String url = this.getAvatarURL(personIdentifier);
        if (this.session.getRepositoryInfo().getMajorVersion() < 4) {
            Person person = this.getPerson(personIdentifier);
            url = OnPremiseUrlRegistry.getThumbnailsUrl(this.session, person.getAvatarIdentifier(), "avatar");
        }
        return new UrlBuilder(url);
    }

    @Override
    public ContentStream getAvatarStream(String personIdentifier) {
        if (this.isStringNull(personIdentifier)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "personIdentifier"));
        }
        try {
            ContentStreamImpl cf = null;
            UrlBuilder builder = this.getAvatarUrl(personIdentifier);
            Response resp = this.read(builder, 800);
            cf = new ContentStreamImpl(resp.getStream(), resp.getContentTypeHeader() + ";" + resp.getCharset(), resp.getContentLength().longValue());
            return cf;
        }
        catch (Exception e) {
            OnPremisePersonServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public List<Person> search(String keyword) {
        return this.search(keyword, null).getList();
    }

    @Override
    public PagingResult<Person> search(String keyword, ListingContext listingContext) {
        if (this.isStringNull(keyword)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "keyword"));
        }
        ArrayList<PersonImpl> definitions = new ArrayList<PersonImpl>();
        Map<Object, Object> json = new HashMap(0);
        int size = 0;
        try {
            Response resp;
            String link = OnPremiseUrlRegistry.getSearchPersonUrl(this.session);
            UrlBuilder url = new UrlBuilder(link);
            url.addParameter("filter", (Object)keyword);
            if (listingContext != null) {
                url.addParameter("maxResults", (Object)listingContext.getMaxItems());
            }
            if ((json = JsonUtils.parseObject((resp = this.read(url, 800)).getStream(), resp.getCharset())) != null) {
                List jo = (List)json.get("people");
                size = jo.size();
                for (Object obj : jo) {
                    definitions.add(PersonImpl.parseJson((Map)obj));
                }
            }
        }
        catch (Exception e) {
            OnPremisePersonServiceImpl.convertException(e);
        }
        return new PagingResultImpl<Person>(definitions, false, size);
    }

    @Override
    public Person refresh(Person person) {
        return this.getPerson(person.getIdentifier());
    }

    private String getAvatarURL(String username) {
        return OnPremiseUrlRegistry.getAvatarUrl(this.session, username);
    }

    @Override
    protected Person computePerson(UrlBuilder url) {
        Response resp = this.getHttpInvoker().invokeGET(url, this.getSessionHttp());
        if (resp.getResponseCode() == 404) {
            throw new AlfrescoServiceException(801, resp.getErrorContent());
        }
        if (resp.getResponseCode() != 200) {
            this.convertStatusCode(resp, 800);
        }
        Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
        return PersonImpl.parseJson(json);
    }

    public OnPremisePersonServiceImpl(Parcel o) {
        super((AlfrescoSession)o.readParcelable(RepositorySessionImpl.class.getClassLoader()));
    }
}

