/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl.onpremise;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.model.ContentStream;
import org.alfresco.mobile.android.api.model.Document;
import org.alfresco.mobile.android.api.model.Folder;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.SearchLanguage;
import org.alfresco.mobile.android.api.model.impl.ContentStreamImpl;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.services.impl.AbstractDocumentFolderServiceImpl;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.impl.RepositorySessionImpl;
import org.alfresco.mobile.android.api.utils.JsonDataWriter;
import org.alfresco.mobile.android.api.utils.JsonUtils;
import org.alfresco.mobile.android.api.utils.NodeRefUtils;
import org.alfresco.mobile.android.api.utils.OnPremiseUrlRegistry;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;

public class OnPremiseDocumentFolderServiceImpl
extends AbstractDocumentFolderServiceImpl {
    public static final Parcelable.Creator<OnPremiseDocumentFolderServiceImpl> CREATOR = new Parcelable.Creator<OnPremiseDocumentFolderServiceImpl>(){

        public OnPremiseDocumentFolderServiceImpl createFromParcel(Parcel in) {
            return new OnPremiseDocumentFolderServiceImpl(in);
        }

        public OnPremiseDocumentFolderServiceImpl[] newArray(int size) {
            return new OnPremiseDocumentFolderServiceImpl[size];
        }
    };

    public OnPremiseDocumentFolderServiceImpl(AlfrescoSession repositorySession) {
        super(repositorySession);
    }

    @Override
    public UrlBuilder getRenditionUrl(String identifier, String type) {
        try {
            UrlBuilder url = new UrlBuilder(OnPremiseUrlRegistry.getThumbnailsUrl(this.session, identifier, type));
            url.addParameter("format", (Object)"json");
            return url;
        }
        catch (Exception e) {
            OnPremiseDocumentFolderServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public ContentStream getRenditionStream(String identifier, String type) {
        try {
            ContentStreamImpl cf;
            UrlBuilder url = this.getRenditionUrl(identifier, type);
            Response resp = this.getHttpInvoker().invokeGET(url, this.getSessionHttp());
            if (resp.getResponseCode() == 404) {
                cf = null;
            } else if (resp.getResponseCode() != 200) {
                this.convertStatusCode(resp, 600);
                cf = null;
            } else {
                cf = new ContentStreamImpl(resp.getStream(), resp.getContentTypeHeader() + ";" + resp.getCharset(), resp.getContentLength().longValue());
            }
            return cf;
        }
        catch (Exception e) {
            OnPremiseDocumentFolderServiceImpl.convertException(e);
            return null;
        }
    }

    public OnPremiseDocumentFolderServiceImpl(Parcel o) {
        super((AlfrescoSession)o.readParcelable(RepositorySessionImpl.class.getClassLoader()));
    }

    @Override
    public List<Document> getFavoriteDocuments() {
        ArrayList<Document> favoriteDocumentsList = new ArrayList<Document>(0);
        try {
            Object[] favoriteDocumentsIdentifier = this.parsePreferenceResponse(this.session, this.session.getPersonIdentifier(), "org.alfresco.share.documents.favourites");
            if (favoriteDocumentsIdentifier == null) {
                return favoriteDocumentsList;
            }
            StringBuilder builder = new StringBuilder("SELECT * FROM cmis:document WHERE cmis:objectId=");
            JsonUtils.join(builder, " OR cmis:objectId=", favoriteDocumentsIdentifier);
            List<Node> nodes = this.session.getServiceRegistry().getSearchService().search(builder.toString(), SearchLanguage.CMIS);
            for (Node node : nodes) {
                favoriteDocumentsList.add((Document)node);
            }
        }
        catch (Exception e) {
            OnPremiseDocumentFolderServiceImpl.convertException(e);
        }
        return favoriteDocumentsList;
    }

    @Override
    public PagingResult<Document> getFavoriteDocuments(ListingContext listingContext) {
        List<Document> docs = this.getFavoriteDocuments();
        return new PagingResultImpl<Document>(docs, false, docs.size());
    }

    @Override
    public List<Folder> getFavoriteFolders() {
        ArrayList<Folder> favoriteFolderList = new ArrayList<Folder>(0);
        try {
            Object[] favoriteFoldersIdentifier = this.parsePreferenceResponse(this.session, this.session.getPersonIdentifier(), "org.alfresco.share.folders.favourites");
            if (favoriteFoldersIdentifier == null) {
                return favoriteFolderList;
            }
            StringBuilder builder = new StringBuilder("SELECT * FROM cmis:folder WHERE cmis:objectId=");
            JsonUtils.join(builder, " OR cmis:objectId=", favoriteFoldersIdentifier);
            List<Node> nodes = this.session.getServiceRegistry().getSearchService().search(builder.toString(), SearchLanguage.CMIS);
            for (Node node : nodes) {
                favoriteFolderList.add((Folder)node);
            }
        }
        catch (Exception e) {
            OnPremiseDocumentFolderServiceImpl.convertException(e);
        }
        return favoriteFolderList;
    }

    @Override
    public PagingResult<Folder> getFavoriteFolders(ListingContext listingContext) {
        List<Folder> docs = this.getFavoriteFolders();
        return new PagingResultImpl<Folder>(docs, false, docs.size());
    }

    @Override
    public List<Node> getFavoriteNodes() {
        ArrayList<Node> favoriteFolderList = new ArrayList<Node>();
        favoriteFolderList.addAll(this.getFavoriteDocuments());
        favoriteFolderList.addAll(this.getFavoriteFolders());
        return favoriteFolderList;
    }

    @Override
    public PagingResult<Node> getFavoriteNodes(ListingContext listingContext) {
        List<Node> docs = this.getFavoriteNodes();
        return new PagingResultImpl<Node>(docs, false, docs.size());
    }

    @Override
    public boolean isFavorite(Node node) {
        String[] favoriteIdentifier = null;
        String filter = "org.alfresco.share.documents.favourites";
        if (node.isFolder()) {
            filter = "org.alfresco.share.folders.favourites";
        }
        if ((favoriteIdentifier = this.parsePreferenceResponse(this.session, this.session.getPersonIdentifier(), filter)) == null) {
            return false;
        }
        HashSet<String> h = new HashSet<String>(Arrays.asList(favoriteIdentifier));
        return h.contains(NodeRefUtils.getCleanIdentifier(node.getIdentifier()));
    }

    @Override
    public void addFavorite(Node node) {
        this.favoriteNode(node, true);
    }

    @Override
    public void removeFavorite(Node node) {
        this.favoriteNode(node, false);
    }

    private void favoriteNode(Node node, boolean addFavorite) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        try {
            String[] favs;
            String cleanIdentifier;
            String joined = cleanIdentifier = NodeRefUtils.getCleanIdentifier(node.getIdentifier());
            String link = OnPremiseUrlRegistry.getUserPreferenceUrl(this.session, this.session.getPersonIdentifier());
            UrlBuilder url = new UrlBuilder(link);
            ArrayList<String> favoriteIdentifier = null;
            String filter = "org.alfresco.share.documents.favourites";
            if (node.isFolder()) {
                filter = "org.alfresco.share.folders.favourites";
            }
            if ((favs = this.parsePreferenceResponse(this.session, this.session.getPersonIdentifier(), filter)) != null) {
                favoriteIdentifier = new ArrayList<String>(Arrays.asList(favs));
                HashSet<String> index = new HashSet<String>(favoriteIdentifier);
                boolean hasIdentifier = index.contains(cleanIdentifier);
                if (addFavorite && !hasIdentifier) {
                    favoriteIdentifier.add(cleanIdentifier);
                    joined = TextUtils.join((CharSequence)",", favoriteIdentifier);
                } else if (!addFavorite && hasIdentifier) {
                    index.remove(cleanIdentifier);
                    joined = TextUtils.join((CharSequence)",", (Object[])index.toArray(new String[0]));
                }
            }
            String[] sitePrefence = filter.split("\\.");
            int length = sitePrefence.length - 1;
            JSONObject jroot = new JSONObject();
            JSONObject jt = null;
            JSONObject jp = jroot;
            for (int i = 0; i < length; ++i) {
                jt = new JSONObject();
                jp.put(sitePrefence[i], (Object)jt);
                jp = jt;
            }
            jt.put("favourites", (Object)joined);
            final JsonDataWriter formDataM = new JsonDataWriter(jroot);
            this.post(url, formDataM.getContentType(), new Output(){

                public void write(OutputStream out) throws IOException {
                    formDataM.write(out);
                }
            }, 600);
        }
        catch (Exception e) {
            OnPremiseDocumentFolderServiceImpl.convertException(e);
        }
    }

    public String[] parsePreferenceResponse(AlfrescoSession session, String username, String preferenceFilter) {
        String link = OnPremiseUrlRegistry.getPreferencesUrl(session, username, preferenceFilter);
        UrlBuilder url = new UrlBuilder(link);
        Response resp = this.read(url, 600);
        Map json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
        String[] s = preferenceFilter.split("\\.");
        for (int i = 0; i < s.length - 1; ++i) {
            if (json.get(s[i]) == null) continue;
            json = (Map)json.get(s[i]);
        }
        String favourites = (String)json.get("favourites");
        if (!this.isStringNull(favourites)) {
            return favourites.split(",");
        }
        return null;
    }
}

