/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl.onpremise;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.model.Comment;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.impl.CommentImpl;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.services.impl.AbstractCommentService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.impl.RepositorySessionImpl;
import org.alfresco.mobile.android.api.utils.JsonUtils;
import org.alfresco.mobile.android.api.utils.OnPremiseUrlRegistry;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

public class OnPremiseCommentServiceImpl
extends AbstractCommentService {
    public static final Parcelable.Creator<OnPremiseCommentServiceImpl> CREATOR = new Parcelable.Creator<OnPremiseCommentServiceImpl>(){

        public OnPremiseCommentServiceImpl createFromParcel(Parcel in) {
            return new OnPremiseCommentServiceImpl(in);
        }

        public OnPremiseCommentServiceImpl[] newArray(int size) {
            return new OnPremiseCommentServiceImpl[size];
        }
    };

    public OnPremiseCommentServiceImpl(AlfrescoSession repositorySession) {
        super(repositorySession);
    }

    @Override
    protected UrlBuilder getCommentsUrl(Node node, ListingContext listingContext, boolean isReadOperation) {
        String link = OnPremiseUrlRegistry.getCommentsUrl(this.session, node.getIdentifier());
        UrlBuilder url = new UrlBuilder(link);
        if (listingContext != null) {
            url.addParameter("reverse", (Object)listingContext.isSortAscending());
            url.addParameter("startIndex", (Object)listingContext.getSkipCount());
            url.addParameter("pageSize", (Object)listingContext.getMaxItems());
        } else if (isReadOperation) {
            url.addParameter("reverse", (Object)true);
        }
        return url;
    }

    @Override
    protected UrlBuilder getCommentUrl(Node node, Comment comment) {
        return new UrlBuilder(OnPremiseUrlRegistry.getCommentUrl(this.session, comment.getIdentifier()));
    }

    @Override
    protected Comment parseData(Map<String, Object> json) {
        return CommentImpl.parseJson((Map)json.get("item"));
    }

    @Override
    protected PagingResult<Comment> computeComment(UrlBuilder url) {
        try {
            Response resp = this.read(url, 300);
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            List jo = (List)json.get("items");
            ArrayList<CommentImpl> result = new ArrayList<CommentImpl>(jo.size());
            for (Object obj : jo) {
                result.add(CommentImpl.parseJson((Map)obj));
            }
            int pageSize = JSONConverter.getString(json, (String)"pageSize") != null ? Integer.parseInt(JSONConverter.getString(json, (String)"pageSize")) : 0;
            int startIndex = JSONConverter.getString(json, (String)"startIndex") != null ? Integer.parseInt(JSONConverter.getString(json, (String)"startIndex")) : 0;
            int total = JSONConverter.getString(json, (String)"total") != null ? Integer.parseInt(JSONConverter.getString(json, (String)"total")) : 0;
            boolean hasMoreItem = startIndex + pageSize < total;
            return new PagingResultImpl<Comment>(result, hasMoreItem, total);
        }
        catch (Exception e) {
            OnPremiseCommentServiceImpl.convertException(e);
            return null;
        }
    }

    public OnPremiseCommentServiceImpl(Parcel o) {
        super((AlfrescoSession)o.readParcelable(RepositorySessionImpl.class.getClassLoader()));
    }
}

