/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl.onpremise;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.model.ActivityEntry;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.impl.ActivityEntryImpl;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.services.impl.AbstractActivityStreamService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.RepositorySession;
import org.alfresco.mobile.android.api.session.impl.RepositorySessionImpl;
import org.alfresco.mobile.android.api.utils.JsonUtils;
import org.alfresco.mobile.android.api.utils.OnPremiseUrlRegistry;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

public class OnPremiseActivityStreamServiceImpl
extends AbstractActivityStreamService {
    public static final Parcelable.Creator<OnPremiseActivityStreamServiceImpl> CREATOR = new Parcelable.Creator<OnPremiseActivityStreamServiceImpl>(){

        public OnPremiseActivityStreamServiceImpl createFromParcel(Parcel in) {
            return new OnPremiseActivityStreamServiceImpl(in);
        }

        public OnPremiseActivityStreamServiceImpl[] newArray(int size) {
            return new OnPremiseActivityStreamServiceImpl[size];
        }
    };

    public OnPremiseActivityStreamServiceImpl(RepositorySession repositorySession) {
        super(repositorySession);
    }

    @Override
    protected UrlBuilder getUserActivitiesUrl(ListingContext listingContext) {
        String link = OnPremiseUrlRegistry.getUserActivitiesUrl(this.session);
        return new UrlBuilder(link);
    }

    @Override
    protected UrlBuilder getUserActivitiesUrl(String personIdentifier, ListingContext listingContext) {
        String link = OnPremiseUrlRegistry.getUserActivitiesUrl(this.session, personIdentifier);
        return new UrlBuilder(link);
    }

    @Override
    protected UrlBuilder getSiteActivitiesUrl(String siteIdentifier, ListingContext listingContext) {
        String link = OnPremiseUrlRegistry.getSiteActivitiesUrl(this.session, siteIdentifier);
        return new UrlBuilder(link);
    }

    @Override
    protected PagingResult<ActivityEntry> computeActivities(UrlBuilder url, ListingContext listingContext) {
        try {
            Response resp = this.read(url, 500);
            List<Object> json = JsonUtils.parseArray(resp.getStream(), resp.getCharset());
            int size = json.size();
            ArrayList<ActivityEntryImpl> result = new ArrayList<ActivityEntryImpl>(size);
            Boolean b = false;
            if (listingContext != null) {
                int fromIndex;
                int n = fromIndex = listingContext.getSkipCount() > size ? size : listingContext.getSkipCount();
                if (listingContext.getMaxItems() + fromIndex >= size) {
                    json = json.subList(fromIndex, size);
                    b = false;
                } else {
                    json = json.subList(fromIndex, listingContext.getMaxItems() + fromIndex);
                    b = true;
                }
            }
            if (json != null) {
                for (Object obj : json) {
                    result.add(ActivityEntryImpl.parseJson((Map)obj));
                }
            }
            return new PagingResultImpl<ActivityEntry>(result, b, size);
        }
        catch (Exception e) {
            OnPremiseActivityStreamServiceImpl.convertException(e);
            return null;
        }
    }

    public OnPremiseActivityStreamServiceImpl(Parcel o) {
        super((AlfrescoSession)o.readParcelable(RepositorySessionImpl.class.getClassLoader()));
    }
}

