/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl.cloud;

import android.os.Parcel;
import android.os.Parcelable;
import org.alfresco.mobile.android.api.model.impl.RepositoryVersionHelper;
import org.alfresco.mobile.android.api.services.ActivityStreamService;
import org.alfresco.mobile.android.api.services.CommentService;
import org.alfresco.mobile.android.api.services.ModelDefinitionService;
import org.alfresco.mobile.android.api.services.PersonService;
import org.alfresco.mobile.android.api.services.RatingService;
import org.alfresco.mobile.android.api.services.SiteService;
import org.alfresco.mobile.android.api.services.TaggingService;
import org.alfresco.mobile.android.api.services.WorkflowService;
import org.alfresco.mobile.android.api.services.impl.AbstractServiceRegistry;
import org.alfresco.mobile.android.api.services.impl.cloud.CloudActivityStreamServiceImpl;
import org.alfresco.mobile.android.api.services.impl.cloud.CloudCommentServiceImpl;
import org.alfresco.mobile.android.api.services.impl.cloud.CloudDocumentFolderServiceImpl;
import org.alfresco.mobile.android.api.services.impl.cloud.CloudPersonServiceImpl;
import org.alfresco.mobile.android.api.services.impl.cloud.CloudRatingsServiceImpl;
import org.alfresco.mobile.android.api.services.impl.cloud.CloudSiteServiceImpl;
import org.alfresco.mobile.android.api.services.impl.cloud.CloudTaggingServiceImpl;
import org.alfresco.mobile.android.api.services.impl.cloud.CloudWorkflowServiceImpl;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.CloudSession;
import org.alfresco.mobile.android.api.session.impl.CloudSessionImpl;

public class CloudServiceRegistry
extends AbstractServiceRegistry {
    public static final Parcelable.Creator<CloudServiceRegistry> CREATOR = new Parcelable.Creator<CloudServiceRegistry>(){

        public CloudServiceRegistry createFromParcel(Parcel in) {
            return new CloudServiceRegistry(in);
        }

        public CloudServiceRegistry[] newArray(int size) {
            return new CloudServiceRegistry[size];
        }
    };

    public CloudServiceRegistry(AlfrescoSession session) {
        super(session);
        this.documentFolderService = new CloudDocumentFolderServiceImpl(session);
    }

    @Override
    public SiteService getSiteService() {
        if (this.siteService == null && RepositoryVersionHelper.isAlfrescoProduct(this.session)) {
            this.siteService = new CloudSiteServiceImpl((CloudSession)this.session);
        }
        return this.siteService;
    }

    @Override
    public CommentService getCommentService() {
        if (this.commentService == null && RepositoryVersionHelper.isAlfrescoProduct(this.session)) {
            this.commentService = new CloudCommentServiceImpl((CloudSession)this.session);
        }
        return this.commentService;
    }

    @Override
    public TaggingService getTaggingService() {
        if (this.taggingService == null && RepositoryVersionHelper.isAlfrescoProduct(this.session)) {
            this.taggingService = new CloudTaggingServiceImpl((CloudSession)this.session);
        }
        return this.taggingService;
    }

    @Override
    public ActivityStreamService getActivityStreamService() {
        if (this.activityStreamService == null && RepositoryVersionHelper.isAlfrescoProduct(this.session)) {
            this.activityStreamService = new CloudActivityStreamServiceImpl((CloudSession)this.session);
        }
        return this.activityStreamService;
    }

    @Override
    public RatingService getRatingService() {
        if (this.ratingsService == null && RepositoryVersionHelper.isAlfrescoProduct(this.session) && this.session.getRepositoryInfo().getCapabilities().doesSupportLikingNodes()) {
            this.ratingsService = new CloudRatingsServiceImpl((CloudSession)this.session);
        }
        return this.ratingsService;
    }

    @Override
    public PersonService getPersonService() {
        if (this.personService == null && RepositoryVersionHelper.isAlfrescoProduct(this.session)) {
            this.personService = new CloudPersonServiceImpl((CloudSession)this.session);
        }
        return this.personService;
    }

    @Override
    public WorkflowService getWorkflowService() {
        if (this.workflowService == null && RepositoryVersionHelper.isAlfrescoProduct(this.session)) {
            this.workflowService = new CloudWorkflowServiceImpl((CloudSession)this.session);
        }
        return this.workflowService;
    }

    @Override
    public ModelDefinitionService getModelDefinitionService() {
        throw new UnsupportedOperationException("This method is not supported for Alfresco Cloud");
    }

    public CloudServiceRegistry(Parcel o) {
        super((AlfrescoSession)o.readParcelable(CloudSessionImpl.class.getClassLoader()));
    }
}

