/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl.cloud;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.List;
import org.alfresco.mobile.android.api.model.ContentStream;
import org.alfresco.mobile.android.api.model.impl.ContentStreamImpl;
import org.alfresco.mobile.android.api.services.impl.publicapi.PublicAPIDocumentFolderServiceImpl;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.CloudSession;
import org.alfresco.mobile.android.api.session.impl.CloudSessionImpl;
import org.alfresco.mobile.android.api.utils.CloudUrlRegistry;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

public class CloudDocumentFolderServiceImpl
extends PublicAPIDocumentFolderServiceImpl {
    private static final String RENDITION_CMIS_THUMBNAIL = "cmis:thumbnail";
    private static final String RENDITION_WEBPREVIEW = "alf:webpreview";
    private static final String RENDITION_ALL = "*";
    public static final Parcelable.Creator<CloudDocumentFolderServiceImpl> CREATOR = new Parcelable.Creator<CloudDocumentFolderServiceImpl>(){

        public CloudDocumentFolderServiceImpl createFromParcel(Parcel in) {
            return new CloudDocumentFolderServiceImpl(in);
        }

        public CloudDocumentFolderServiceImpl[] newArray(int size) {
            return new CloudDocumentFolderServiceImpl[size];
        }
    };

    public CloudDocumentFolderServiceImpl(AlfrescoSession cloudSession) {
        super(cloudSession);
    }

    @Override
    public UrlBuilder getRenditionUrl(String identifier, String title) {
        UrlBuilder cf = null;
        try {
            String internalRenditionType = null;
            if ("doclib".equals(title)) {
                internalRenditionType = RENDITION_CMIS_THUMBNAIL;
            } else if ("imgpreview".equals(title)) {
                internalRenditionType = RENDITION_WEBPREVIEW;
            }
            String renditionIdentifier = this.getRendition(identifier, internalRenditionType, title);
            if (renditionIdentifier == null) {
                return null;
            }
            return new UrlBuilder(CloudUrlRegistry.getThumbnailUrl((CloudSession)this.session, identifier, renditionIdentifier));
        }
        catch (CmisObjectNotFoundException e) {
            cf = null;
        }
        catch (Exception e) {
            CloudDocumentFolderServiceImpl.convertException(e);
        }
        return cf;
    }

    @Override
    public ContentStream getRenditionStream(String identifier, String title) {
        ContentStreamImpl cf = null;
        try {
            UrlBuilder url = this.getRenditionUrl(identifier, title);
            Response resp = this.getHttpInvoker().invokeGET(url, this.getSessionHttp());
            if (resp.getResponseCode() == 404) {
                cf = null;
            } else if (resp.getResponseCode() != 200) {
                this.convertStatusCode(resp, 600);
                cf = null;
            } else {
                cf = new ContentStreamImpl(resp.getStream(), resp.getContentTypeHeader() + ";" + resp.getCharset(), resp.getContentLength() != null ? resp.getContentLength().longValue() : -1L);
            }
        }
        catch (CmisObjectNotFoundException e) {
            cf = null;
        }
        catch (Exception e) {
            CloudDocumentFolderServiceImpl.convertException(e);
        }
        return cf;
    }

    private String getRendition(String identifier, String kind, String title) {
        OperationContext context = this.cmisSession.createOperationContext();
        context.setRenditionFilterString(RENDITION_ALL);
        CmisObject object = this.cmisSession.getObject(identifier, context);
        if (object != null && kind != null) {
            List renditions = object.getRenditions();
            if (renditions == null) {
                return null;
            }
            for (Rendition rendition : renditions) {
                if (!kind.equalsIgnoreCase(rendition.getKind()) || !title.equalsIgnoreCase(rendition.getTitle())) continue;
                return rendition.getStreamId();
            }
        }
        return null;
    }

    public CloudDocumentFolderServiceImpl(Parcel o) {
        super((AlfrescoSession)o.readParcelable(CloudSessionImpl.class.getClassLoader()));
    }
}

