/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.cmis.client.AlfrescoDocument;
import org.alfresco.mobile.android.api.model.ContentFile;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.impl.DocumentImpl;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.services.VersionService;
import org.alfresco.mobile.android.api.services.impl.AbstractDocumentFolderServiceImpl;
import org.alfresco.mobile.android.api.services.impl.AlfrescoService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.impl.AbstractAlfrescoSessionImpl;
import org.alfresco.mobile.android.api.utils.IOUtils;
import org.alfresco.mobile.android.api.utils.NodeComparator;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.spi.VersioningService;

public class VersionServiceImpl
extends AlfrescoService
implements VersionService {
    protected Session cmisSession;
    public static final Parcelable.Creator<VersionServiceImpl> CREATOR = new Parcelable.Creator<VersionServiceImpl>(){

        public VersionServiceImpl createFromParcel(Parcel in) {
            return new VersionServiceImpl(in);
        }

        public VersionServiceImpl[] newArray(int size) {
            return new VersionServiceImpl[size];
        }
    };

    public VersionServiceImpl(AlfrescoSession repositorySession) {
        super(repositorySession);
        this.cmisSession = ((AbstractAlfrescoSessionImpl)repositorySession).getCmisSession();
    }

    @Override
    public org.alfresco.mobile.android.api.model.Document getLatestVersion(org.alfresco.mobile.android.api.model.Document document) {
        if (this.isObjectNull(document)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "document"));
        }
        try {
            VersioningService versioningService = this.cmisSession.getBinding().getVersioningService();
            OperationContext ctxt = this.cmisSession.getDefaultContext();
            ObjectFactory objectFactory = this.cmisSession.getObjectFactory();
            ObjectData objectData = versioningService.getObjectOfLatestVersion(this.session.getRepositoryInfo().getIdentifier(), document.getIdentifier(), (String)document.getProperty("cmis:versionSeriesId").getValue(), Boolean.valueOf(false), ctxt.getFilterString(), Boolean.valueOf(ctxt.isIncludeAllowableActions()), ctxt.getIncludeRelationships(), ctxt.getRenditionFilterString(), Boolean.valueOf(ctxt.isIncludePolicies()), Boolean.valueOf(ctxt.isIncludeAcls()), null);
            return (org.alfresco.mobile.android.api.model.Document)this.convertNode(objectFactory.convertObject(objectData, ctxt));
        }
        catch (Exception e) {
            VersionServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public List<org.alfresco.mobile.android.api.model.Document> getVersions(org.alfresco.mobile.android.api.model.Document document) {
        return this.getVersions(document, null).getList();
    }

    @Override
    public PagingResult<org.alfresco.mobile.android.api.model.Document> getVersions(org.alfresco.mobile.android.api.model.Document document, ListingContext listingContext) {
        return this.computeVersion(document, listingContext);
    }

    @Override
    public org.alfresco.mobile.android.api.model.Document checkout(org.alfresco.mobile.android.api.model.Document document) {
        if (this.isObjectNull(document)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "document"));
        }
        try {
            AlfrescoDocument cmisDoc = (AlfrescoDocument)this.cmisSession.getObject(document.getIdentifier());
            String idpwc = cmisDoc.checkOut().getId();
            return (org.alfresco.mobile.android.api.model.Document)this.session.getServiceRegistry().getDocumentFolderService().getNodeByIdentifier(idpwc);
        }
        catch (Exception e) {
            VersionServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public void cancelCheckout(org.alfresco.mobile.android.api.model.Document document) {
        if (this.isObjectNull(document)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "document"));
        }
        try {
            VersioningService versioningService = this.cmisSession.getBinding().getVersioningService();
            AlfrescoDocument cmisDoc = (AlfrescoDocument)this.cmisSession.getObject(document.getIdentifier());
            String idpwc = cmisDoc.getVersionSeriesCheckedOutId();
            if (idpwc != null) {
                versioningService.cancelCheckOut(this.session.getRepositoryInfo().getIdentifier(), idpwc, null);
            }
        }
        catch (Exception e) {
            VersionServiceImpl.convertException(e);
        }
    }

    @Override
    public org.alfresco.mobile.android.api.model.Document checkin(org.alfresco.mobile.android.api.model.Document document, boolean majorVersion, ContentFile contentFile, Map<String, Serializable> properties, String comment) {
        if (this.isObjectNull(document)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "document"));
        }
        try {
            AlfrescoDocument cmisDoc = (AlfrescoDocument)this.cmisSession.getObject(document.getIdentifier());
            String idpwc = cmisDoc.getVersionSeriesCheckedOutId();
            Document cmisDocpwc = null;
            if (idpwc != null) {
                cmisDocpwc = (Document)this.cmisSession.getObject(idpwc);
                ContentStream c = this.cmisSession.getObjectFactory().createContentStream(contentFile.getFileName(), contentFile.getLength(), contentFile.getMimeType(), IOUtils.getContentFileInputStream(contentFile));
                ObjectId iddoc = cmisDocpwc.checkIn(majorVersion, properties, c, comment);
                return (org.alfresco.mobile.android.api.model.Document)this.session.getServiceRegistry().getDocumentFolderService().getNodeByIdentifier(iddoc.getId());
            }
        }
        catch (Exception e) {
            VersionServiceImpl.convertException(e);
        }
        return null;
    }

    @Override
    public List<org.alfresco.mobile.android.api.model.Document> getCheckedOutDocuments() {
        return this.getCheckedOutDocuments(null).getList();
    }

    @Override
    public PagingResult<org.alfresco.mobile.android.api.model.Document> getCheckedOutDocuments(ListingContext lcontext) {
        try {
            OperationContextImpl ctxt = new OperationContextImpl(this.cmisSession.getDefaultContext());
            String orderBy = AbstractDocumentFolderServiceImpl.getSorting(SORT_PROPERTY_NAME, true);
            BigInteger maxItems = null;
            BigInteger skipCount = null;
            if (lcontext != null) {
                orderBy = AbstractDocumentFolderServiceImpl.getSorting(lcontext.getSortProperty(), lcontext.isSortAscending());
                maxItems = BigInteger.valueOf(lcontext.getMaxItems());
                if (maxItems != null) {
                    ctxt.setMaxItemsPerPage(maxItems.intValue());
                }
                skipCount = BigInteger.valueOf(lcontext.getSkipCount());
            }
            ctxt.setOrderBy(orderBy);
            ItemIterable checkedOutDocs = this.cmisSession.getCheckedOutDocs((OperationContext)ctxt);
            if (skipCount != null) {
                checkedOutDocs = checkedOutDocs.skipTo(skipCount.longValue());
            }
            ArrayList<DocumentImpl> page = new ArrayList<DocumentImpl>();
            for (Document cmisDoc : checkedOutDocs.getPage()) {
                if (cmisDoc == null) continue;
                page.add(new DocumentImpl((CmisObject)cmisDoc));
            }
            Boolean hasMoreItem = false;
            hasMoreItem = maxItems != null ? Boolean.valueOf(checkedOutDocs.getHasMoreItems() && page.size() == maxItems.intValue()) : Boolean.valueOf(checkedOutDocs.getHasMoreItems());
            return new PagingResultImpl<org.alfresco.mobile.android.api.model.Document>(page, hasMoreItem, (int)checkedOutDocs.getTotalNumItems());
        }
        catch (Exception e) {
            VersionServiceImpl.convertException(e);
            return null;
        }
    }

    private PagingResult<org.alfresco.mobile.android.api.model.Document> computeVersion(org.alfresco.mobile.android.api.model.Document document, ListingContext listingContext) {
        if (this.isObjectNull(document)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "document"));
        }
        try {
            VersioningService versioningService = this.cmisSession.getBinding().getVersioningService();
            OperationContext ctxt = this.cmisSession.getDefaultContext();
            ObjectFactory objectFactory = this.cmisSession.getObjectFactory();
            List versions = versioningService.getAllVersions(this.session.getRepositoryInfo().getIdentifier(), document.getIdentifier(), (String)document.getProperty("cmis:versionSeriesId").getValue(), ctxt.getFilterString(), Boolean.valueOf(ctxt.isIncludeAllowableActions()), null);
            int size = versions != null ? versions.size() : 0;
            Boolean hasMoreItems = false;
            if (listingContext != null && versions != null) {
                int fromIndex;
                int n = fromIndex = listingContext.getSkipCount() > size ? size : listingContext.getSkipCount();
                if (listingContext.getMaxItems() + fromIndex >= size) {
                    versions = versions.subList(fromIndex, size);
                    hasMoreItems = false;
                } else {
                    versions = versions.subList(fromIndex, listingContext.getMaxItems() + fromIndex);
                    hasMoreItems = true;
                }
            }
            ArrayList<org.alfresco.mobile.android.api.model.Document> result = new ArrayList<org.alfresco.mobile.android.api.model.Document>();
            if (versions != null) {
                for (ObjectData objectData : versions) {
                    Node doc = this.convertNode(objectFactory.convertObject(objectData, ctxt));
                    if (!(doc instanceof org.alfresco.mobile.android.api.model.Document)) continue;
                    result.add((org.alfresco.mobile.android.api.model.Document)doc);
                }
            }
            if (listingContext != null) {
                Collections.sort(result, new NodeComparator(listingContext.isSortAscending(), listingContext.getSortProperty()));
            }
            return new PagingResultImpl<org.alfresco.mobile.android.api.model.Document>(result, hasMoreItems, size);
        }
        catch (Exception e) {
            VersionServiceImpl.convertException(e);
            return null;
        }
    }

    public VersionServiceImpl(Parcel o) {
        super((AlfrescoSession)o.readParcelable(AlfrescoSession.class.getClassLoader()));
    }
}

