/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.model.Folder;
import org.alfresco.mobile.android.api.model.KeywordSearchOptions;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.SearchLanguage;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.services.SearchService;
import org.alfresco.mobile.android.api.services.impl.AlfrescoService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.impl.AbstractAlfrescoSessionImpl;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.spi.DiscoveryService;

public class SearchServiceImpl
extends AlfrescoService
implements SearchService {
    private Session cmisSession;
    private static final String QUERY_DOCUMENT_TITLED = "SELECT d.* FROM cmis:document as d JOIN cm:titled as t ON d.cmis:objectId = t.cmis:objectId WHERE ";
    private static final String QUERY_DOCUMENT = "SELECT * FROM cmis:document WHERE ";
    private static final String QUERY_FOLDER_TITLED = "SELECT d.* FROM cmis:folder as d JOIN cm:titled as t ON d.cmis:objectId = t.cmis:objectId WHERE ";
    private static final String QUERY_FOLDER = "SELECT * FROM cmis:folder WHERE ";
    private static final String QUERY_DEFAULT = "SELECT * FROM %s WHERE ";
    private static final String PARAM_NODEREF = "{noderef}";
    private static final String QUERY_INFOLDER = " IN_FOLDER('{noderef}')";
    private static final String QUERY_DESCENDANTS = " IN_TREE('{noderef}')";
    private static final String PARAM_NAME = "cmis:name";
    private static final String PARAM_CREATED_AT = " cmis:creationDate ";
    private static final String PARAM_MODIFIED_AT = " cmis:lastModificationDate ";
    private static final String PARAM_TITLE = " t.cm:title ";
    private static final String PARAM_DESCRIPTION = " t.cm:description ";
    private static final String OPERTATOR_OR = " OR ";
    private static final String OPERTATOR_AND = " AND ";
    private static Map<String, String> sortingMap = new HashMap<String, String>(){
        {
            this.put(SearchService.SORT_PROPERTY_NAME, SearchServiceImpl.PARAM_NAME);
            this.put(SearchService.SORT_PROPERTY_TITLE, SearchServiceImpl.PARAM_TITLE);
            this.put(SearchService.SORT_PROPERTY_DESCRIPTION, SearchServiceImpl.PARAM_DESCRIPTION);
            this.put(SearchService.SORT_PROPERTY_CREATED_AT, SearchServiceImpl.PARAM_CREATED_AT);
            this.put(SearchService.SORT_PROPERTY_MODIFIED_AT, SearchServiceImpl.PARAM_MODIFIED_AT);
        }
    };
    public static final Parcelable.Creator<SearchServiceImpl> CREATOR = new Parcelable.Creator<SearchServiceImpl>(){

        public SearchServiceImpl createFromParcel(Parcel in) {
            return new SearchServiceImpl(in);
        }

        public SearchServiceImpl[] newArray(int size) {
            return new SearchServiceImpl[size];
        }
    };

    public SearchServiceImpl(AlfrescoSession repositorySession) {
        super(repositorySession);
        this.cmisSession = ((AbstractAlfrescoSessionImpl)repositorySession).getCmisSession();
    }

    @Override
    public List<Node> search(String statement, SearchLanguage language) {
        return this.search(statement, language, null).getList();
    }

    @Override
    public List<Node> keywordSearch(String keywords, KeywordSearchOptions options) {
        if (this.isStringNull(keywords)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "keywords"));
        }
        KeywordSearchOptions tmpOptions = options;
        if (tmpOptions == null) {
            tmpOptions = new KeywordSearchOptions();
        }
        return this.keywordSearch(keywords, tmpOptions, null).getList();
    }

    @Override
    public PagingResult<Node> keywordSearch(String keywords, KeywordSearchOptions options, ListingContext listingContext) {
        String statement = SearchServiceImpl.createQuery(keywords, options.getTypeName(), options.doesIncludeContent(), options.isExactMatch(), options.getFolder(), options.doesIncludeDescendants(), listingContext);
        return this.search(statement, SearchLanguage.CMIS, listingContext);
    }

    @Override
    public PagingResult<Node> search(String statement, SearchLanguage language, ListingContext listingContext) {
        if (this.isStringNull(statement)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "statement"));
        }
        if (this.isObjectNull((Object)language)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "language"));
        }
        try {
            DiscoveryService discoveryService = this.cmisSession.getBinding().getDiscoveryService();
            OperationContext ctxt = this.cmisSession.getDefaultContext();
            ObjectFactory objectFactory = this.cmisSession.getObjectFactory();
            BigInteger maxItems = BigInteger.valueOf(50L);
            BigInteger skipCount = BigInteger.valueOf(0L);
            String tmpStatement = statement;
            if (listingContext != null) {
                skipCount = BigInteger.valueOf(listingContext.getSkipCount());
                maxItems = BigInteger.valueOf(listingContext.getMaxItems());
                tmpStatement = tmpStatement + this.getSorting(listingContext.getSortProperty(), listingContext.isSortAscending());
            }
            ObjectList resultList = discoveryService.query(this.session.getRepositoryInfo().getIdentifier(), tmpStatement, Boolean.valueOf(false), Boolean.valueOf(ctxt.isIncludeAllowableActions()), ctxt.getIncludeRelationships(), ctxt.getRenditionFilterString(), maxItems, skipCount, null);
            ArrayList<Node> page = new ArrayList<Node>();
            if (resultList.getObjects() != null) {
                for (ObjectData objectData : resultList.getObjects()) {
                    if (objectData == null) continue;
                    page.add(this.convertNode(objectFactory.convertObject(objectData, ctxt), false));
                }
                return new PagingResultImpl<Node>(page, resultList.hasMoreItems(), resultList.getNumItems() == null ? -1 : resultList.getNumItems().intValue());
            }
            return new PagingResultImpl<Node>(page, false, -1);
        }
        catch (Exception e) {
            SearchServiceImpl.convertException(e);
            return null;
        }
    }

    private static String createQuery(String query, String typeName, boolean fulltext, boolean isExact, Folder f, boolean descendants, ListingContext listingContext) {
        List<String> keywords = Arrays.asList(TextUtils.split((String)query.trim(), (String)"\\s+"));
        boolean hasAspect = false;
        if (listingContext != null && listingContext.getSortProperty() != null && (SORT_PROPERTY_TITLE.equals(listingContext.getSortProperty()) || SORT_PROPERTY_DESCRIPTION.equals(listingContext.getSortProperty()))) {
            hasAspect = true;
        }
        String startStatement = QUERY_DOCUMENT;
        if ("cmis:document".equals(typeName)) {
            startStatement = QUERY_DOCUMENT;
            if (hasAspect) {
                startStatement = QUERY_DOCUMENT_TITLED;
            }
        } else if ("cmis:folder".equals(typeName)) {
            startStatement = QUERY_FOLDER;
            if (hasAspect) {
                startStatement = QUERY_FOLDER_TITLED;
            }
        } else {
            startStatement = String.format(QUERY_DEFAULT, typeName);
        }
        StringBuilder sb = new StringBuilder(startStatement);
        if (f != null) {
            if (descendants) {
                sb.append(QUERY_DESCENDANTS.replace(PARAM_NODEREF, f.getIdentifier()));
            } else {
                sb.append(QUERY_INFOLDER.replace(PARAM_NODEREF, f.getIdentifier()));
            }
            sb.append(OPERTATOR_AND);
            sb.append("(");
        }
        String keywordsValue = "";
        for (String word : keywords) {
            if (word == null || word.isEmpty()) continue;
            keywordsValue = keywordsValue + " " + word;
        }
        if ((keywordsValue = keywordsValue.trim()) != null && keywordsValue.length() > 0) {
            if (isExact) {
                sb.append("cmis:name= '" + keywordsValue + "'" + OPERTATOR_OR + " UPPER(" + PARAM_NAME + ") = '" + keywordsValue.toUpperCase() + "'" + OPERTATOR_OR + " CONTAINS('" + PARAM_NAME + ":\\'" + keywordsValue + "\\'')");
            } else {
                sb.append("CONTAINS('~cmis:name:\\'" + keywordsValue + "\\'')");
            }
            if (fulltext) {
                sb.append(OPERTATOR_OR);
                sb.append("contains ('" + keywordsValue + "')");
            }
        }
        if (f != null) {
            sb.append(")");
        }
        return sb.toString();
    }

    private String getSorting(String sortingKey, boolean modifier) {
        if (!sortingMap.containsKey(sortingKey)) {
            return "";
        }
        String s = sortingMap.get(sortingKey);
        s = modifier ? s + " ASC" : s + " DESC";
        return " ORDER BY " + s;
    }

    public SearchServiceImpl(Parcel o) {
        super((AlfrescoSession)o.readParcelable(AlfrescoSession.class.getClassLoader()));
    }
}

