/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.exceptions.AlfrescoServiceException;
import org.alfresco.mobile.android.api.exceptions.impl.ExceptionHelper;
import org.alfresco.mobile.android.api.model.ContentFile;
import org.alfresco.mobile.android.api.model.ContentStream;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.model.impl.ContentFileImpl;
import org.alfresco.mobile.android.api.model.impl.DocumentImpl;
import org.alfresco.mobile.android.api.model.impl.FolderImpl;
import org.alfresco.mobile.android.api.services.Service;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.CloudSession;
import org.alfresco.mobile.android.api.session.RepositorySession;
import org.alfresco.mobile.android.api.session.impl.AbstractAlfrescoSessionImpl;
import org.alfresco.mobile.android.api.utils.IOUtils;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.impl.SessionImpl;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.http.HttpInvoker;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

public abstract class AlfrescoService
implements Service {
    protected AlfrescoSession session;
    private BindingSession bindingSession;
    protected static final int RENDITION_CACHE = 1;
    protected static final int CONTENT_CACHE = 2;

    public AlfrescoService() {
    }

    public AlfrescoService(AlfrescoSession repositorySession) {
        this.session = repositorySession;
        this.bindingSession = new SessionImpl();
        this.bindingSession.put("org.apache.chemistry.opencmis.binding.auth.object", (Serializable)((AbstractAlfrescoSessionImpl)this.session).getPassthruAuthenticationProvider());
        this.bindingSession.put("org.apache.chemistry.opencmis.binding.httpinvoker.classname", repositorySession.getParameter("org.alfresco.mobile.api.httpinvoker.classname"));
    }

    protected Response read(UrlBuilder url, int errorCode) {
        Response resp = this.getHttpInvoker().invokeGET(url, this.getSessionHttp());
        if (resp.getResponseCode() != 200) {
            this.convertStatusCode(resp, errorCode);
        }
        return resp;
    }

    protected Response post(UrlBuilder url, String contentType, Output writer, int errorCode) {
        Response resp = this.getHttpInvoker().invokePOST(url, contentType, writer, this.getSessionHttp());
        if (resp.getResponseCode() != 200 && resp.getResponseCode() != 201) {
            this.convertStatusCode(resp, errorCode);
        }
        return resp;
    }

    protected void delete(UrlBuilder url, int errorCode) {
        Response resp = this.getHttpInvoker().invokeDELETE(url, this.getSessionHttp());
        if (resp.getResponseCode() != 204 && resp.getResponseCode() != 200) {
            this.convertStatusCode(resp, errorCode);
        }
    }

    protected Response put(UrlBuilder url, String contentType, Map<String, String> headers, Output writer, int errorCode) {
        Response resp = this.getHttpInvoker().invokePUT(url, contentType, headers, writer, this.getSessionHttp());
        if (resp.getResponseCode() < 200 || resp.getResponseCode() > 299) {
            this.convertStatusCode(resp, errorCode);
        }
        return resp;
    }

    protected BindingSession getSessionHttp() {
        if (this.bindingSession == null) {
            this.bindingSession = new SessionImpl();
            this.bindingSession.put("org.apache.chemistry.opencmis.binding.auth.object", (Serializable)((AbstractAlfrescoSessionImpl)this.session).getPassthruAuthenticationProvider());
            this.bindingSession.put("org.apache.chemistry.opencmis.binding.httpinvoker.classname", ((AbstractAlfrescoSessionImpl)this.session).getParameter("org.alfresco.mobile.api.httpinvoker.classname"));
        } else if (this.bindingSession != null && this.bindingSession.get("org.apache.chemistry.opencmis.binding.auth.object") == null) {
            this.bindingSession.put("org.apache.chemistry.opencmis.binding.auth.object", (Serializable)((AbstractAlfrescoSessionImpl)this.session).getPassthruAuthenticationProvider());
        }
        return this.bindingSession;
    }

    protected HttpInvoker getHttpInvoker() {
        return CmisBindingsHelper.getHttpInvoker((BindingSession)this.bindingSession);
    }

    protected Node convertNode(CmisObject object) {
        return this.convertNode(object, true);
    }

    protected Node convertNode(CmisObject object, boolean hasAllProperties) {
        if (this.isObjectNull(object)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "object"));
        }
        switch (object.getBaseTypeId()) {
            case CMIS_DOCUMENT: {
                return new DocumentImpl(object, hasAllProperties);
            }
            case CMIS_FOLDER: {
                return new FolderImpl(object, hasAllProperties);
            }
        }
        throw new AlfrescoServiceException(602, Messagesl18n.getString("AlfrescoService.2") + object.getBaseTypeId());
    }

    protected boolean isObjectNull(Object o) {
        return o == null;
    }

    protected boolean isStringNull(String s) {
        return s == null || s.length() == 0 || s.trim().length() == 0;
    }

    protected boolean isListNull(List l) {
        return l == null || l.isEmpty();
    }

    protected boolean isMapNull(Map m) {
        return m == null || m.isEmpty();
    }

    protected boolean isOnPremiseSession() {
        return this.session instanceof RepositorySession;
    }

    protected boolean isCloudSession() {
        return this.session instanceof CloudSession;
    }

    protected static void convertException(Exception t) {
        ExceptionHelper.convertException(t);
    }

    public void convertStatusCode(Response resp, int serviceErrorCode) {
        ExceptionHelper.convertStatusCode(this.session, resp, serviceErrorCode);
    }

    protected ContentFile saveContentStream(ContentStream contentStream, String cacheFileName, int storageType) {
        if (contentStream == null || contentStream.getInputStream() == null) {
            return null;
        }
        try {
            String folderName = (String)((Object)this.session.getParameter("org.alfresco.mobile.cache.folder"));
            switch (storageType) {
                case 1: {
                    folderName = folderName + "/rendition";
                    break;
                }
                case 2: {
                    folderName = folderName + "/content";
                    break;
                }
            }
            File f = new File(folderName, cacheFileName);
            IOUtils.ensureOrCreatePathAndFile(f);
            IOUtils.copyFile(contentStream.getInputStream(), f);
            return new ContentFileImpl(f, contentStream.getFileName(), contentStream.getMimeType());
        }
        catch (Exception e) {
            AlfrescoService.convertException(e);
            return null;
        }
    }

    @Override
    public void clear() {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int arg1) {
        dest.writeParcelable((Parcelable)this.session, 1);
    }
}

