/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl;

import java.util.List;
import org.alfresco.mobile.android.api.model.Document;
import org.alfresco.mobile.android.api.model.Process;
import org.alfresco.mobile.android.api.model.ProcessDefinition;
import org.alfresco.mobile.android.api.model.Task;
import org.alfresco.mobile.android.api.services.WorkflowService;
import org.alfresco.mobile.android.api.services.impl.AlfrescoService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

public abstract class AbstractWorkflowService
extends AlfrescoService
implements WorkflowService {
    public AbstractWorkflowService(AlfrescoSession repositorySession) {
        super(repositorySession);
    }

    @Override
    public List<ProcessDefinition> getProcessDefinitions() {
        return this.getProcessDefinitions(null).getList();
    }

    @Override
    public ProcessDefinition getProcessDefinitionByKey(String processDefinitionKey) {
        if (this.isStringNull(processDefinitionKey)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "processDefinitionKey"));
        }
        ProcessDefinition def = null;
        try {
            List<ProcessDefinition> definitions = this.getProcessDefinitions();
            for (ProcessDefinition processDefinition : definitions) {
                if (!processDefinitionKey.equals(processDefinition.getKey())) continue;
                def = processDefinition;
                break;
            }
        }
        catch (Exception e) {
            AbstractWorkflowService.convertException(e);
        }
        return def;
    }

    protected abstract UrlBuilder getProcessUrl(Process var1);

    @Override
    public void deleteProcess(Process process) {
        if (this.isObjectNull(process)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "process"));
        }
        try {
            this.delete(this.getProcessUrl(process), 1100);
        }
        catch (Exception e) {
            AbstractWorkflowService.convertException(e);
        }
    }

    @Override
    public List<Process> getProcesses() {
        return this.getProcesses(null).getList();
    }

    @Override
    public List<Task> getTasks(Process process) {
        return this.getTasks(process, null).getList();
    }

    public abstract UrlBuilder getProcessDiagramUrl(String var1);

    @Override
    public List<Document> getDocuments(Task task) {
        return this.getDocuments(task, null).getList();
    }

    @Override
    public List<Document> getDocuments(Process process) {
        return this.getDocuments(process, null).getList();
    }

    @Override
    public List<Task> getTasks() {
        return this.getTasks(null).getList();
    }

    protected static String encodeKey(String key) {
        return key.replace(":", "_");
    }

    protected static String decodeKey(String key) {
        return key.replace("_", ":");
    }
}

