/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl;

import android.util.LruCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.exceptions.AlfrescoServiceException;
import org.alfresco.mobile.android.api.model.Folder;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.Site;
import org.alfresco.mobile.android.api.model.impl.JoinSiteRequestImpl;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.model.impl.SiteImpl;
import org.alfresco.mobile.android.api.services.SiteService;
import org.alfresco.mobile.android.api.services.cache.impl.CacheSiteExtraProperties;
import org.alfresco.mobile.android.api.services.impl.AlfrescoService;
import org.alfresco.mobile.android.api.services.impl.publicapi.PublicAPISiteServiceImpl;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.CloudSession;
import org.alfresco.mobile.android.api.utils.AlphaComparator;
import org.alfresco.mobile.android.api.utils.JsonUtils;
import org.alfresco.mobile.android.api.utils.OnPremiseUrlRegistry;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

public abstract class AbstractSiteServiceImpl
extends AlfrescoService
implements SiteService {
    protected static final String DEFAULT_ROLE = "SiteConsumer";
    private static final int MAX_CACHE_ITEMS = 1000;
    protected LruCache<String, CacheSiteExtraProperties> extraPropertiesCache = new LruCache<String, CacheSiteExtraProperties>(1000){

        protected int sizeOf(String key, CacheSiteExtraProperties value) {
            return 1;
        }
    };

    public AbstractSiteServiceImpl(AlfrescoSession repositorySession) {
        super(repositorySession);
    }

    @Override
    public List<Site> getAllSites() {
        return this.getAllSites(null).getList();
    }

    protected abstract UrlBuilder getAllSitesUrl(ListingContext var1);

    @Override
    public PagingResult<Site> getAllSites(ListingContext listingContext) {
        try {
            this.initExtraPropertiesCache();
            return this.computeAllSites(this.getAllSitesUrl(listingContext), listingContext);
        }
        catch (Exception e) {
            AbstractSiteServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public List<Site> getSites() {
        return this.getSites(null).getList();
    }

    protected abstract UrlBuilder getUserSitesUrl(String var1, ListingContext var2);

    @Override
    public PagingResult<Site> getSites(ListingContext listingContext) {
        try {
            this.initExtraPropertiesCache();
            return this.computeSites(this.getUserSitesUrl(this.session.getPersonIdentifier(), listingContext), listingContext);
        }
        catch (Exception e) {
            AbstractSiteServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public List<Site> getFavoriteSites() {
        return this.getFavoriteSites(null).getList();
    }

    @Override
    public PagingResult<Site> getFavoriteSites(ListingContext listingContext) {
        try {
            this.initExtraPropertiesCache();
            return this.computeFavoriteSites(listingContext);
        }
        catch (Exception e) {
            AbstractSiteServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public List<Site> search(String keyword) {
        return this.search(keyword, null).getList();
    }

    @Override
    public PagingResult<Site> search(String keyword, ListingContext listingContext) {
        if (this.session instanceof CloudSession) {
            throw new UnsupportedOperationException("This operation is not supported with Cloud Session");
        }
        try {
            this.initExtraPropertiesCache();
            String link = OnPremiseUrlRegistry.getAllSitesUrl(this.session);
            UrlBuilder builder = new UrlBuilder(link);
            builder.addParameter("nf", (Object)keyword);
            if (this instanceof PublicAPISiteServiceImpl) {
                return this.computeLegacySites(builder, listingContext);
            }
            return this.computeSites(builder, listingContext);
        }
        catch (Exception e) {
            AbstractSiteServiceImpl.convertException(e);
            return null;
        }
    }

    protected abstract UrlBuilder getSiteUrl(String var1);

    protected abstract Site parseData(String var1, Map<String, Object> var2);

    @Override
    public Site getSite(String siteIdentifier) {
        if (this.isStringNull(siteIdentifier)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "siteIdentifier"));
        }
        try {
            this.initExtraPropertiesCache();
            UrlBuilder url = this.getSiteUrl(siteIdentifier);
            Response resp = this.getHttpInvoker().invokeGET(url, this.getSessionHttp());
            if (resp.getResponseCode() == 404) {
                return null;
            }
            if (resp.getResponseCode() != 200) {
                this.convertStatusCode(resp, 400);
            }
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            return this.parseData(siteIdentifier, json);
        }
        catch (Exception e) {
            AbstractSiteServiceImpl.convertException(e);
            return null;
        }
    }

    protected abstract String getDocContainerSiteUrl(Site var1);

    @Override
    public Folder getDocumentLibrary(Site site) {
        if (this.isObjectNull(site)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "siteIdentifier"));
        }
        if (this.isStringNull(site.getShortName())) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "siteIdentifier"));
        }
        try {
            String ref = this.parseContainer(this.getDocContainerSiteUrl(site));
            if (this.isStringNull(ref)) {
                return null;
            }
            return (Folder)this.session.getServiceRegistry().getDocumentFolderService().getNodeByIdentifier(ref);
        }
        catch (AlfrescoServiceException er) {
            if (er.getMessage() != null && er.getAlfrescoErrorContent() != null && er.getMessage().contains("The entity with id") && er.getMessage().contains("was not found")) {
                return null;
            }
            if (er.getMessage() != null && er.getAlfrescoErrorContent() != null && er.getMessage().contains("\"containerId\" is not defined")) {
                return null;
            }
            throw er;
        }
        catch (Exception e) {
            AbstractSiteServiceImpl.convertException(e);
            return null;
        }
    }

    protected abstract String getCancelJoinSiteRequestUrl(JoinSiteRequestImpl var1);

    public void cancelJoinSiteRequest(JoinSiteRequestImpl joinSiteRequest) {
        if (this.isObjectNull(joinSiteRequest)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "site"));
        }
        try {
            String link = this.getCancelJoinSiteRequestUrl(joinSiteRequest);
            this.delete(new UrlBuilder(link), 400);
        }
        catch (Exception e) {
            AbstractSiteServiceImpl.convertException(e);
        }
    }

    @Override
    public Site cancelRequestToJoinSite(Site site) {
        if (this.isObjectNull(site)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "site"));
        }
        SiteImpl updatedSite = null;
        try {
            List<JoinSiteRequestImpl> requests = this.getJoinSiteRequests();
            JoinSiteRequestImpl joinSiteRequest = null;
            for (JoinSiteRequestImpl request : requests) {
                if (!site.getShortName().equals(request.getSiteShortName())) continue;
                joinSiteRequest = request;
                break;
            }
            if (this.isObjectNull(joinSiteRequest)) {
                throw new AlfrescoServiceException(400, Messagesl18n.getString("ErrorCodeRegistry.SITE_NOT_JOINED.parsing"));
            }
            String link = this.getCancelJoinSiteRequestUrl(joinSiteRequest);
            this.delete(new UrlBuilder(link), 400);
            updatedSite = new SiteImpl(site, false, false, site.isFavorite());
            this.validateUpdateSite(updatedSite, 400);
        }
        catch (Exception e) {
            AbstractSiteServiceImpl.convertException(e);
        }
        return updatedSite;
    }

    protected abstract String getLeaveSiteUrl(Site var1);

    @Override
    public Site leaveSite(Site site) {
        if (this.isObjectNull(site)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "site"));
        }
        SiteImpl updatedSite = null;
        try {
            String link = this.getLeaveSiteUrl(site);
            this.delete(new UrlBuilder(link), 400);
            this.updateExtraPropertyCache(site.getShortName(), false, false, site.isFavorite());
            updatedSite = new SiteImpl(site, false, false, site.isFavorite());
            this.validateUpdateSite(updatedSite, 400);
        }
        catch (Exception e) {
            if (this.session instanceof CloudSession ? e.getMessage().contains("Permission was denied") : e.getMessage().contains("one site manager") || e.getMessage().contains("remove last manager")) {
                throw new AlfrescoServiceException(404, Messagesl18n.getString("ErrorCodeRegistry.SITE_LAST_MANAGER"));
            }
            AbstractSiteServiceImpl.convertException(e);
        }
        return updatedSite;
    }

    protected abstract List<JoinSiteRequestImpl> getJoinSiteRequests();

    protected abstract PagingResult<JoinSiteRequestImpl> getJoinSiteRequests(ListingContext var1);

    @Override
    public List<Site> getPendingSites() {
        return this.getPendingSites(null).getList();
    }

    @Override
    public PagingResult<Site> getPendingSites(ListingContext listingContext) {
        ArrayList<Site> pendingList = new ArrayList<Site>();
        int size = 0;
        boolean hasMoreItem = false;
        try {
            PagingResult<JoinSiteRequestImpl> requestList = this.getJoinSiteRequests(listingContext);
            hasMoreItem = requestList.hasMoreItems();
            size = requestList.getTotalItems();
            for (JoinSiteRequestImpl request : requestList.getList()) {
                pendingList.add(this.getSite(request.getSiteShortName()));
            }
        }
        catch (Exception e) {
            AbstractSiteServiceImpl.convertException(e);
        }
        return new PagingResultImpl<Site>(pendingList, hasMoreItem, size);
    }

    protected void validateUpdateSite(Site updatedSite, int errorCode) {
        if (this.isObjectNull(updatedSite)) {
            throw new AlfrescoServiceException(errorCode, Messagesl18n.getString("ErrorCodeRegistry.SITE_NOT_JOINED.parsing"));
        }
    }

    protected void updateExtraPropertyCache(String siteIdentifier, boolean isPendingMember, boolean isMember, boolean isFavorite) {
        CacheSiteExtraProperties properties = (CacheSiteExtraProperties)this.extraPropertiesCache.get((Object)siteIdentifier);
        if (properties != null) {
            properties.isPendingMember = isPendingMember;
            properties.isMember = isMember;
            properties.isFavorite = isFavorite;
        } else {
            properties = new CacheSiteExtraProperties(isPendingMember, isMember, isFavorite);
        }
        this.extraPropertiesCache.put((Object)siteIdentifier, (Object)properties);
    }

    @Override
    public void clear() {
        if (this.extraPropertiesCache == null) {
            this.extraPropertiesCache = new LruCache<String, CacheSiteExtraProperties>(1000){

                protected int sizeOf(String key, CacheSiteExtraProperties value) {
                    return 1;
                }
            };
        }
        this.extraPropertiesCache.evictAll();
    }

    private void initExtraPropertiesCache() {
        if (this.extraPropertiesCache != null && this.extraPropertiesCache.size() == 0) {
            this.retrieveExtraProperties(this.session.getPersonIdentifier());
        }
    }

    protected abstract void retrieveExtraProperties(String var1);

    protected void retrieveExtraProperties(List<String> favoriteSites, List<String> userSites, List<JoinSiteRequestImpl> request) {
        boolean isFavorite = false;
        ArrayList<String> tmpFavoriteSite = new ArrayList<String>();
        tmpFavoriteSite.addAll(favoriteSites);
        for (JoinSiteRequestImpl joinSiteRequest : request) {
            isFavorite = favoriteSites.contains(joinSiteRequest.getIdentifier());
            this.extraPropertiesCache.put((Object)joinSiteRequest.getSiteShortName(), (Object)new CacheSiteExtraProperties(true, false, isFavorite));
            if (!isFavorite) continue;
            favoriteSites.remove(joinSiteRequest.getSiteShortName());
        }
        for (String siteIdentifier : userSites) {
            isFavorite = favoriteSites.contains(siteIdentifier);
            this.extraPropertiesCache.put((Object)siteIdentifier, (Object)new CacheSiteExtraProperties(false, true, isFavorite));
            if (!isFavorite) continue;
            favoriteSites.remove(siteIdentifier);
        }
        for (String favoriteSite : favoriteSites) {
            this.extraPropertiesCache.put((Object)favoriteSite, (Object)new CacheSiteExtraProperties(false, false, true));
        }
    }

    public Site refresh(Site site) {
        CacheSiteExtraProperties cacheProperty = (CacheSiteExtraProperties)this.extraPropertiesCache.get((Object)site.getIdentifier());
        return cacheProperty == null ? site : new SiteImpl(site, cacheProperty.isPendingMember, cacheProperty.isMember, cacheProperty.isFavorite);
    }

    protected abstract PagingResult<Site> computeFavoriteSites(ListingContext var1);

    protected abstract PagingResult<Site> computeSites(UrlBuilder var1, ListingContext var2);

    protected abstract PagingResult<Site> computeAllSites(UrlBuilder var1, ListingContext var2);

    protected abstract String parseContainer(String var1);

    protected PagingResult<Site> computeLegacySites(UrlBuilder url, ListingContext listingContext) {
        Response resp = this.read(url, 400);
        List<Object> json = JsonUtils.parseArray(resp.getStream(), resp.getCharset());
        int size = json.size();
        ArrayList<SiteImpl> result = new ArrayList<SiteImpl>();
        int fromIndex = 0;
        int toIndex = size;
        Boolean hasMoreItems = false;
        if (listingContext != null) {
            int n = fromIndex = listingContext.getSkipCount() > size ? size : listingContext.getSkipCount();
            if (listingContext.getMaxItems() + fromIndex >= size) {
                toIndex = size;
                hasMoreItems = false;
            } else {
                toIndex = listingContext.getMaxItems() + fromIndex;
                hasMoreItems = true;
            }
        } else {
            listingContext = new ListingContext();
            listingContext.setSortProperty(SORT_PROPERTY_TITLE);
        }
        String siteName = null;
        Map mapProperties = null;
        CacheSiteExtraProperties extraProperties = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            mapProperties = (Map)json.get(i);
            if (mapProperties == null) continue;
            siteName = JSONConverter.getString((Map)mapProperties, (String)"shortName");
            if (this.extraPropertiesCache.get((Object)siteName) != null) {
                extraProperties = (CacheSiteExtraProperties)this.extraPropertiesCache.get((Object)siteName);
                mapProperties.put("isPendingMember", extraProperties.isPendingMember);
                mapProperties.put("isMember", extraProperties.isMember);
                mapProperties.put("isFavorite", extraProperties.isFavorite);
            }
            result.add(SiteImpl.parseCompatJson((Map)json.get(i)));
        }
        if (listingContext != null) {
            Collections.sort(result, new AlphaComparator(listingContext.isSortAscending(), listingContext.getSortProperty()));
        }
        return new PagingResultImpl<Site>(result, hasMoreItems, size);
    }
}

