/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl;

import java.io.IOException;
import java.io.OutputStream;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.services.RatingService;
import org.alfresco.mobile.android.api.services.impl.AlfrescoService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.utils.JsonDataWriter;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;

public abstract class AbstractRatingsService
extends AlfrescoService
implements RatingService {
    public AbstractRatingsService(AlfrescoSession repositorySession) {
        super(repositorySession);
    }

    protected abstract UrlBuilder getRatingsUrl(Node var1);

    protected abstract JSONObject getRatingsObject();

    @Override
    public void like(Node node) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        try {
            UrlBuilder url = this.getRatingsUrl(node);
            final JsonDataWriter formData = new JsonDataWriter(this.getRatingsObject());
            this.post(url, formData.getContentType(), new Output(){

                public void write(OutputStream out) throws IOException {
                    formData.write(out);
                }
            }, 1000);
        }
        catch (Exception e) {
            AbstractRatingsService.convertException(e);
        }
    }

    protected abstract UrlBuilder getUnlikeUrl(Node var1);

    @Override
    public void unlike(Node node) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        try {
            this.delete(this.getUnlikeUrl(node), 1000);
        }
        catch (Exception e) {
            AbstractRatingsService.convertException(e);
        }
    }

    @Override
    public int getLikeCount(Node node) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        try {
            return this.computeRatingsCount(this.getRatingsUrl(node));
        }
        catch (Exception e) {
            AbstractRatingsService.convertException(e);
            return -1;
        }
    }

    @Override
    public boolean isLiked(Node node) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        try {
            return this.computeIsRated(this.getRatingsUrl(node));
        }
        catch (Exception e) {
            AbstractRatingsService.convertException(e);
            return false;
        }
    }

    protected abstract int computeRatingsCount(UrlBuilder var1);

    protected abstract boolean computeIsRated(UrlBuilder var1);
}

