/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl;

import org.alfresco.mobile.android.api.model.ContentFile;
import org.alfresco.mobile.android.api.model.ContentStream;
import org.alfresco.mobile.android.api.model.Person;
import org.alfresco.mobile.android.api.services.PersonService;
import org.alfresco.mobile.android.api.services.impl.AlfrescoService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

public abstract class AbstractPersonService
extends AlfrescoService
implements PersonService {
    public AbstractPersonService(AlfrescoSession repositorySession) {
        super(repositorySession);
    }

    protected abstract UrlBuilder getPersonDetailssUrl(String var1);

    @Override
    public Person getPerson(String personIdentifier) {
        if (this.isStringNull(personIdentifier)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "personIdentifier"));
        }
        try {
            return this.computePerson(this.getPersonDetailssUrl(personIdentifier));
        }
        catch (Exception e) {
            AbstractPersonService.convertException(e);
            return null;
        }
    }

    public abstract UrlBuilder getAvatarUrl(String var1);

    public ContentStream getAvatarStream(String personIdentifier) {
        return null;
    }

    public ContentFile getAvatar(String personIdentifier) {
        if (this.isStringNull(personIdentifier)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "personIdentifier"));
        }
        return this.saveContentStream(this.getAvatarStream(personIdentifier), personIdentifier, 1);
    }

    @Override
    public ContentFile getAvatar(Person person) {
        if (this.isObjectNull(person) || this.isStringNull(person.getIdentifier())) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "person"));
        }
        return this.saveContentStream(this.getAvatarStream(person.getIdentifier()), person.getIdentifier(), 1);
    }

    protected abstract Person computePerson(UrlBuilder var1);
}

