/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl;

import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.mobile.android.api.constants.ContentModel;
import org.alfresco.mobile.android.api.model.Document;
import org.alfresco.mobile.android.api.model.Folder;
import org.alfresco.mobile.android.api.model.ModelDefinition;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.model.NodeTypeDefinition;
import org.alfresco.mobile.android.api.model.Task;
import org.alfresco.mobile.android.api.model.TaskTypeDefinition;
import org.alfresco.mobile.android.api.model.impl.AspectDefinitionImpl;
import org.alfresco.mobile.android.api.model.impl.DocumentTypeDefinitionImpl;
import org.alfresco.mobile.android.api.model.impl.FolderTypeDefinitionImpl;
import org.alfresco.mobile.android.api.model.impl.NodeTypeDefinitionImpl;
import org.alfresco.mobile.android.api.model.impl.TaskTypeDefinitionImpl;
import org.alfresco.mobile.android.api.services.ModelDefinitionService;
import org.alfresco.mobile.android.api.services.impl.AlfrescoService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.impl.AbstractAlfrescoSessionImpl;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;

public abstract class AbstractModelDefinitionService
extends AlfrescoService
implements ModelDefinitionService {
    private static final int DOCUMENT = 0;
    private static final int FOLDER = 1;
    private static final int ASPECT = 2;
    private static final int TASK = 3;
    private static final String TAG = AbstractModelDefinitionService.class.getSimpleName();
    protected Session cmisSession;
    private static final Map<String, String> BASETYPE_INDEX = new HashMap<String, String>();

    public AbstractModelDefinitionService(AlfrescoSession repositorySession) {
        super(repositorySession);
        this.cmisSession = ((AbstractAlfrescoSessionImpl)repositorySession).getCmisSession();
    }

    @Override
    public NodeTypeDefinition getDocumentTypeDefinition(String type) {
        return (NodeTypeDefinition)this.getTypeDefinition(0, type);
    }

    @Override
    public NodeTypeDefinition getDocumentTypeDefinition(Document doc) {
        return this.getNodeTypeDefinition(doc);
    }

    @Override
    public ModelDefinition getAspectDefinition(String aspect) {
        return this.getTypeDefinition(2, aspect);
    }

    @Override
    public NodeTypeDefinition getFolderTypeDefinition(String type) {
        return (NodeTypeDefinition)this.getTypeDefinition(1, type);
    }

    @Override
    public NodeTypeDefinition getFolderTypeDefinition(Folder folder) {
        return this.getNodeTypeDefinition(folder);
    }

    @Override
    public TaskTypeDefinition getTaskTypeDefinition(String type) {
        return (TaskTypeDefinition)this.getTypeDefinition(3, type);
    }

    @Override
    public TaskTypeDefinition getTaskTypeDefinition(Task task) {
        return (TaskTypeDefinition)this.getTypeDefinition(3, task.getKey());
    }

    protected ModelDefinition getTypeDefinition(int modelId, String typeId) {
        String type = typeId;
        if (BASETYPE_INDEX.containsKey(type)) {
            type = BASETYPE_INDEX.get(type);
        } else {
            switch (modelId) {
                case 0: {
                    type = "D:".concat(type);
                    break;
                }
                case 1: {
                    type = "F:".concat(type);
                    break;
                }
                case 3: {
                    type = "D:".concat(type);
                    break;
                }
                case 2: {
                    type = "P:".concat(type);
                    return new AspectDefinitionImpl(this.cmisSession.getTypeDefinition(type));
                }
            }
        }
        ObjectType typeDefinition = this.cmisSession.getTypeDefinition(type);
        HashMap<String, AspectDefinitionImpl> aspectModels = null;
        for (CmisExtensionElement extension : typeDefinition.getExtensions()) {
            if (!"mandatoryAspects".equals(extension.getName())) continue;
            aspectModels = new HashMap<String, AspectDefinitionImpl>(extension.getChildren().size());
            for (CmisExtensionElement aspectExtension : extension.getChildren()) {
                aspectModels.put(aspectExtension.getValue(), new AspectDefinitionImpl(this.cmisSession.getTypeDefinition(aspectExtension.getValue())));
            }
        }
        switch (modelId) {
            case 0: {
                return new DocumentTypeDefinitionImpl(this.cmisSession.getTypeDefinition(type), aspectModels);
            }
            case 1: {
                return new FolderTypeDefinitionImpl(this.cmisSession.getTypeDefinition(type), aspectModels);
            }
            case 3: {
                return new TaskTypeDefinitionImpl(this.cmisSession.getTypeDefinition(type), aspectModels);
            }
        }
        return null;
    }

    private NodeTypeDefinition getNodeTypeDefinition(Node node) {
        String type = node.getType();
        type = BASETYPE_INDEX.containsKey(type) ? BASETYPE_INDEX.get(type) : (node.isDocument() ? "D:".concat(type) : "F:".concat(type));
        HashMap<String, ModelDefinition> aspectModels = new HashMap<String, ModelDefinition>(node.getAspects().size());
        for (String aspectName : node.getAspects()) {
            try {
                aspectModels.put(aspectName, new AspectDefinitionImpl(this.cmisSession.getTypeDefinition("P:".concat(aspectName))));
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)(aspectName + " is unknown by the ModelDefinitionService"));
            }
        }
        return new NodeTypeDefinitionImpl(this.cmisSession.getTypeDefinition(type), aspectModels);
    }

    static {
        BASETYPE_INDEX.put(BaseTypeId.CMIS_DOCUMENT.value(), BaseTypeId.CMIS_DOCUMENT.value());
        BASETYPE_INDEX.put(BaseTypeId.CMIS_FOLDER.value(), BaseTypeId.CMIS_FOLDER.value());
        BASETYPE_INDEX.put(ContentModel.TYPE_CONTENT, BaseTypeId.CMIS_DOCUMENT.value());
        BASETYPE_INDEX.put(ContentModel.TYPE_FOLDER, BaseTypeId.CMIS_FOLDER.value());
    }
}

