/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl;

import android.util.Log;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.mobile.android.api.constants.ContentModel;
import org.alfresco.mobile.android.api.constants.ModelMappingUtils;
import org.alfresco.mobile.android.api.exceptions.AlfrescoServiceException;
import org.alfresco.mobile.android.api.model.ContentFile;
import org.alfresco.mobile.android.api.model.ContentStream;
import org.alfresco.mobile.android.api.model.Document;
import org.alfresco.mobile.android.api.model.Folder;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.Permissions;
import org.alfresco.mobile.android.api.model.Property;
import org.alfresco.mobile.android.api.model.impl.ContentStreamImpl;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.model.impl.PermissionsImpl;
import org.alfresco.mobile.android.api.model.impl.RepositoryVersionHelper;
import org.alfresco.mobile.android.api.services.DocumentFolderService;
import org.alfresco.mobile.android.api.services.impl.AlfrescoService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.RepositorySession;
import org.alfresco.mobile.android.api.session.impl.AbstractAlfrescoSessionImpl;
import org.alfresco.mobile.android.api.utils.IOUtils;
import org.alfresco.mobile.android.api.utils.JsonDataWriter;
import org.alfresco.mobile.android.api.utils.NodeRefUtils;
import org.alfresco.mobile.android.api.utils.OnPremiseUrlRegistry;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AbstractAtomPubService;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;

public abstract class AbstractDocumentFolderServiceImpl
extends AlfrescoService
implements DocumentFolderService {
    private static final String TAG = "DocumentFolderService";
    protected Session cmisSession;
    private static final Set<Updatability> CREATE_UPDATABILITY = new HashSet<Updatability>();
    static Map<String, String> sortingMap;

    public AbstractDocumentFolderServiceImpl(AlfrescoSession repositorySession) {
        super(repositorySession);
        this.cmisSession = ((AbstractAlfrescoSessionImpl)repositorySession).getCmisSession();
    }

    @Override
    public List<Node> getChildren(Folder parentFolder) {
        return this.getChildren(parentFolder, null).getList();
    }

    @Override
    public PagingResult<Node> getChildren(Folder parentFolder, ListingContext lcontext) {
        if (this.isObjectNull(parentFolder)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "parentFolder"));
        }
        try {
            NavigationService navigationService = this.cmisSession.getBinding().getNavigationService();
            OperationContextImpl ctxt = new OperationContextImpl(this.cmisSession.getDefaultContext());
            ObjectFactory objectFactory = this.cmisSession.getObjectFactory();
            String orderBy = AbstractDocumentFolderServiceImpl.getSorting(SORT_PROPERTY_NAME, true);
            BigInteger maxItems = null;
            BigInteger skipCount = null;
            if (lcontext != null) {
                orderBy = AbstractDocumentFolderServiceImpl.getSorting(lcontext.getSortProperty(), lcontext.isSortAscending());
                maxItems = BigInteger.valueOf(lcontext.getMaxItems());
                skipCount = BigInteger.valueOf(lcontext.getSkipCount());
            }
            ObjectInFolderList children = navigationService.getChildren(this.session.getRepositoryInfo().getIdentifier(), parentFolder.getIdentifier(), ctxt.getFilterString(), orderBy, Boolean.valueOf(ctxt.isIncludeAllowableActions()), ctxt.getIncludeRelationships(), ctxt.getRenditionFilterString(), Boolean.valueOf(ctxt.isIncludePathSegments()), maxItems, skipCount, null);
            ArrayList<Node> page = new ArrayList<Node>();
            List childObjects = children.getObjects();
            if (childObjects != null) {
                for (ObjectInFolderData objectData : childObjects) {
                    if (objectData.getObject() == null) continue;
                    Node n = this.convertNode(objectFactory.convertObject(objectData.getObject(), (OperationContext)ctxt));
                    page.add(n);
                }
            }
            Boolean hasMoreItem = false;
            hasMoreItem = maxItems != null ? Boolean.valueOf(children.hasMoreItems() != false && page.size() == maxItems.intValue()) : children.hasMoreItems();
            return new PagingResultImpl<Node>(page, hasMoreItem, children.getNumItems().intValue());
        }
        catch (Exception e) {
            AbstractDocumentFolderServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public Node getChildByPath(String path) {
        return this.getChildByPath(this.getRootFolder(), path);
    }

    @Override
    public Node getChildByPath(Folder folder, String relativePathFromFolder) {
        if (this.isObjectNull(folder)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "parentFolder"));
        }
        if (this.isStringNull(relativePathFromFolder)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "relativePathFromFolder"));
        }
        try {
            String tmpPath;
            String path = (String)folder.getPropertyValue("cmis:path");
            if (path.equals("/")) {
                path = "";
            }
            if ((tmpPath = relativePathFromFolder).length() > 1 && tmpPath.endsWith("/")) {
                tmpPath = tmpPath.substring(0, tmpPath.length() - 1);
            }
            if (tmpPath.length() > 1 && !tmpPath.startsWith("/")) {
                tmpPath = "/" + tmpPath;
            }
            path = path.concat(tmpPath);
            Node result = null;
            OperationContext context = this.cmisSession.getDefaultContext();
            ObjectService objectService = this.cmisSession.getBinding().getObjectService();
            ObjectFactory objectFactory = this.cmisSession.getObjectFactory();
            ObjectData objectData = objectService.getObjectByPath(this.session.getRepositoryInfo().getIdentifier(), path, context.getFilterString(), Boolean.valueOf(context.isIncludeAllowableActions()), context.getIncludeRelationships(), context.getRenditionFilterString(), Boolean.valueOf(context.isIncludePolicies()), Boolean.valueOf(context.isIncludeAcls()), null);
            result = this.convertNode(objectFactory.convertObject(objectData, context));
            return result;
        }
        catch (CmisObjectNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            AbstractDocumentFolderServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public Node getNodeByIdentifier(String identifier) {
        if (this.isStringNull(identifier)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "nodeIdentifier"));
        }
        try {
            return this.getChildById(identifier);
        }
        catch (CmisInvalidArgumentException e) {
            throw new AlfrescoServiceException(2, (Throwable)e);
        }
        catch (Exception e) {
            AbstractDocumentFolderServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public Folder getRootFolder() {
        return this.session.getRootFolder();
    }

    @Override
    public List<Folder> getFolders(Folder parentFolder) {
        return this.getFolders(parentFolder, null).getList();
    }

    @Override
    public PagingResult<Folder> getFolders(Folder folder, ListingContext listingContext) {
        if (this.isObjectNull(folder)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "parentFolder"));
        }
        try {
            PagingResult<Node> nodes = this.getChildren(folder, listingContext);
            ArrayList<Folder> folders = new ArrayList<Folder>(nodes.getList().size());
            for (Node node : nodes.getList()) {
                if (!node.isFolder()) continue;
                folders.add((Folder)node);
            }
            return new PagingResultImpl<Folder>(folders, nodes.hasMoreItems(), -1);
        }
        catch (CmisObjectNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            AbstractDocumentFolderServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public List<Document> getDocuments(Folder folder) {
        return this.getDocuments(folder, null).getList();
    }

    @Override
    public PagingResult<Document> getDocuments(Folder folder, ListingContext listingContext) {
        if (this.isObjectNull(folder)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "parentFolder"));
        }
        try {
            PagingResult<Node> nodes = this.getChildren(folder, listingContext);
            ArrayList<Document> docs = new ArrayList<Document>(nodes.getList().size());
            for (Node node : nodes.getList()) {
                if (!node.isDocument()) continue;
                docs.add((Document)node);
            }
            return new PagingResultImpl<Document>(docs, nodes.hasMoreItems(), -1);
        }
        catch (CmisObjectNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            AbstractDocumentFolderServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public Folder getParentFolder(Node node) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        try {
            if (this.getRootFolder().equals(node)) {
                return null;
            }
            String objectId = node.getIdentifier();
            OperationContext context = this.cmisSession.getDefaultContext();
            ObjectFactory objectFactory = this.cmisSession.getObjectFactory();
            ObjectData bindingParent = this.cmisSession.getBinding().getNavigationService().getFolderParent(this.session.getRepositoryInfo().getIdentifier(), objectId, null, null);
            Folder result = (Folder)this.convertNode(objectFactory.convertObject(bindingParent, context));
            return result;
        }
        catch (Exception e) {
            AbstractDocumentFolderServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public Folder createFolder(Folder parentFolder, String folderName, Map<String, Serializable> properties) {
        return this.createFolder(parentFolder, folderName, properties, null, null);
    }

    @Override
    public Folder createFolder(Folder parentFolder, String folderName, Map<String, Serializable> properties, List<String> aspects) {
        return this.createFolder(parentFolder, folderName, properties, aspects, null);
    }

    @Override
    public Folder createFolder(Folder parentFolder, String folderName, Map<String, Serializable> properties, List<String> aspects, String type) {
        if (this.isObjectNull(parentFolder)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "parentFolder"));
        }
        if (this.isStringNull(folderName)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "folderName"));
        }
        try {
            Node n = null;
            Map<String, Serializable> tmpProperties = new HashMap<String, Serializable>();
            if (properties != null) {
                tmpProperties.putAll(properties);
            }
            tmpProperties.put(ContentModel.PROP_NAME, (Serializable)((Object)folderName));
            if (!this.isStringNull(type)) {
                tmpProperties.put("cmis:objectTypeId", (Serializable)((Object)("F:" + type)));
            }
            tmpProperties = AbstractDocumentFolderServiceImpl.convertProps(tmpProperties, BaseTypeId.CMIS_FOLDER.value());
            if (!this.isListNull(aspects)) {
                tmpProperties.put("cmis:objectTypeId", (Serializable)((Object)AbstractDocumentFolderServiceImpl.addAspects((String)((Object)tmpProperties.get("cmis:objectTypeId")), aspects)));
            }
            ObjectService objectService = this.cmisSession.getBinding().getObjectService();
            ObjectFactory objectFactory = this.cmisSession.getObjectFactory();
            String newId = objectService.createFolder(this.session.getRepositoryInfo().getIdentifier(), objectFactory.convertProperties(tmpProperties, null, null, CREATE_UPDATABILITY), parentFolder.getIdentifier(), null, null, null, null);
            if (newId == null) {
                return null;
            }
            n = this.getChildById(newId);
            if (!(n instanceof Folder)) {
                throw new AlfrescoServiceException(602, Messagesl18n.getString("DocumentFolderService.19") + newId + " : " + n.getType() + " " + n.getName());
            }
            return (Folder)n;
        }
        catch (Exception e) {
            AbstractDocumentFolderServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public Document createDocument(Folder parentFolder, String documentName, Map<String, Serializable> properties, ContentFile contentFile) {
        return this.createDocument(parentFolder, documentName, properties, contentFile, null, null);
    }

    @Override
    public Document createDocument(Folder parentFolder, String documentName, Map<String, Serializable> properties, ContentFile contentFile, List<String> aspects) {
        return this.createDocument(parentFolder, documentName, properties, contentFile, aspects, null);
    }

    @Override
    public Document createDocument(Folder parentFolder, String documentName, Map<String, Serializable> properties, ContentFile contentFile, List<String> aspects, String type) {
        if (this.isObjectNull(parentFolder)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "parentFolder"));
        }
        if (this.isStringNull(documentName)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "documentName"));
        }
        try {
            Map<String, Serializable> tmpProperties = new HashMap<String, Serializable>();
            if (properties != null) {
                tmpProperties.putAll(properties);
            }
            tmpProperties.put(ContentModel.PROP_NAME, (Serializable)((Object)documentName));
            if (!this.isStringNull(type)) {
                if (ContentModel.TYPE_CONTENT.equals(type)) {
                    tmpProperties.put("cmis:objectTypeId", (Serializable)((Object)BaseTypeId.CMIS_DOCUMENT.value()));
                } else {
                    tmpProperties.put("cmis:objectTypeId", (Serializable)((Object)("D:" + type)));
                }
            }
            tmpProperties = AbstractDocumentFolderServiceImpl.convertProps(tmpProperties, BaseTypeId.CMIS_DOCUMENT.value());
            if (!this.isListNull(aspects)) {
                tmpProperties.put("cmis:objectTypeId", (Serializable)((Object)AbstractDocumentFolderServiceImpl.addAspects((String)((Object)tmpProperties.get("cmis:objectTypeId")), aspects)));
            }
            ObjectService objectService = this.cmisSession.getBinding().getObjectService();
            ObjectFactory objectFactory = this.cmisSession.getObjectFactory();
            org.apache.chemistry.opencmis.commons.data.ContentStream c = null;
            if (contentFile != null) {
                c = objectFactory.createContentStream(documentName, contentFile.getLength(), contentFile.getMimeType(), IOUtils.getContentFileInputStream(contentFile));
            }
            String newId = objectService.createDocument(this.session.getRepositoryInfo().getIdentifier(), objectFactory.convertProperties(tmpProperties, null, null, CREATE_UPDATABILITY), parentFolder.getIdentifier(), c, VersioningState.MAJOR, null, null, null, null);
            if (this.session instanceof RepositorySession && RepositoryVersionHelper.isAlfrescoProduct(this.session)) {
                if (this.session.getParameter("org.alfresco.mobile.features.extractmetadata") != null && ((Boolean)this.session.getParameter("org.alfresco.mobile.features.extractmetadata")).booleanValue()) {
                    this.extractMetadata(newId);
                }
                if (this.session.getParameter("org.alfresco.mobile.features.generatethumbnails") != null && ((Boolean)this.session.getParameter("org.alfresco.mobile.features.generatethumbnails")).booleanValue()) {
                    this.generateThumbnail(newId);
                }
            }
            if (newId == null) {
                return null;
            }
            Node n = this.getChildById(newId);
            if (!(n instanceof Document)) {
                throw new AlfrescoServiceException(602, Messagesl18n.getString("DocumentFolderService.20") + newId);
            }
            return (Document)n;
        }
        catch (Exception e) {
            AbstractDocumentFolderServiceImpl.convertException(e);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void extractMetadata(String identifier) {
        if (this.isStringNull(identifier)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "Nodeidentifier"));
        }
        try {
            UrlBuilder url = new UrlBuilder(OnPremiseUrlRegistry.getActionQueue(this.session));
            url.addParameter("async", (Object)true);
            JSONObject jo = new JSONObject();
            jo.put("actionedUponNode", (Object)NodeRefUtils.getCleanIdentifier(identifier));
            jo.put("actionDefinitionName", (Object)"extract-metadata");
            final JsonDataWriter formData = new JsonDataWriter(jo);
            Response response = this.post(url, formData.getContentType(), new Output(){

                public void write(OutputStream out) throws IOException {
                    formData.write(out);
                }
            }, 600);
            if (response.getResponseCode() != 200) return;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Metadata extraction : KO");
        }
    }

    private void generateThumbnail(String identifier) {
        if (this.isStringNull(identifier)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "Nodeidentifier"));
        }
        try {
            UrlBuilder url = new UrlBuilder(OnPremiseUrlRegistry.getThumbnailUrl(this.session, identifier));
            url.addParameter("as", (Object)true);
            JSONObject jo = new JSONObject();
            jo.put("thumbnailName", (Object)"doclib");
            final JsonDataWriter formData = new JsonDataWriter(jo);
            this.post(url, formData.getContentType(), new Output(){

                public void write(OutputStream out) throws IOException {
                    formData.write(out);
                }
            }, 600);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Generate Thumbnail : KO");
        }
    }

    @Override
    public void deleteNode(Node node) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        try {
            if (node.isDocument() && node instanceof Document) {
                this.delete((Document)node);
            } else if (node.isFolder() && node instanceof Folder) {
                this.delete((Folder)node);
            }
        }
        catch (Exception e) {
            AbstractDocumentFolderServiceImpl.convertException(e);
        }
    }

    private void delete(Document document) {
        Permissions perm = this.getPermissions(document);
        if (!perm.canDelete()) {
            throw new AlfrescoServiceException(3, Messagesl18n.getString("ErrorCodeRegistry.DOCFOLDER_NO_PERMISSION"));
        }
        try {
            ObjectService objectService = this.cmisSession.getBinding().getObjectService();
            objectService.deleteObject(this.session.getRepositoryInfo().getIdentifier(), document.getIdentifier(), Boolean.valueOf(true), null);
            this.cmisSession.removeObjectFromCache(document.getIdentifier());
        }
        catch (CmisConstraintException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void delete(Folder folder) {
        Permissions perm = this.getPermissions(folder);
        if (!perm.canDelete()) {
            throw new AlfrescoServiceException(3, Messagesl18n.getString("DocumentFolderService.24"));
        }
        try {
            ObjectService objectService = this.cmisSession.getBinding().getObjectService();
            objectService.deleteTree(this.session.getRepositoryInfo().getIdentifier(), folder.getIdentifier(), Boolean.valueOf(true), null, Boolean.valueOf(false), null);
        }
        catch (CmisConstraintException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Node addAspects(Node node, List<String> aspects) {
        return this.updateProperties(node, null, aspects, false);
    }

    @Override
    public Node updateProperties(Node node, Map<String, Serializable> properties) {
        return this.updateProperties(node, properties, null, true);
    }

    @Override
    public Node updateProperties(Node node, Map<String, Serializable> properties, List<String> aspects) {
        return this.updateProperties(node, properties, aspects, true);
    }

    protected Node updateProperties(Node node, Map<String, Serializable> properties, List<String> aspects, boolean propertiesRequired) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        if (propertiesRequired && this.isMapNull(properties)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "properties"));
        }
        try {
            Boolean isCheckedOut;
            Map<String, Serializable> tmpProperties = AbstractDocumentFolderServiceImpl.convertProps(properties, node.getType());
            if (!ContentModel.TYPE_CONTENT.equals(node.getType()) && !ContentModel.TYPE_FOLDER.equals(node.getType())) {
                String objectBaseTypeId = (String)node.getProperty("cmis:baseTypeId").getValue();
                if (BaseTypeId.CMIS_DOCUMENT.value().equals(objectBaseTypeId)) {
                    tmpProperties.put("cmis:objectTypeId", (Serializable)((Object)("D:" + node.getType())));
                } else if (BaseTypeId.CMIS_FOLDER.value().equals(objectBaseTypeId)) {
                    tmpProperties.put("cmis:objectTypeId", (Serializable)((Object)("F:" + node.getType())));
                }
            }
            tmpProperties.put("cmis:objectTypeId", (Serializable)((Object)AbstractDocumentFolderServiceImpl.addAspects((String)((Object)tmpProperties.get("cmis:objectTypeId")), node.getAspects(), aspects)));
            ObjectService objectService = this.cmisSession.getBinding().getObjectService();
            ObjectFactory objectFactory = this.cmisSession.getObjectFactory();
            String objectId = node.getIdentifier();
            Holder objectIdHolder = new Holder((Object)objectId);
            Holder changeTokenHolder = null;
            if (node.getProperty("cmis:changeToken") != null && node.getProperty("cmis:changeToken").getValue() != null) {
                changeTokenHolder = new Holder((Object)node.getProperty("cmis:changeToken").getValue().toString());
            }
            HashSet<Updatability> updatebility = new HashSet<Updatability>();
            updatebility.add(Updatability.READWRITE);
            Property property = node.getProperty("cmis:isVersionSeriesCheckedOut");
            if (property != null && (isCheckedOut = (Boolean)property.getValue()) != null && isCheckedOut.booleanValue()) {
                updatebility.add(Updatability.WHENCHECKEDOUT);
            }
            String nodeType = node.getProperty("cmis:objectTypeId").getValue().toString();
            objectService.updateProperties(this.session.getRepositoryInfo().getIdentifier(), objectIdHolder, changeTokenHolder, objectFactory.convertProperties(tmpProperties, this.cmisSession.getTypeDefinition(nodeType), null, updatebility), null);
            this.cmisSession.removeObjectFromCache(objectId);
            return this.getChildById(objectId);
        }
        catch (CmisRuntimeException e) {
            if (e.getErrorContent() != null && e.getErrorContent().contains("cannot be null or empty.")) {
                throw new IllegalArgumentException(e);
            }
            AbstractDocumentFolderServiceImpl.convertException((Exception)((Object)e));
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("cannot be null or empty.")) {
                throw new IllegalArgumentException(e);
            }
            AbstractDocumentFolderServiceImpl.convertException(e);
        }
        return null;
    }

    @Override
    public Document updateContent(Document content, ContentFile contentFile) {
        if (this.isObjectNull(content)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        Document newContent = null;
        try {
            ObjectService objectService = this.cmisSession.getBinding().getObjectService();
            ObjectFactory objectFactory = this.cmisSession.getObjectFactory();
            Holder objectIdHolder = new Holder((Object)content.getIdentifier());
            Holder changeTokenHolder = new Holder((Object)((String)content.getProperty("cmis:changeToken").getValue()));
            org.apache.chemistry.opencmis.commons.data.ContentStream c = null;
            if (contentFile != null) {
                c = objectFactory.createContentStream(contentFile.getFileName(), contentFile.getLength(), content.getContentStreamMimeType(), IOUtils.getContentFileInputStream(contentFile));
            }
            objectService.setContentStream(this.session.getRepositoryInfo().getIdentifier(), objectIdHolder, Boolean.valueOf(true), changeTokenHolder, c, null);
            this.cmisSession.removeObjectFromCache(content.getIdentifier());
            newContent = (Document)this.getNodeByIdentifier(content.getIdentifier());
        }
        catch (Exception e) {
            AbstractDocumentFolderServiceImpl.convertException(e);
        }
        return newContent;
    }

    @Override
    public ContentFile getContent(Document document) {
        if (this.isObjectNull(document)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "document"));
        }
        try {
            return this.saveContentStream(this.getContentStream(document), NodeRefUtils.getNodeIdentifier(document.getIdentifier()), 2);
        }
        catch (Exception e) {
            AbstractDocumentFolderServiceImpl.convertException(e);
            return null;
        }
    }

    @Override
    public ContentStream getContentStream(Document document) {
        if (this.isObjectNull(document)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "document"));
        }
        try {
            if (document.getContentStreamLength() <= 0L) {
                return null;
            }
            ObjectService objectService = this.cmisSession.getBinding().getObjectService();
            ContentStreamImpl cf = new ContentStreamImpl(document.getName(), objectService.getContentStream(this.session.getRepositoryInfo().getIdentifier(), document.getIdentifier(), null, null, null, null));
            if (cf.getLength() == -1L) {
                return new ContentStreamImpl(document.getName(), cf.getInputStream(), cf.getMimeType(), document.getContentStreamLength());
            }
            return cf;
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            AbstractDocumentFolderServiceImpl.convertException(e);
            return null;
        }
    }

    public ContentStream downloadContentStream(String identifier) {
        try {
            Document doc = (Document)this.getChildById(identifier);
            return this.getContentStream(doc);
        }
        catch (Exception e) {
            AbstractDocumentFolderServiceImpl.convertException(e);
            return null;
        }
    }

    public String getDownloadUrl(Document document) {
        if (this.isObjectNull(document)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "document"));
        }
        try {
            AbstractAtomPubService objectService = (AbstractAtomPubService)this.cmisSession.getBinding().getObjectService();
            return objectService.loadLink(this.session.getRepositoryInfo().getIdentifier(), document.getIdentifier(), "@@content@@", null);
        }
        catch (Exception e) {
            AbstractDocumentFolderServiceImpl.convertException(e);
            return null;
        }
    }

    public abstract ContentStream getRenditionStream(String var1, String var2);

    public abstract UrlBuilder getRenditionUrl(String var1, String var2);

    @Override
    public ContentStream getRenditionStream(Node node, String type) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        return this.getRenditionStream(node.getIdentifier(), type);
    }

    @Override
    public ContentFile getRendition(Node node, String type) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        return this.saveContentStream(this.getRenditionStream(node.getIdentifier(), type), NodeRefUtils.getNodeIdentifier(node.getIdentifier()), 1);
    }

    @Override
    public Permissions getPermissions(Node node) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        return new PermissionsImpl(node);
    }

    private Node getChildById(String identifier) {
        Node result = null;
        result = this.convertNode(this.cmisSession.getObject(identifier));
        return result;
    }

    static String getSorting(String sortingKey, boolean modifier) {
        String s = sortingMap.containsKey(sortingKey) ? sortingMap.get(sortingKey) : sortingMap.get(SORT_PROPERTY_NAME);
        s = modifier ? s + " ASC" : s + " DESC";
        return s;
    }

    private static Map<String, Serializable> convertProps(Map<String, Serializable> properties, String typeId) {
        HashMap<String, Serializable> tmpProperties = new HashMap<String, Serializable>();
        if (properties != null) {
            tmpProperties.putAll(properties);
        }
        for (Map.Entry<String, String> props : ModelMappingUtils.ALFRESCO_TO_CMIS.entrySet()) {
            if (!tmpProperties.containsKey(props.getKey())) continue;
            tmpProperties.put(props.getValue(), (Serializable)tmpProperties.get(props.getKey()));
            tmpProperties.remove(props.getKey());
        }
        String objectId = null;
        objectId = tmpProperties.containsKey("cmis:objectTypeId") ? (String)tmpProperties.get("cmis:objectTypeId") : (ContentModel.TYPE_CONTENT.equals(typeId) ? BaseTypeId.CMIS_DOCUMENT.value() : (ContentModel.TYPE_FOLDER.equals(typeId) ? BaseTypeId.CMIS_FOLDER.value() : typeId));
        for (Map.Entry<String, String> props : ModelMappingUtils.ALFRESCO_ASPECTS.entrySet()) {
            if (!tmpProperties.containsKey(props.getKey()) || objectId.contains(props.getValue())) continue;
            objectId = objectId.concat("," + props.getValue());
        }
        tmpProperties.put("cmis:objectTypeId", (Serializable)((Object)objectId));
        return tmpProperties;
    }

    private static String addAspects(String objectId, List<String> nodeAspects) {
        return AbstractDocumentFolderServiceImpl.addAspects(objectId, nodeAspects, null);
    }

    private static String addAspects(String objectId, List<String> nodeAspects, List<String> aspectToApplied) {
        String objectIdWithAspects = objectId;
        HashSet<String> aspects = new HashSet<String>(nodeAspects);
        if (aspectToApplied != null) {
            aspects.addAll(aspectToApplied);
        }
        for (String aspect : aspects) {
            if (objectIdWithAspects.contains(aspect)) continue;
            objectIdWithAspects = objectIdWithAspects.concat(",P:" + aspect);
        }
        return objectIdWithAspects;
    }

    @Override
    public Node refreshNode(Node node) {
        this.cmisSession.removeObjectFromCache(node.getIdentifier());
        return this.getNodeByIdentifier(node.getIdentifier());
    }

    static {
        CREATE_UPDATABILITY.add(Updatability.ONCREATE);
        CREATE_UPDATABILITY.add(Updatability.READWRITE);
        sortingMap = new HashMap<String, String>(){
            {
                this.put(DocumentFolderService.SORT_PROPERTY_NAME, "cmis:name");
                this.put(DocumentFolderService.SORT_PROPERTY_TITLE, DocumentFolderService.SORT_PROPERTY_TITLE);
                this.put(DocumentFolderService.SORT_PROPERTY_DESCRIPTION, DocumentFolderService.SORT_PROPERTY_DESCRIPTION);
                this.put(DocumentFolderService.SORT_PROPERTY_CREATED_AT, "cmis:creationDate");
                this.put(DocumentFolderService.SORT_PROPERTY_MODIFIED_AT, "cmis:lastModificationDate");
            }
        };
    }
}

