/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.exceptions.AlfrescoServiceException;
import org.alfresco.mobile.android.api.model.Comment;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.services.CommentService;
import org.alfresco.mobile.android.api.services.impl.AlfrescoService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.utils.JsonDataWriter;
import org.alfresco.mobile.android.api.utils.JsonUtils;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;

public abstract class AbstractCommentService
extends AlfrescoService
implements CommentService {
    public AbstractCommentService(AlfrescoSession repositorySession) {
        super(repositorySession);
    }

    @Override
    public List<Comment> getComments(Node node) {
        return this.getComments(node, null).getList();
    }

    protected abstract UrlBuilder getCommentsUrl(Node var1, ListingContext var2, boolean var3);

    @Override
    public PagingResult<Comment> getComments(Node node, ListingContext listingContext) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        try {
            return this.computeComment(this.getCommentsUrl(node, listingContext, true));
        }
        catch (AlfrescoServiceException er) {
            if (er.getMessage() != null && er.getAlfrescoErrorContent() != null && er.getMessage().contains("Access Denied")) {
                return new PagingResultImpl<Comment>(new ArrayList(0), false, -1);
            }
            throw er;
        }
        catch (Exception e) {
            AbstractCommentService.convertException(e);
            return null;
        }
    }

    @Override
    public Comment addComment(Node node, String content) {
        if (this.isObjectNull(node)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "node"));
        }
        if (this.isStringNull(content)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "content"));
        }
        try {
            UrlBuilder url = this.getCommentsUrl(node, null, false);
            JSONObject jo = new JSONObject();
            jo.put("content", (Object)content);
            final JsonDataWriter formData = new JsonDataWriter(jo);
            Response resp = this.post(url, formData.getContentType(), new Output(){

                public void write(OutputStream out) throws IOException {
                    formData.write(out);
                }
            }, 300);
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            return this.parseData(json);
        }
        catch (Exception e) {
            AbstractCommentService.convertException(e);
            return null;
        }
    }

    protected abstract UrlBuilder getCommentUrl(Node var1, Comment var2);

    @Override
    public Comment updateComment(Node node, Comment comment, String content) {
        if (this.isObjectNull(comment)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "comment"));
        }
        if (this.isStringNull(content)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "content"));
        }
        try {
            UrlBuilder url = this.getCommentUrl(node, comment);
            JSONObject jo = new JSONObject();
            jo.put("content", (Object)content);
            final JsonDataWriter formData = new JsonDataWriter(jo);
            Response resp = this.put(url, formData.getContentType(), null, new Output(){

                public void write(OutputStream out) throws IOException {
                    formData.write(out);
                }
            }, 300);
            Map<String, Object> json = JsonUtils.parseObject(resp.getStream(), resp.getCharset());
            return this.parseData(json);
        }
        catch (Exception e) {
            AbstractCommentService.convertException(e);
            return null;
        }
    }

    @Override
    public void deleteComment(Node node, Comment comment) {
        if (this.isObjectNull(comment)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "comment"));
        }
        try {
            this.delete(this.getCommentUrl(node, comment), 300);
        }
        catch (Exception e) {
            AbstractCommentService.convertException(e);
        }
    }

    protected abstract Comment parseData(Map<String, Object> var1);

    protected abstract PagingResult<Comment> computeComment(UrlBuilder var1);
}

