/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services.impl;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.mobile.android.api.exceptions.AlfrescoServiceException;
import org.alfresco.mobile.android.api.model.ActivityEntry;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.impl.PagingResultImpl;
import org.alfresco.mobile.android.api.services.ActivityStreamService;
import org.alfresco.mobile.android.api.services.impl.AlfrescoService;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.utils.messages.Messagesl18n;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;

public abstract class AbstractActivityStreamService
extends AlfrescoService
implements ActivityStreamService {
    public AbstractActivityStreamService(AlfrescoSession repositorySession) {
        super(repositorySession);
    }

    @Override
    public List<ActivityEntry> getActivityStream() {
        return this.getActivityStream((ListingContext)null).getList();
    }

    protected abstract UrlBuilder getUserActivitiesUrl(ListingContext var1);

    @Override
    public PagingResult<ActivityEntry> getActivityStream(ListingContext listingContext) {
        try {
            return this.computeActivities(this.getUserActivitiesUrl(listingContext), listingContext);
        }
        catch (Exception e) {
            AbstractActivityStreamService.convertException(e);
            return null;
        }
    }

    @Override
    public List<ActivityEntry> getActivityStream(String personIdentifier) {
        return this.getActivityStream(personIdentifier, null).getList();
    }

    protected abstract UrlBuilder getUserActivitiesUrl(String var1, ListingContext var2);

    @Override
    public PagingResult<ActivityEntry> getActivityStream(String personIdentifier, ListingContext listingContext) {
        if (this.isStringNull(personIdentifier)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "personIdentifier"));
        }
        try {
            return this.computeActivities(this.getUserActivitiesUrl(personIdentifier, listingContext), listingContext);
        }
        catch (AlfrescoServiceException e) {
            if (e.getCause() instanceof CmisConnectionException) {
                ArrayList result = new ArrayList();
                return new PagingResultImpl<ActivityEntry>(result, false, -1);
            }
            if (this.isCloudSession() && e.getAlfrescoErrorContent() != null && e.getAlfrescoErrorContent().getMessage() != null && e.getAlfrescoErrorContent().getMessage().contains("not found")) {
                ArrayList result = new ArrayList();
                return new PagingResultImpl<ActivityEntry>(result, false, -1);
            }
            throw e;
        }
        catch (Exception e) {
            AbstractActivityStreamService.convertException(e);
            return null;
        }
    }

    @Override
    public List<ActivityEntry> getSiteActivityStream(String siteName) {
        return this.getSiteActivityStream(siteName, null).getList();
    }

    protected abstract UrlBuilder getSiteActivitiesUrl(String var1, ListingContext var2);

    @Override
    public PagingResult<ActivityEntry> getSiteActivityStream(String siteIdentifier, ListingContext listingContext) {
        if (this.isStringNull(siteIdentifier)) {
            throw new IllegalArgumentException(String.format(Messagesl18n.getString("ErrorCodeRegistry.GENERAL_INVALID_ARG_NULL"), "siteIdentifier"));
        }
        try {
            return this.computeActivities(this.getSiteActivitiesUrl(siteIdentifier, listingContext), listingContext);
        }
        catch (AlfrescoServiceException e) {
            if (e.getCause() instanceof CmisConnectionException) {
                ArrayList result = new ArrayList();
                return new PagingResultImpl<ActivityEntry>(result, false, -1);
            }
            throw e;
        }
        catch (Exception e) {
            AbstractActivityStreamService.convertException(e);
            return null;
        }
    }

    protected abstract PagingResult<ActivityEntry> computeActivities(UrlBuilder var1, ListingContext var2);
}

