/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.model.ContentStream;
import org.alfresco.mobile.android.api.model.Document;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.Person;
import org.alfresco.mobile.android.api.model.Process;
import org.alfresco.mobile.android.api.model.ProcessDefinition;
import org.alfresco.mobile.android.api.model.Property;
import org.alfresco.mobile.android.api.model.Task;
import org.alfresco.mobile.android.api.services.Service;

public interface WorkflowService
extends Service {
    public static final String FILTER_KEY_STATUS = "filterStatus";
    public static final int FILTER_STATUS_ANY = 0;
    public static final int FILTER_STATUS_ACTIVE = 1;
    public static final int FILTER_STATUS_COMPLETE = 2;
    public static final String FILTER_KEY_DUE = "filterDue";
    public static final int FILTER_DUE_TODAY = 0;
    public static final int FILTER_DUE_TOMORROW = 1;
    public static final int FILTER_DUE_7DAYS = 7;
    public static final int FILTER_DUE_OVERDUE = 100;
    public static final int FILTER_DUE_NODATE = -1;
    public static final String FILTER_KEY_PRIORITY = "filterPriority";
    public static final int FILTER_PRIORITY_LOW = 3;
    public static final int FILTER_PRIORITY_MEDIUM = 2;
    public static final int FILTER_PRIORITY_HIGH = 1;
    public static final String FILTER_KEY_ASSIGNEE = "filterAssignee";
    public static final int FILTER_ASSIGNEE_ME = 1;
    public static final int FILTER_ASSIGNEE_UNASSIGNED = 2;
    public static final int FILTER_ASSIGNEE_ALL = 3;
    public static final int FILTER_NO_ASSIGNEE = 4;
    public static final String FILTER_KEY_INITIATOR = "filterInitiator";
    public static final int FILTER_INITIATOR_ME = 1;
    public static final int FILTER_INITIATOR_ANY = 2;

    public List<ProcessDefinition> getProcessDefinitions();

    public PagingResult<ProcessDefinition> getProcessDefinitions(ListingContext var1);

    public ProcessDefinition getProcessDefinition(String var1);

    public ProcessDefinition getProcessDefinitionByKey(String var1);

    public List<Process> getProcesses();

    public PagingResult<Process> getProcesses(ListingContext var1);

    public Process startProcess(ProcessDefinition var1, List<Person> var2, Map<String, Serializable> var3, List<Document> var4);

    public void deleteProcess(Process var1);

    public Process getProcess(String var1);

    public List<Task> getTasks(Process var1);

    public PagingResult<Task> getTasks(Process var1, ListingContext var2);

    public Process refresh(Process var1);

    public Map<String, Property> getVariables(Process var1);

    public List<Document> getDocuments(Process var1);

    public PagingResult<Document> getDocuments(Process var1, ListingContext var2);

    public List<Document> getDocuments(Task var1);

    public PagingResult<Document> getDocuments(Task var1, ListingContext var2);

    public void addDocuments(Task var1, List<Document> var2);

    public void removeDocuments(Task var1, List<Document> var2);

    public List<Task> getTasks();

    public PagingResult<Task> getTasks(ListingContext var1);

    public Task getTask(String var1);

    public Task claimTask(Task var1);

    public Task unclaimTask(Task var1);

    public Task completeTask(Task var1, Map<String, Serializable> var2);

    public Task reassignTask(Task var1, Person var2);

    public Task updateVariables(Task var1, Map<String, Serializable> var2);

    public Process updateVariables(Process var1, Map<String, Serializable> var2);

    public Task refresh(Task var1);

    public Map<String, Property> getVariables(Task var1);

    public ContentStream getProcessDiagram(Process var1);

    public ContentStream getProcessDiagram(String var1);
}

