/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.services;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.constants.ContentModel;
import org.alfresco.mobile.android.api.model.ContentFile;
import org.alfresco.mobile.android.api.model.ContentStream;
import org.alfresco.mobile.android.api.model.Document;
import org.alfresco.mobile.android.api.model.Folder;
import org.alfresco.mobile.android.api.model.ListingContext;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.model.PagingResult;
import org.alfresco.mobile.android.api.model.Permissions;
import org.alfresco.mobile.android.api.services.Service;

public interface DocumentFolderService
extends Service {
    public static final String SORT_PROPERTY_NAME = ContentModel.PROP_NAME;
    public static final String SORT_PROPERTY_TITLE = ContentModel.PROP_TITLE;
    public static final String SORT_PROPERTY_DESCRIPTION = ContentModel.PROP_DESCRIPTION;
    public static final String SORT_PROPERTY_CREATED_AT = ContentModel.PROP_CREATED;
    public static final String SORT_PROPERTY_MODIFIED_AT = ContentModel.PROP_MODIFIED;
    public static final String RENDITION_THUMBNAIL = "doclib";
    public static final String RENDITION_PREVIEW = "imgpreview";

    public List<Node> getChildren(Folder var1);

    public PagingResult<Node> getChildren(Folder var1, ListingContext var2);

    public Node getChildByPath(String var1);

    public Node getChildByPath(Folder var1, String var2);

    public Node getNodeByIdentifier(String var1);

    public List<Document> getDocuments(Folder var1);

    public PagingResult<Document> getDocuments(Folder var1, ListingContext var2);

    public List<Folder> getFolders(Folder var1);

    public PagingResult<Folder> getFolders(Folder var1, ListingContext var2);

    public Folder getRootFolder();

    public Folder getParentFolder(Node var1);

    public Folder createFolder(Folder var1, String var2, Map<String, Serializable> var3);

    public Folder createFolder(Folder var1, String var2, Map<String, Serializable> var3, List<String> var4);

    public Folder createFolder(Folder var1, String var2, Map<String, Serializable> var3, List<String> var4, String var5);

    public Document createDocument(Folder var1, String var2, Map<String, Serializable> var3, ContentFile var4);

    public Document createDocument(Folder var1, String var2, Map<String, Serializable> var3, ContentFile var4, List<String> var5);

    public Document createDocument(Folder var1, String var2, Map<String, Serializable> var3, ContentFile var4, List<String> var5, String var6);

    public void deleteNode(Node var1);

    public Node updateProperties(Node var1, Map<String, Serializable> var2);

    public Node updateProperties(Node var1, Map<String, Serializable> var2, List<String> var3);

    public Node addAspects(Node var1, List<String> var2);

    public Document updateContent(Document var1, ContentFile var2);

    public ContentFile getContent(Document var1);

    public ContentStream getContentStream(Document var1);

    public Permissions getPermissions(Node var1);

    public ContentFile getRendition(Node var1, String var2);

    public ContentStream getRenditionStream(Node var1, String var2);

    public List<Document> getFavoriteDocuments();

    public PagingResult<Document> getFavoriteDocuments(ListingContext var1);

    public List<Folder> getFavoriteFolders();

    public PagingResult<Folder> getFavoriteFolders(ListingContext var1);

    public List<Node> getFavoriteNodes();

    public PagingResult<Node> getFavoriteNodes(ListingContext var1);

    public boolean isFavorite(Node var1);

    public void addFavorite(Node var1);

    public void removeFavorite(Node var1);

    public Node refreshNode(Node var1);
}

