/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.network;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.alfresco.mobile.android.api.utils.IOUtils;
import org.apache.chemistry.opencmis.client.bindings.impl.ClientVersion;
import org.apache.chemistry.opencmis.client.bindings.impl.CmisBindingsHelper;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.http.DefaultHttpInvoker;
import org.apache.chemistry.opencmis.client.bindings.spi.http.HttpInvoker;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.spi.AuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkHttpInvoker
implements HttpInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpInvoker.class);
    private static final int BUFFER_SIZE = 0x200000;

    public Response invokeGET(UrlBuilder url, BindingSession session) {
        return this.invoke(url, "GET", null, null, null, session, null, null);
    }

    public Response invokeGET(UrlBuilder url, BindingSession session, BigInteger offset, BigInteger length) {
        return this.invoke(url, "GET", null, null, null, session, offset, length);
    }

    public Response invokePOST(UrlBuilder url, String contentType, Output writer, BindingSession session) {
        return this.invoke(url, "POST", contentType, null, writer, session, null, null);
    }

    public Response invokePUT(UrlBuilder url, String contentType, Map<String, String> headers, Output writer, BindingSession session) {
        return this.invoke(url, "PUT", contentType, headers, writer, session, null, null);
    }

    public Response invokeDELETE(UrlBuilder url, BindingSession session) {
        return this.invoke(url, "DELETE", null, null, null, session, null, null);
    }

    protected HttpURLConnection getHttpURLConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    protected Response invoke(UrlBuilder url, String method, String contentType, Map<String, String> headers, Output writer, BindingSession session, BigInteger offset, BigInteger length) {
        try {
            Object compression;
            AuthenticationProvider authProvider;
            int readTimeout;
            if (LOG.isDebugEnabled()) {
                LOG.debug(method + " " + url);
            }
            HttpURLConnection conn = this.getHttpURLConnection(new URL(url.toString()));
            conn.setRequestMethod(method);
            conn.setDoInput(true);
            conn.setDoOutput(writer != null);
            conn.setAllowUserInteraction(false);
            conn.setUseCaches(false);
            conn.setRequestProperty("User-Agent", ClientVersion.OPENCMIS_CLIENT);
            int connectTimeout = session.get("org.apache.chemistry.opencmis.binding.connecttimeout", -1);
            if (connectTimeout >= 0) {
                conn.setConnectTimeout(connectTimeout);
            }
            if ((readTimeout = session.get("org.apache.chemistry.opencmis.binding.readtimeout", -1)) >= 0) {
                conn.setReadTimeout(readTimeout);
            }
            if (contentType != null) {
                conn.setRequestProperty("Content-Type", contentType);
            }
            if (headers != null) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    conn.addRequestProperty(header.getKey(), header.getValue());
                }
            }
            if ((authProvider = CmisBindingsHelper.getAuthenticationProvider((BindingSession)session)) != null) {
                Map httpHeaders = authProvider.getHTTPHeaders(url.toString());
                if (httpHeaders != null) {
                    for (Map.Entry header : httpHeaders.entrySet()) {
                        if (header.getValue() == null) continue;
                        for (String value : (List)header.getValue()) {
                            conn.addRequestProperty((String)header.getKey(), value);
                        }
                    }
                }
                if (conn instanceof HttpsURLConnection) {
                    HostnameVerifier hv;
                    SSLSocketFactory sf = authProvider.getSSLSocketFactory();
                    if (sf != null) {
                        ((HttpsURLConnection)conn).setSSLSocketFactory(sf);
                    }
                    if ((hv = authProvider.getHostnameVerifier()) != null) {
                        ((HttpsURLConnection)conn).setHostnameVerifier(hv);
                    }
                }
            }
            if (offset != null || length != null) {
                StringBuilder sb = new StringBuilder("bytes=");
                if (offset == null || offset.signum() == -1) {
                    offset = BigInteger.ZERO;
                }
                sb.append(offset.toString());
                sb.append("-");
                if (length != null && length.signum() == 1) {
                    sb.append(offset.add(length.subtract(BigInteger.ONE)).toString());
                }
                conn.setRequestProperty("Range", sb.toString());
            }
            if ((compression = session.get("org.alfresco.mobile.http.encoding")) == null) {
                conn.setRequestProperty("Accept-Encoding", "");
            } else {
                try {
                    Boolean compressionValue = Boolean.parseBoolean(compression.toString());
                    if (compressionValue.booleanValue()) {
                        conn.setRequestProperty("Accept-Encoding", "gzip,deflate");
                    } else {
                        conn.setRequestProperty("Accept-Encoding", "");
                    }
                }
                catch (Exception e) {
                    conn.setRequestProperty("Accept-Encoding", compression.toString());
                }
            }
            if (session.get("org.alfresco.mobile.http.language") instanceof String && session.get("org.alfresco.mobile.http.language") != null) {
                conn.setRequestProperty("Accept-Language", session.get("org.alfresco.mobile.http.language").toString());
            }
            if (writer != null) {
                Object chunkTransfert = session.get("org.alfresco.mobile.http.transfert.chunk");
                if (chunkTransfert != null && Boolean.parseBoolean(chunkTransfert.toString())) {
                    conn.setRequestProperty("Transfer-Encoding", "chunked");
                    conn.setChunkedStreamingMode(0);
                }
                conn.setConnectTimeout(900000);
                OutputStream connOut = null;
                Object clientCompression = session.get("org.apache.chemistry.opencmis.binding.clientcompression");
                if (clientCompression != null && Boolean.parseBoolean(clientCompression.toString())) {
                    conn.setRequestProperty("Content-Encoding", "gzip");
                    connOut = new GZIPOutputStream(conn.getOutputStream(), 4096);
                } else {
                    connOut = conn.getOutputStream();
                }
                BufferedOutputStream out = new BufferedOutputStream(connOut, 0x200000);
                writer.write((OutputStream)out);
                ((OutputStream)out).flush();
            }
            conn.connect();
            int respCode = conn.getResponseCode();
            InputStream inputStream = null;
            if (respCode == 200 || respCode == 201 || respCode == 203 || respCode == 206) {
                inputStream = conn.getInputStream();
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(method + " " + url + " > Headers: " + conn.getHeaderFields());
            }
            if (authProvider != null) {
                authProvider.putResponseHeaders(url.toString(), respCode, conn.getHeaderFields());
            }
            return new Response(respCode, conn.getResponseMessage(), conn.getHeaderFields(), inputStream, conn.getErrorStream());
        }
        catch (Exception e) {
            throw new CmisConnectionException("Cannot access " + url + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public static Response invokeGET(UrlBuilder url, Map<String, List<String>> headers) {
        return NetworkHttpInvoker.invoke(url, "GET", null, headers, null, null, null, null);
    }

    public static Response invokePOST(UrlBuilder url, String contentType, Output writer, Map<String, List<String>> headers) {
        return NetworkHttpInvoker.invoke(url, "POST", contentType, headers, writer, null, null, null);
    }

    public static Response invokePOST(UrlBuilder url, String contentType, Map<String, String> params) {
        return NetworkHttpInvoker.invoke(url, "POST", contentType, null, null, true, null, null, params);
    }

    private static Response invoke(UrlBuilder url, String method, String contentType, Map<String, List<String>> httpHeaders, Output writer, BigInteger offset, BigInteger length, Map<String, String> params) {
        return NetworkHttpInvoker.invoke(url, method, contentType, httpHeaders, writer, false, offset, length, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Response invoke(UrlBuilder url, String method, String contentType, Map<String, List<String>> httpHeaders, Output writer, boolean forceOutput, BigInteger offset, BigInteger length, Map<String, String> params) {
        try {
            BigInteger tmpOffset;
            HttpURLConnection conn = (HttpURLConnection)new URL(url.toString()).openConnection();
            conn.setRequestMethod(method);
            conn.setDoInput(true);
            conn.setDoOutput(writer != null || forceOutput);
            conn.setAllowUserInteraction(false);
            conn.setUseCaches(false);
            conn.setRequestProperty("User-Agent", ClientVersion.OPENCMIS_CLIENT);
            if (contentType != null) {
                conn.setRequestProperty("Content-Type", contentType);
            }
            if (httpHeaders != null) {
                for (Map.Entry<String, List<String>> header : httpHeaders.entrySet()) {
                    if (header.getValue() == null) continue;
                    for (String value : header.getValue()) {
                        conn.addRequestProperty(header.getKey(), value);
                    }
                }
            }
            if ((tmpOffset = offset) != null || length != null) {
                StringBuilder sb = new StringBuilder("bytes=");
                if (tmpOffset == null || tmpOffset.signum() == -1) {
                    tmpOffset = BigInteger.ZERO;
                }
                sb.append(tmpOffset.toString());
                sb.append("-");
                if (length != null && length.signum() == 1) {
                    sb.append(tmpOffset.add(length.subtract(BigInteger.ONE)).toString());
                }
                conn.setRequestProperty("Range", sb.toString());
            }
            conn.setRequestProperty("Accept-Encoding", "gzip,deflate");
            if (params != null) {
                DataOutputStream ostream = null;
                OutputStream os = null;
                try {
                    os = conn.getOutputStream();
                    ostream = new DataOutputStream(os);
                    Set<String> parameters = params.keySet();
                    StringBuffer buf = new StringBuffer();
                    int paramCount = 0;
                    for (String it : parameters) {
                        String parameterName = it;
                        String parameterValue = params.get(parameterName);
                        if (parameterValue == null) continue;
                        parameterValue = URLEncoder.encode(parameterValue, "UTF-8");
                        if (paramCount > 0) {
                            buf.append("&");
                        }
                        buf.append(parameterName);
                        buf.append("=");
                        buf.append(parameterValue);
                        ++paramCount;
                    }
                    ostream.writeBytes(buf.toString());
                }
                finally {
                    if (ostream != null) {
                        ostream.flush();
                        ostream.close();
                    }
                    IOUtils.closeStream(os);
                }
            }
            if (writer != null) {
                OutputStream connOut = null;
                connOut = conn.getOutputStream();
                BufferedOutputStream out = new BufferedOutputStream(connOut, 0x200000);
                writer.write((OutputStream)out);
                ((OutputStream)out).flush();
            }
            conn.connect();
            int respCode = conn.getResponseCode();
            InputStream inputStream = null;
            if (respCode == 200 || respCode == 201 || respCode == 203 || respCode == 206) {
                inputStream = conn.getInputStream();
            }
            return new Response(respCode, conn.getResponseMessage(), conn.getHeaderFields(), inputStream, conn.getErrorStream());
        }
        catch (Exception e) {
            throw new CmisConnectionException("Cannot access " + url + ": " + e.getMessage(), (Throwable)e);
        }
    }
}

