/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.model.impl.publicapi;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.model.Node;
import org.alfresco.mobile.android.api.model.Property;
import org.alfresco.mobile.android.api.model.impl.PropertyImpl;
import org.alfresco.mobile.android.api.model.impl.publicapi.PublicAPIBaseTypeIds;
import org.alfresco.mobile.android.api.utils.DateUtils;
import org.alfresco.mobile.android.api.utils.NodeRefUtils;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;

public class PublicAPINodeImpl
implements Node {
    private static final long serialVersionUID = 1L;
    private Map<String, Property> properties = new HashMap<String, Property>();
    private boolean hasAllProperties;
    private GregorianCalendar creationDate;
    private GregorianCalendar modificationDate;
    public static final Parcelable.Creator<PublicAPINodeImpl> CREATOR = new Parcelable.Creator<PublicAPINodeImpl>(){

        public PublicAPINodeImpl createFromParcel(Parcel in) {
            return new PublicAPINodeImpl(in);
        }

        public PublicAPINodeImpl[] newArray(int size) {
            return new PublicAPINodeImpl[size];
        }
    };

    public PublicAPINodeImpl() {
    }

    public PublicAPINodeImpl(String type, Map<String, Object> json) {
        this.properties.put("id", new PropertyImpl(JSONConverter.getString(json, (String)"id")));
        this.properties.put("guid", new PropertyImpl(JSONConverter.getString(json, (String)"guid")));
        this.properties.put("name", new PropertyImpl(JSONConverter.getString(json, (String)"name")));
        this.properties.put("title", new PropertyImpl(JSONConverter.getString(json, (String)"title")));
        this.properties.put("description", new PropertyImpl(JSONConverter.getString(json, (String)"description")));
        this.properties.put("createdAt", new PropertyImpl(JSONConverter.getString(json, (String)"createdAt")));
        this.properties.put("createdBy", new PropertyImpl(JSONConverter.getString(json, (String)"createdBy")));
        this.properties.put("modifiedAt", new PropertyImpl(JSONConverter.getString(json, (String)"modifiedAt")));
        this.properties.put("modifiedBy", new PropertyImpl(JSONConverter.getString(json, (String)"modifiedBy")));
        this.properties.put("modifiedBy", new PropertyImpl(JSONConverter.getString(json, (String)"modifiedBy")));
        this.properties.put("mimeType", new PropertyImpl(JSONConverter.getString(json, (String)"mimeType")));
        this.properties.put("sizeInBytes", new PropertyImpl(JSONConverter.getString(json, (String)"sizeInBytes")));
        this.properties.put("versionLabel", new PropertyImpl(JSONConverter.getString(json, (String)"versionLabel")));
        this.properties.put("type", new PropertyImpl(type));
        this.hasAllProperties = false;
    }

    @Override
    public String getIdentifier() {
        if (this.getPropertyValue("guid") == null && this.getPropertyValue("id") != null) {
            return NodeRefUtils.getNodeIdentifier((String)this.getPropertyValue("id"));
        }
        return (String)this.getPropertyValue("guid");
    }

    @Override
    public String getName() {
        return (String)this.getPropertyValue("name");
    }

    @Override
    public String getTitle() {
        return (String)this.getPropertyValue("title");
    }

    @Override
    public String getDescription() {
        return (String)this.getPropertyValue("description");
    }

    @Override
    public String getType() {
        return (String)this.getPropertyValue("type");
    }

    @Override
    public String getCreatedBy() {
        return (String)this.getPropertyValue("createdBy");
    }

    @Override
    public GregorianCalendar getCreatedAt() {
        if (this.creationDate == null) {
            GregorianCalendar g = null;
            Date d = DateUtils.parseJsonDate((String)this.getPropertyValue("createdAt"));
            if (d != null) {
                g = new GregorianCalendar();
                g.setTime(d);
            }
            this.creationDate = g;
        }
        return this.creationDate;
    }

    @Override
    public String getModifiedBy() {
        return (String)this.getPropertyValue("modifiedBy");
    }

    @Override
    public GregorianCalendar getModifiedAt() {
        if (this.modificationDate == null) {
            GregorianCalendar g = null;
            Date d = DateUtils.parseJsonDate((String)this.getPropertyValue("modifiedAt"));
            if (d != null) {
                g = new GregorianCalendar();
                g.setTime(d);
            }
            this.modificationDate = g;
        }
        return this.modificationDate;
    }

    @Override
    public Property getProperty(String name) {
        return this.getProp(name);
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public <T> T getPropertyValue(String name) {
        if (this.getProp(name) != null) {
            return this.getProp(name).getValue();
        }
        return null;
    }

    private PropertyImpl getProp(String name) {
        if (this.properties != null) {
            return (PropertyImpl)this.properties.get(name);
        }
        return null;
    }

    @Override
    public boolean hasAspect(String aspectName) {
        return false;
    }

    @Override
    public List<String> getAspects() {
        return new ArrayList<String>(0);
    }

    @Override
    public boolean hasAllProperties() {
        return this.hasAllProperties;
    }

    @Override
    public boolean isFolder() {
        return PublicAPIBaseTypeIds.FOLDER.value().equals(this.getProp("type").getValue());
    }

    @Override
    public boolean isDocument() {
        return PublicAPIBaseTypeIds.DOCUMENT.value().equals(this.getProp("type").getValue());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(Boolean.toString(this.hasAllProperties));
        dest.writeMap(this.properties);
    }

    public PublicAPINodeImpl(Parcel o) {
        this.properties = new HashMap<String, Property>();
        o.readMap(this.properties, this.getClass().getClassLoader());
        this.hasAllProperties = Boolean.parseBoolean(o.readString());
    }
}

