/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.model.impl.onpremise;

import org.alfresco.mobile.android.api.model.RepositoryCapabilities;
import org.alfresco.mobile.android.api.model.impl.AbstractRepositoryInfo;
import org.alfresco.mobile.android.api.model.impl.RepositoryVersionHelper;
import org.alfresco.mobile.android.api.model.impl.onpremise.OnPremiseRepositoryCapabilitiesImpl;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;

public class OnPremiseRepositoryInfoImpl
extends AbstractRepositoryInfo {
    private static final long serialVersionUID = 1L;
    private String edition = null;
    boolean hasPublicAPI = false;

    public OnPremiseRepositoryInfoImpl(RepositoryInfo repositoryInfo) {
        super(repositoryInfo);
    }

    public OnPremiseRepositoryInfoImpl(RepositoryInfo repositoryInfo, boolean hasPublicAPI) {
        super(repositoryInfo);
        this.hasPublicAPI = hasPublicAPI;
    }

    public OnPremiseRepositoryInfoImpl(RepositoryInfo repositoryInfo, String editionValue) {
        super(repositoryInfo);
        this.edition = editionValue;
    }

    @Override
    public String getVersion() {
        return this.repositoryInfo.getProductVersion();
    }

    @Override
    public Integer getMajorVersion() {
        return RepositoryVersionHelper.getVersion(this.getVersion(), 0);
    }

    @Override
    public Integer getMinorVersion() {
        return RepositoryVersionHelper.getVersion(this.getVersion(), 1);
    }

    @Override
    public Integer getMaintenanceVersion() {
        int separator = RepositoryVersionHelper.getVersionString(this.getVersion(), 2).indexOf(32);
        return Integer.parseInt(RepositoryVersionHelper.getVersionString(this.getVersion(), 2).substring(0, separator));
    }

    @Override
    public String getBuildNumber() {
        int separator = RepositoryVersionHelper.getVersionString(this.getVersion(), 2).indexOf(32);
        return RepositoryVersionHelper.getVersionString(this.getVersion(), 2).substring(separator);
    }

    @Override
    public String getEdition() {
        if (this.edition != null) {
            return this.edition;
        }
        if (this.repositoryInfo.getProductName().startsWith("Alfresco")) {
            if (this.repositoryInfo.getProductName().contains("Enterprise")) {
                return "Enterprise";
            }
            if (this.repositoryInfo.getProductName().contains("Community")) {
                return "Community";
            }
            return "unknown";
        }
        return this.repositoryInfo.getProductName();
    }

    public boolean isAlfrescoProduct() {
        if (this.repositoryInfo.getProductName() == null) {
            return false;
        }
        return this.repositoryInfo.getProductName().startsWith("Alfresco");
    }

    @Override
    public RepositoryCapabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new OnPremiseRepositoryCapabilitiesImpl(this);
        }
        return this.capabilities;
    }
}

