/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.model.impl.onpremise;

import android.text.TextUtils;
import org.alfresco.mobile.android.api.model.OperatorType;
import org.alfresco.mobile.android.api.model.RepositoryInfo;
import org.alfresco.mobile.android.api.model.impl.AbstractRepositoryCapabilities;
import org.alfresco.mobile.android.api.model.impl.RepositoryVersionHelper;
import org.alfresco.mobile.android.api.model.impl.onpremise.OnPremiseRepositoryInfoImpl;

public class OnPremiseRepositoryCapabilitiesImpl
extends AbstractRepositoryCapabilities {
    private static final long serialVersionUID = 1L;
    private RepositoryInfo repositoryInfo;

    public OnPremiseRepositoryCapabilitiesImpl(RepositoryInfo repositoryInfo) {
        this.repositoryInfo = repositoryInfo;
        this.capabilities.put("CAPABILITY_LIKE", this.supportLikingNodes());
        this.capabilities.put("CAPABILITY_COMMENTS_COUNT", this.supportCommentsCount());
    }

    private boolean supportLikingNodes() {
        if (!((OnPremiseRepositoryInfoImpl)this.repositoryInfo).isAlfrescoProduct()) {
            return false;
        }
        return this.repositoryInfo.getMajorVersion() >= 4;
    }

    private boolean supportCommentsCount() {
        if (!((OnPremiseRepositoryInfoImpl)this.repositoryInfo).isAlfrescoProduct()) {
            return false;
        }
        return this.repositoryInfo.getMajorVersion() >= 4;
    }

    @Override
    public boolean doesSupportPublicAPI() {
        return ((OnPremiseRepositoryInfoImpl)this.repositoryInfo).hasPublicAPI;
    }

    @Override
    public boolean doesSupportActivitiWorkflowEngine() {
        return this.repositoryInfo.getMajorVersion() >= 4;
    }

    @Override
    public boolean doesSupportJBPMWorkflowEngine() {
        return !this.doesSupportPublicAPI();
    }

    @Override
    public boolean doesSupportMyFiles() {
        if (!((OnPremiseRepositoryInfoImpl)this.repositoryInfo).isAlfrescoProduct()) {
            return false;
        }
        return this.evaluateRepositoryVersion("Enterprise", OperatorType.SUPERIOR_OR_EQUAL, 4, 2, null) || this.evaluateRepositoryVersion("Community", OperatorType.SUPERIOR_OR_EQUAL, 4, 2, "e");
    }

    @Override
    public boolean doesSupportSharedFiles() {
        if (!((OnPremiseRepositoryInfoImpl)this.repositoryInfo).isAlfrescoProduct()) {
            return false;
        }
        return this.evaluateRepositoryVersion("Enterprise", OperatorType.SUPERIOR_OR_EQUAL, 4, 2, null) || this.evaluateRepositoryVersion("Community", OperatorType.SUPERIOR_OR_EQUAL, 4, 2, "e");
    }

    public boolean evaluateRepositoryVersion(String edition, OperatorType operatorValue, Integer majorVersion, Integer minorVersion, String maintenanceVersion) {
        boolean result = true;
        if (!TextUtils.isEmpty((CharSequence)edition)) {
            result = this.repositoryInfo.getEdition().equalsIgnoreCase(edition);
        }
        if (!result) {
            return false;
        }
        OperatorType operator = OperatorType.EQUAL;
        if (operatorValue != null) {
            operator = operatorValue;
        }
        int versionNumber = 0;
        int repoVersionNumber = 0;
        if (majorVersion != null) {
            versionNumber += 100 * majorVersion;
            repoVersionNumber += 100 * this.repositoryInfo.getMajorVersion();
        }
        if (minorVersion != null) {
            versionNumber += 10 * minorVersion;
            repoVersionNumber += 10 * this.repositoryInfo.getMinorVersion();
        }
        if (maintenanceVersion != null) {
            if ("Enterprise".equals(this.repositoryInfo.getEdition())) {
                versionNumber += Integer.parseInt(maintenanceVersion);
                repoVersionNumber += this.repositoryInfo.getMaintenanceVersion().intValue();
            } else {
                return this.evaluate(operator, RepositoryVersionHelper.getVersionString(this.repositoryInfo.getVersion(), 2), maintenanceVersion);
            }
        }
        result = this.evaluate(operator, repoVersionNumber, versionNumber);
        return result;
    }

    private boolean evaluate(OperatorType operator, int value, int valueExpected) {
        switch (operator) {
            case INFERIOR: {
                return value < valueExpected;
            }
            case INFERIOR_OR_EQUAL: {
                return value <= valueExpected;
            }
            case SUPERIOR_OR_EQUAL: {
                return value >= valueExpected;
            }
            case SUPERIOR: {
                return value > valueExpected;
            }
        }
        return value == valueExpected;
    }

    private boolean evaluate(OperatorType operator, String value, String valueExpected) {
        int compareValue = value.compareTo(valueExpected);
        switch (operator) {
            case INFERIOR: {
                return compareValue < 0;
            }
            case INFERIOR_OR_EQUAL: {
                return compareValue <= 0;
            }
            case SUPERIOR_OR_EQUAL: {
                return compareValue >= 0;
            }
            case SUPERIOR: {
                return compareValue > 0;
            }
        }
        return compareValue == 0;
    }
}

