/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.model.impl;

import java.io.Serializable;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.alfresco.mobile.android.api.constants.WorkflowModel;
import org.alfresco.mobile.android.api.model.Process;
import org.alfresco.mobile.android.api.model.Property;
import org.alfresco.mobile.android.api.model.PropertyType;
import org.alfresco.mobile.android.api.model.Task;
import org.alfresco.mobile.android.api.model.impl.PersonImpl;
import org.alfresco.mobile.android.api.model.impl.ProcessImpl;
import org.alfresco.mobile.android.api.model.impl.PropertyImpl;
import org.alfresco.mobile.android.api.utils.DateUtils;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;

public class TaskImpl
implements Task {
    private static final long serialVersionUID = 1L;
    private String identifier;
    private String key;
    private String name;
    private String description;
    private Integer priority;
    private GregorianCalendar startedAt;
    private GregorianCalendar dueAt;
    private GregorianCalendar endedAt;
    private String processIdentifier;
    private String processDefinitionIdentifier;
    private String assignee;
    private boolean hasAllVariables;
    private Map<String, Serializable> data;
    private Map<String, Property> variables = new HashMap<String, Property>();
    private static final Map<String, VariableType> VARIABLE_TYPE = new HashMap<String, VariableType>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(WorkflowModel.PROP_TASK_ID, new VariableType(PropertyType.STRING));
            this.put(WorkflowModel.PROP_START_DATE, new VariableType(PropertyType.DATETIME));
            this.put(WorkflowModel.PROP_DUE_DATE, new VariableType(PropertyType.DATETIME));
            this.put(WorkflowModel.PROP_COMPLETION_DATE, new VariableType(PropertyType.DATETIME));
            this.put(WorkflowModel.PROP_PRIORITY, new VariableType(PropertyType.INTEGER));
            this.put(WorkflowModel.PROP_STATUS, new VariableType(PropertyType.STRING));
            this.put(WorkflowModel.PROP_PERCENT_COMPLETE, new VariableType(PropertyType.INTEGER));
            this.put(WorkflowModel.PROP_COMPLETED_ITEMS, new VariableType(PropertyType.STRING));
            this.put(WorkflowModel.PROP_COMMENT, new VariableType(PropertyType.STRING));
            this.put(WorkflowModel.ASSOC_POOLED_ACTORS, new VariableType(PropertyType.STRING, true));
            this.put(WorkflowModel.PROP_CONTEXT, new VariableType(PropertyType.STRING));
            this.put(WorkflowModel.PROP_DESCRIPTION, new VariableType(PropertyType.STRING));
            this.put(WorkflowModel.PROP_OUTCOME, new VariableType(PropertyType.STRING));
            this.put(WorkflowModel.PROP_PACKAGE_ACTION_GROUP, new VariableType(PropertyType.STRING));
            this.put(WorkflowModel.PROP_PACKAGE_ITEM_ACTION_GROUP, new VariableType(PropertyType.STRING));
            this.put(WorkflowModel.PROP_HIDDEN_TRANSITIONS, new VariableType(PropertyType.STRING));
            this.put(WorkflowModel.PROP_REASSIGNABLE, new VariableType(PropertyType.BOOLEAN));
            this.put(WorkflowModel.ASSOC_PACKAGE, new VariableType(PropertyType.STRING));
            this.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, new VariableType(PropertyType.STRING));
            this.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, new VariableType(PropertyType.INTEGER));
            this.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, new VariableType(PropertyType.DATETIME));
            this.put(WorkflowModel.PROP_ASSIGNEE, new VariableType(PropertyType.STRING));
            this.put(WorkflowModel.PROP_OUTCOME_PROPERTY_NAME, new VariableType(PropertyType.STRING));
            this.put(WorkflowModel.PROP_REVIEW_OUTCOME, new VariableType(PropertyType.STRING));
            this.put(WorkflowModel.PROP_CONTENT, new VariableType(PropertyType.STRING));
            this.put(WorkflowModel.PROP_CREATED, new VariableType(PropertyType.DATETIME));
            this.put(WorkflowModel.PROP_NAME, new VariableType(PropertyType.STRING));
            this.put(WorkflowModel.PROP_OWNER, new VariableType(PropertyType.STRING));
            this.put("companyhome", new VariableType(PropertyType.STRING));
            this.put("initiator", new VariableType(PropertyType.STRING));
            this.put("cancelled", new VariableType(PropertyType.BOOLEAN));
            this.put("initiatorhome", new VariableType(PropertyType.STRING));
            this.put(WorkflowModel.PROP_NOTIFYME, new VariableType(PropertyType.BOOLEAN));
        }
    };

    public static Task parseJson(Map<String, Object> json) {
        if (json == null) {
            return null;
        }
        TaskImpl task = new TaskImpl();
        task.data = new HashMap<String, Serializable>();
        task.identifier = JSONConverter.getString(json, (String)"id");
        task.key = JSONConverter.getString(json, (String)"name");
        task.description = JSONConverter.getString(json, (String)"description");
        task.name = JSONConverter.getString(json, (String)"title");
        task.data.put("state", (Serializable)((Object)JSONConverter.getString(json, (String)"state")));
        task.data.put("isPooled", JSONConverter.getBoolean(json, (String)"isPooled"));
        task.data.put("isEditable", JSONConverter.getBoolean(json, (String)"isEditable"));
        task.data.put("isReassignable", JSONConverter.getBoolean(json, (String)"isReassignable"));
        task.data.put("isClaimable", JSONConverter.getBoolean(json, (String)"isClaimable"));
        task.data.put("isReleasable", JSONConverter.getBoolean(json, (String)"isReleasable"));
        task.data.put("outcome", JSONConverter.getBoolean(json, (String)"outcome"));
        Map data = (Map)json.get("owner");
        if (data != null) {
            task.data.put("owner", PersonImpl.parseJson(data));
            task.assignee = JSONConverter.getString((Map)data, (String)"userName");
            data.clear();
        }
        if ((data = (Map)json.get("properties")) != null) {
            task.variables = TaskImpl.parseProperties(data);
            task.description = (String)task.variables.get(WorkflowModel.PROP_DESCRIPTION).getValue();
            task.priority = (Integer)task.variables.get(WorkflowModel.PROP_PRIORITY).getValue();
            task.startedAt = (GregorianCalendar)task.variables.get(WorkflowModel.PROP_START_DATE).getValue();
            if (task.startedAt == null) {
                task.startedAt = (GregorianCalendar)task.variables.get(WorkflowModel.PROP_CREATED).getValue();
            }
            task.dueAt = (GregorianCalendar)task.variables.get(WorkflowModel.PROP_DUE_DATE).getValue();
            task.endedAt = (GregorianCalendar)task.variables.get(WorkflowModel.PROP_COMPLETION_DATE).getValue();
            task.hasAllVariables = true;
        } else {
            task.hasAllVariables = false;
        }
        data = (Map)json.get("workflowInstance");
        if (data != null) {
            Process p = ProcessImpl.parseJson(data);
            task.data.put("workflowInstance", p);
            task.processIdentifier = p.getIdentifier();
            task.processDefinitionIdentifier = p.getDefinitionIdentifier();
            data.clear();
        }
        return task;
    }

    public static Task refreshTask(Task task, Map<String, Property> properties) {
        if (task == null) {
            return null;
        }
        if (properties == null) {
            return task;
        }
        TaskImpl refreshedTask = new TaskImpl();
        refreshedTask.identifier = task.getIdentifier();
        refreshedTask.processIdentifier = task.getProcessIdentifier();
        refreshedTask.processDefinitionIdentifier = task.getProcessDefinitionIdentifier();
        refreshedTask.key = task.getKey();
        refreshedTask.startedAt = task.getStartedAt();
        refreshedTask.endedAt = task.getEndedAt();
        refreshedTask.description = task.getDescription();
        refreshedTask.priority = task.getPriority();
        refreshedTask.assignee = task.getAssigneeIdentifier();
        refreshedTask.name = task.getName();
        refreshedTask.dueAt = task.getDueAt();
        refreshedTask.variables = properties;
        refreshedTask.hasAllVariables = true;
        return refreshedTask;
    }

    public static Task parsePublicAPIJson(Map<String, Object> json) {
        String endedAt;
        if (json == null) {
            return null;
        }
        TaskImpl task = new TaskImpl();
        task.identifier = JSONConverter.getString(json, (String)"id");
        task.priority = JSONConverter.getInteger(json, (String)"priority").intValue();
        task.key = JSONConverter.getString(json, (String)"formResourceKey");
        if (task.key == null) {
            task.key = JSONConverter.getString(json, (String)"activityDefinitionId");
        }
        task.name = JSONConverter.getString(json, (String)"name");
        String startedAt = JSONConverter.getString(json, (String)"startedAt");
        GregorianCalendar g = new GregorianCalendar();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.getDefault());
        g.setTime(DateUtils.parseDate(startedAt, sdf));
        task.startedAt = g;
        String dueAt = JSONConverter.getString(json, (String)"dueAt");
        if (dueAt != null) {
            g = new GregorianCalendar();
            g.setTime(DateUtils.parseDate(dueAt, sdf));
            task.dueAt = g;
        }
        if ((endedAt = JSONConverter.getString(json, (String)"endedAt")) != null) {
            g = new GregorianCalendar();
            g.setTime(DateUtils.parseDate(endedAt, sdf));
            task.endedAt = g;
        }
        task.description = JSONConverter.getString(json, (String)"description");
        task.name = JSONConverter.getString(json, (String)"name");
        task.assignee = JSONConverter.getString(json, (String)"assignee");
        task.processIdentifier = JSONConverter.getString(json, (String)"processId");
        task.processDefinitionIdentifier = JSONConverter.getString(json, (String)"processDefinitionId");
        task.data = new HashMap<String, Serializable>();
        task.data.put("state", (Serializable)((Object)JSONConverter.getString(json, (String)"state")));
        return task;
    }

    private static Map<String, Property> parseProperties(Map<String, Object> data) {
        HashMap<String, Property> properties = new HashMap<String, Property>(data.size());
        String translatedKey = null;
        GregorianCalendar g = new GregorianCalendar();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.getDefault());
        block4: for (Map.Entry<String, Object> entry : data.entrySet()) {
            translatedKey = entry.getKey().replace("_", ":");
            VariableType variableType = VARIABLE_TYPE.get(translatedKey);
            if (variableType == null) continue;
            if (entry.getValue() == null || entry.getValue() instanceof String && ((String)entry.getValue()).isEmpty()) {
                properties.put(translatedKey, new PropertyImpl(null, variableType.propertyType, variableType.isMultiValued));
                continue;
            }
            switch (variableType.propertyType) {
                case DATETIME: {
                    g = new GregorianCalendar();
                    g.setTime(DateUtils.parseDate((String)entry.getValue(), sdf));
                    properties.put(translatedKey, new PropertyImpl(g, variableType.propertyType, variableType.isMultiValued));
                    continue block4;
                }
                case INTEGER: {
                    properties.put(translatedKey, new PropertyImpl(((BigInteger)entry.getValue()).intValue(), variableType.propertyType, variableType.isMultiValued));
                    continue block4;
                }
            }
            properties.put(translatedKey, new PropertyImpl(entry.getValue(), variableType.propertyType, variableType.isMultiValued));
        }
        return properties;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public GregorianCalendar getStartedAt() {
        return this.startedAt;
    }

    public Map<String, Serializable> getData() {
        return this.data;
    }

    @Override
    public String getProcessIdentifier() {
        return this.processIdentifier;
    }

    @Override
    public String getProcessDefinitionIdentifier() {
        return this.processDefinitionIdentifier;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getPriority() {
        if (this.priority == null) {
            return -1;
        }
        return this.priority;
    }

    @Override
    public String getAssigneeIdentifier() {
        return this.assignee;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public GregorianCalendar getDueAt() {
        return this.dueAt;
    }

    @Override
    public GregorianCalendar getEndedAt() {
        return this.endedAt;
    }

    @Override
    public boolean hasAllVariables() {
        return this.hasAllVariables;
    }

    @Override
    public Property getVariable(String name) {
        return this.variables.get(name);
    }

    @Override
    public Map<String, Property> getVariables() {
        return new HashMap<String, Property>(this.variables);
    }

    @Override
    public <T> T getVariableValue(String name) {
        if (this.variables.get(name) != null) {
            return this.variables.get(name).getValue();
        }
        return null;
    }

    @Override
    public boolean hasCompleted() {
        return this.endedAt != null;
    }

    private static class VariableType {
        public PropertyType propertyType;
        public boolean isMultiValued;

        public VariableType(PropertyType type) {
            this.propertyType = type;
            this.isMultiValued = false;
        }

        public VariableType(PropertyType type, boolean isMultiValued) {
            this.propertyType = type;
            this.isMultiValued = isMultiValued;
        }
    }
}

