/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.model.impl;

import java.util.Map;
import org.alfresco.mobile.android.api.model.Site;
import org.alfresco.mobile.android.api.model.SiteVisibility;
import org.alfresco.mobile.android.api.utils.NodeRefUtils;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;

public class SiteImpl
implements Site {
    private static final long serialVersionUID = 1L;
    private String identifier;
    private String title;
    private String description;
    private String visibility;
    private String nodeIdentifier;
    private Boolean isMember = false;
    private Boolean isPendingMember = false;
    private Boolean isFavorite = false;

    public SiteImpl() {
    }

    public SiteImpl(Site site, boolean isPendingMember, boolean isMember, boolean isFavorite) {
        this.identifier = site.getShortName();
        this.title = site.getTitle();
        this.description = site.getDescription();
        this.visibility = site.getVisibility().value();
        this.nodeIdentifier = site.getGUID();
        this.isPendingMember = isPendingMember;
        this.isMember = isMember;
        this.isFavorite = isFavorite;
    }

    public static SiteImpl parseJson(Map<String, Object> json) {
        SiteImpl site = new SiteImpl();
        site.identifier = JSONConverter.getString(json, (String)"shortName");
        site.title = JSONConverter.getString(json, (String)"title");
        site.description = JSONConverter.getString(json, (String)"description");
        if (site.description.length() == 0) {
            site.description = null;
        }
        site.nodeIdentifier = JSONConverter.getString(json, (String)"node");
        int lastForwardSlash = site.nodeIdentifier.lastIndexOf(47);
        site.nodeIdentifier = NodeRefUtils.createNodeRefByIdentifier(site.nodeIdentifier.substring(lastForwardSlash));
        site.visibility = JSONConverter.getString(json, (String)"visibility");
        site.isPendingMember = JSONConverter.getBoolean(json, (String)"isPendingMember") != null ? JSONConverter.getBoolean(json, (String)"isPendingMember") : false;
        site.isMember = JSONConverter.getBoolean(json, (String)"isMember") != null ? JSONConverter.getBoolean(json, (String)"isMember") : false;
        site.isFavorite = JSONConverter.getBoolean(json, (String)"isFavorite") != null ? JSONConverter.getBoolean(json, (String)"isFavorite") : false;
        return site;
    }

    public static SiteImpl parseCompatJson(Map<String, Object> json) {
        SiteImpl site = new SiteImpl();
        site.identifier = JSONConverter.getString(json, (String)"shortName");
        site.title = JSONConverter.getString(json, (String)"title");
        site.description = JSONConverter.getString(json, (String)"description");
        if (site.description.length() == 0) {
            site.description = null;
        }
        site.nodeIdentifier = JSONConverter.getString(json, (String)"node");
        int lastForwardSlash = site.nodeIdentifier.lastIndexOf(47);
        site.nodeIdentifier = site.nodeIdentifier.substring(lastForwardSlash + 1);
        site.visibility = JSONConverter.getString(json, (String)"visibility");
        site.isPendingMember = JSONConverter.getBoolean(json, (String)"isPendingMember") != null ? JSONConverter.getBoolean(json, (String)"isPendingMember") : false;
        site.isMember = JSONConverter.getBoolean(json, (String)"isMember") != null ? JSONConverter.getBoolean(json, (String)"isMember") : false;
        site.isFavorite = JSONConverter.getBoolean(json, (String)"isFavorite") != null ? JSONConverter.getBoolean(json, (String)"isFavorite") : false;
        return site;
    }

    public static SiteImpl parsePublicAPIJson(Map<String, Object> json) {
        SiteImpl site = new SiteImpl();
        site.identifier = JSONConverter.getString(json, (String)"id");
        site.title = JSONConverter.getString(json, (String)"title");
        site.description = JSONConverter.getString(json, (String)"description");
        site.visibility = JSONConverter.getString(json, (String)"visibility");
        site.nodeIdentifier = JSONConverter.getString(json, (String)"guid");
        site.isPendingMember = JSONConverter.getBoolean(json, (String)"isPendingMember") != null ? JSONConverter.getBoolean(json, (String)"isPendingMember") : false;
        site.isMember = json.containsKey("role") ? Boolean.valueOf(true) : Boolean.valueOf(JSONConverter.getBoolean(json, (String)"isMember") != null ? JSONConverter.getBoolean(json, (String)"isMember") : false);
        site.isFavorite = JSONConverter.getBoolean(json, (String)"isFavorite") != null ? JSONConverter.getBoolean(json, (String)"isFavorite") : false;
        return site;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getShortName() {
        return this.identifier;
    }

    @Override
    public SiteVisibility getVisibility() {
        return SiteVisibility.fromValue(this.visibility);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getGUID() {
        return this.nodeIdentifier;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Site) {
            return this.getIdentifier().equals(((Site)obj).getIdentifier());
        }
        return super.equals(obj);
    }

    @Override
    public boolean isMember() {
        return this.isMember;
    }

    @Override
    public boolean isPendingMember() {
        return this.isPendingMember;
    }

    @Override
    public boolean isFavorite() {
        return this.isFavorite;
    }
}

