/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.model.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.mobile.android.api.model.impl.onpremise.OnPremiseRepositoryInfoImpl;
import org.alfresco.mobile.android.api.session.AlfrescoSession;
import org.alfresco.mobile.android.api.session.CloudSession;
import org.alfresco.mobile.android.api.session.RepositorySession;

public final class RepositoryVersionHelper {
    private static final Pattern VERSIONPATTERN = Pattern.compile("\\d*\\d*\\d*.*");

    private RepositoryVersionHelper() {
    }

    public static String getVersionString(String productVersion, int level) {
        if (!RepositoryVersionHelper.isVersion(productVersion)) {
            return null;
        }
        String[] versions = productVersion.split("\\.");
        if (versions.length >= level + 1) {
            return versions[level];
        }
        return null;
    }

    public static Integer getVersion(String productVersion, int level) {
        String version = RepositoryVersionHelper.getVersionString(productVersion, level);
        if (version != null) {
            return Integer.parseInt(version);
        }
        return null;
    }

    private static boolean isVersion(String productVersion) {
        Matcher matcher = VERSIONPATTERN.matcher(productVersion);
        return matcher.matches();
    }

    public static boolean isAlfrescoProduct(AlfrescoSession repoSession) {
        if (repoSession == null) {
            return false;
        }
        if (repoSession instanceof CloudSession) {
            return true;
        }
        if (repoSession instanceof RepositorySession && repoSession.getRepositoryInfo() != null) {
            return ((OnPremiseRepositoryInfoImpl)repoSession.getRepositoryInfo()).isAlfrescoProduct();
        }
        return false;
    }
}

