/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.model.impl;

import java.util.GregorianCalendar;
import org.alfresco.mobile.android.api.model.Property;
import org.alfresco.mobile.android.api.model.PropertyType;

public class PropertyImpl
implements Property {
    private static final long serialVersionUID = 1L;
    private org.apache.chemistry.opencmis.client.api.Property prop;
    private Object value;
    private PropertyType type;
    private Boolean isMultiValued;
    private String displayName;

    public PropertyImpl(org.apache.chemistry.opencmis.client.api.Property prop) {
        this.prop = prop;
    }

    public PropertyImpl(Object value) {
        this.value = value;
    }

    public PropertyImpl(Object value, PropertyType type) {
        this.value = value;
        this.type = type;
    }

    public PropertyImpl(Object value, PropertyType type, Boolean isMultiValued) {
        this.value = value;
        this.type = type;
        this.isMultiValued = isMultiValued;
    }

    public PropertyImpl(String displayName, Object value, PropertyType type, Boolean isMultiValued) {
        this.displayName = displayName;
        this.value = value;
        this.type = type;
        this.isMultiValued = isMultiValued;
    }

    @Override
    public boolean isMultiValued() {
        if (this.prop != null) {
            return this.prop.isMultiValued();
        }
        if (this.isMultiValued != null) {
            return this.isMultiValued;
        }
        return false;
    }

    @Override
    public PropertyType getType() {
        if (this.prop != null) {
            return PropertyType.fromValue(this.prop.getType().value());
        }
        if (this.type != null) {
            return this.type;
        }
        return null;
    }

    @Override
    public <T> T getValue() {
        if (this.prop != null) {
            return (T)this.prop.getValue();
        }
        if (this.value != null) {
            return (T)this.value;
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        if (this.prop != null) {
            return this.prop.getDisplayName();
        }
        if (this.displayName != null) {
            return this.displayName;
        }
        return null;
    }

    public String getStringValue() {
        return this.formatValue(this.getValue());
    }

    private String formatValue(Object object) {
        if (object == null) {
            return null;
        }
        String result = object instanceof GregorianCalendar ? ((GregorianCalendar)object).getTime().toString() : object.toString();
        return result;
    }
}

