/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.mobile.android.api.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.mobile.android.api.constants.ModelMappingUtils;
import org.alfresco.mobile.android.api.model.PropertyDefinition;
import org.alfresco.mobile.android.api.model.PropertyType;
import org.apache.chemistry.opencmis.commons.definitions.Choice;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.Updatability;

public class PropertyDefinitionImpl
implements PropertyDefinition {
    private static final long serialVersionUID = 1L;
    private org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition propertyDefinition;
    private boolean isCmis = false;

    public PropertyDefinitionImpl() {
    }

    public PropertyDefinitionImpl(org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition propertyDefinition) {
        this.propertyDefinition = propertyDefinition;
    }

    public PropertyDefinitionImpl(boolean isCmis, org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition propertyDefinition) {
        this.propertyDefinition = propertyDefinition;
        this.isCmis = isCmis;
    }

    @Override
    public String getName() {
        if (this.propertyDefinition != null) {
            return this.isCmis ? this.propertyDefinition.getId() : ModelMappingUtils.getAlfrescoPropertyName(this.propertyDefinition.getId());
        }
        return null;
    }

    @Override
    public String getTitle() {
        if (this.propertyDefinition != null) {
            return this.isCmis ? this.propertyDefinition.getDisplayName() : ModelMappingUtils.getAlfrescoPropertyName(this.propertyDefinition.getDisplayName());
        }
        return null;
    }

    @Override
    public String getDescription() {
        if (this.propertyDefinition != null) {
            return this.propertyDefinition.getDescription();
        }
        return null;
    }

    @Override
    public PropertyType getType() {
        if (this.propertyDefinition != null) {
            org.apache.chemistry.opencmis.commons.enums.PropertyType propertyType = this.propertyDefinition.getPropertyType();
            try {
                return PropertyType.fromValue(propertyType.value());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isRequired() {
        if (this.propertyDefinition != null) {
            if ("cmis:name".equals(this.propertyDefinition.getId())) {
                return true;
            }
            return this.propertyDefinition.isRequired();
        }
        return false;
    }

    @Override
    public boolean isMultiValued() {
        if (this.propertyDefinition != null && this.propertyDefinition.getCardinality() != null) {
            return this.propertyDefinition.getCardinality().equals((Object)Cardinality.MULTI);
        }
        return false;
    }

    @Override
    public boolean isReadOnly() {
        if (this.propertyDefinition != null && this.propertyDefinition.getUpdatability() != null) {
            return this.propertyDefinition.getUpdatability().equals((Object)Updatability.READONLY);
        }
        return false;
    }

    @Override
    public <T> T getDefaultValue() {
        if (this.propertyDefinition != null) {
            return (T)this.propertyDefinition.getDefaultValue();
        }
        return null;
    }

    @Override
    public List<Map<String, Object>> getAllowableValues() {
        ArrayList<Map<String, Object>> list = null;
        if (this.propertyDefinition != null && this.propertyDefinition.getChoices() != null) {
            list = new ArrayList<Map<String, Object>>(this.propertyDefinition.getChoices().size());
            for (Object choice : this.propertyDefinition.getChoices()) {
                HashMap<String, List> mapValues = new HashMap<String, List>();
                mapValues.put(((Choice)choice).getDisplayName(), ((Choice)choice).getValue());
                list.add(mapValues);
            }
            return list;
        }
        return new ArrayList<Map<String, Object>>(0);
    }
}

